/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.client.tree.JobCategoryNodeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.TemplateFolderInfo;
import com.kingdee.eas.tools.datatask.client.TemplateNodeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TemplateTreeBuilder {
    private static int initlevel = 5;

    public void buildTree(final KDTree tree, TemplateNodeInfo info) throws Exception {
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(true);
        }
        TemplateFolderInfo tfInfo = info == null ? null : info.getTemplateFolderInfo();
        IRowSet rowSet = this.getChildrenRowSet(tfInfo, initlevel);
        this.buildChildrenByRowSet(rootNode, rowSet, initlevel);
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                try {
                    TemplateTreeBuilder.this.getChildren((KDTreeNode)event.getPath().getLastPathComponent());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    TemplateTreeBuilder.this.getChildren((KDTreeNode)e.getPath().getLastPathComponent());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
    }

    private void getChildren(KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            TemplateNodeInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof JobCategoryNodeInfo) {
                treeNodeInfo = (TemplateNodeInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            treeNode.removeAllChildren();
            if (treeNodeInfo != null) {
                this.buildChildrenByRowSet(treeNode, this.getChildrenRowSet(treeNodeInfo.getTemplateFolderInfo(), initlevel), initlevel);
            }
        }
    }

    private IRowSet getTreeRowSet(String parentId, int level) {
        String query = "com.kingdee.eas.tools.datatask.app.DIETemplateQuery";
        IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((String)query);
        return null;
    }

    public IRowSet getChildrenRowSet(TemplateFolderInfo parentNodeInfo, int level) throws Exception {
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (parentNodeInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel() + level), CompareType.LESS_EQUALS));
            filter.setMaskString("#0 and #1 and #2 ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level), CompareType.LESS_EQUALS));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.tools.datatask.app.DIETemplateFolderQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    private void buildChildrenByRowSet(KDTreeNode parentNode, IRowSet rows, int level) throws Exception {
        KDTreeNode beforeTreeNode = parentNode;
        TemplateNodeInfo treeNodeInfo = null;
        KDTreeNode treeNode = null;
        while (rows.next()) {
            treeNodeInfo = this.createTemplateNodeInfo2(rows);
            treeNode = new KDTreeNode((Object)treeNodeInfo);
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTbtn_business"));
            TemplateFolderInfo tfInfo = treeNodeInfo.getTemplateFolderInfo();
            if (tfInfo.isIsLeaf() || tfInfo.getLevel() < beforeTreeNode.getLevel() + level) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            int beforeLevel = -1;
            if (beforeTreeNode != null && beforeTreeNode.getUserObject() != null) {
                beforeLevel = ((TemplateNodeInfo)beforeTreeNode.getUserObject()).getTemplateFolderInfo().getLevel();
            }
            int curLevel = tfInfo.getLevel();
            while (beforeLevel >= curLevel) {
                beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                --beforeLevel;
            }
            if (beforeTreeNode.getUserObject() != null) {
                beforeTreeNode.add((MutableTreeNode)treeNode);
                beforeTreeNode = treeNode;
                continue;
            }
            beforeTreeNode.setUserObject(treeNode.getUserObject());
        }
    }

    private TemplateNodeInfo createTemplateNodeInfo2(IRowSet rows) throws Exception {
        TemplateFolderInfo folderInfo = new TemplateFolderInfo();
        folderInfo.setId(BOSUuid.read((String)rows.getString("id")));
        folderInfo.setName(rows.getString("name"));
        folderInfo.setNumber(rows.getString("number"));
        folderInfo.setLevel(rows.getInt("level"));
        folderInfo.setLongNumber(rows.getString("longNumber"));
        folderInfo.setIsLeaf(rows.getBoolean("isLeaf"));
        TemplateNodeInfo nodeInfo = new TemplateNodeInfo();
        nodeInfo.setTemplateFolderInfo(folderInfo);
        return nodeInfo;
    }
}

