/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.TemplateConfigInfo;
import com.kingdee.eas.tools.datatask.client.AbstractUserDefineTemplateSltUI;
import com.kingdee.eas.tools.datatask.client.UIUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserDefineTemplateSltUI
extends AbstractUserDefineTemplateSltUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDefineTemplateSltUI.class);
    private Map ctx = null;
    private static final String RESOURCE = "com.kingdee.eas.tools.datatask.DatataskResource";

    public UserDefineTemplateSltUI(Map context) throws Exception {
        this.ctx = context;
        this.init();
    }

    private void init() {
        this.prmtSltTemplate.setQueryInfo("com.kingdee.eas.tools.datatask.app.F7DIETemplateQuery");
        this.prmtSltTemplate.setDisplayFormat("$number$-$name$");
        this.prmtSltTemplate.setCommitFormat("$number$");
        this.prmtSltTemplate.setEditFormat("$number$-$name$");
        this.prmtSltTemplate.setEnabled(true);
        this.prmtSltTemplate.setEditable(true);
        this.prmtSltTemplate.setRequired(true);
        this.prmtSltTemplate.setEnabled(false);
        DIETemplateInfo info = null;
        if (this.ctx != null && this.ctx.get("selectedData") != null) {
            String id = (String)this.ctx.get("selectedData");
            try {
                IDIETemplate dt = DIETemplateFactory.getRemoteInstance();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("name"));
                info = dt.getDIETemplateInfo((IObjectPK)new ObjectUuidPK(id), selector);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.prmtSltTemplate.setData(info);
        if (this.editData == null) {
            this.editData = new DIETemplateInfo();
            this.editData.setAllowAddNewImport(true);
        }
        if (this.tcInfo == null) {
            this.tcInfo = new TemplateConfigInfo();
        }
        this.labMsg.setText(EASResource.getString((String)RESOURCE, (String)"addtemplate"));
        this.btnAddTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefineTemplateSltUI.this.selectedChanged(true);
            }
        });
        this.btnEditTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefineTemplateSltUI.this.selectedChanged(false);
            }
        });
    }

    private void selectedChanged(boolean isSltedAddTemplate) {
        if (isSltedAddTemplate) {
            this.labMsg.setText(EASResource.getString((String)RESOURCE, (String)"addtemplate"));
            this.prmtSltTemplate.setEnabled(false);
        } else {
            this.labMsg.setText(EASResource.getString((String)RESOURCE, (String)"edittemplate"));
            this.prmtSltTemplate.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        boolean b = true;
        if (this.tcInfo != null) {
            b = this.tcInfo.isAddTemplateType();
        }
        if (b) {
            this.btnAddTemplate.setSelected(true);
        } else {
            this.btnEditTemplate.setSelected(true);
        }
    }

    public boolean isSelectAddTemplate() {
        return this.btnAddTemplate.isSelected();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.tcInfo.setAddTemplateType(this.isSelectAddTemplate());
        if (!this.isSelectAddTemplate()) {
            DIETemplateInfo dtInfo = (DIETemplateInfo)this.prmtSltTemplate.getData();
            try {
                if (this.editData.getId() == null || !dtInfo.getId().toString().equals(this.editData.getId().toString())) {
                    IDIETemplate dt = DIETemplateFactory.getRemoteInstance();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("*"));
                    selector.add(new SelectorItemInfo("parentFolder.id"));
                    selector.add(new SelectorItemInfo("parentFolder.name"));
                    selector.add(new SelectorItemInfo("parentFolder.number"));
                    selector.add(new SelectorItemInfo("fieldEntries.*"));
                    selector.add(new SelectorItemInfo("parentFolder.*"));
                    this.editData = dt.getDIETemplateInfo((IObjectPK)new ObjectUuidPK(dtInfo.getId()), selector);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.isStored = true;
    }

    @Override
    public void actionPrevious_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrevious_actionPerformed(e);
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    @Override
    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinish_actionPerformed(e);
    }

    @Override
    protected boolean verifyInput() {
        if (!this.isSelectAddTemplate() && this.prmtSltTemplate.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"sltTemplate"));
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        if (this.getTcInfo() == null || this.getTcInfo().isAddTemplateType()) {
            return true;
        }
        return this.getTcInfo().isAddTemplateType() || !this.getTcInfo().isAddTemplateType() && !UIUtil.isNull(this.prmtSltTemplate.getData());
    }
}

