/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.Excel2007SheetWriter;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.IExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExcelWritingException;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractExternalExcel2007SheetWriter
extends Excel2007SheetWriter
implements IExternalExcelDataWriter {
    private static final Logger logger = Logger.getLogger(AbstractExternalExcel2007SheetWriter.class);
    private String sheetName;
    protected XSSFSheet sheet = null;
    private CellStyle valueStyle = null;
    private CellStyle titleStyle = null;
    private CellStyle orgStructStyle1 = null;
    private CellStyle orgStructStyle = null;
    private CellStyle orgStructNeedCellStyle = null;
    private CellStyle dateStyle = null;
    private CellStyle dateTimeStyle = null;
    private CellStyle digitStyle = null;
    private CellStyle customDigitStyle = null;
    private Map<Integer, CellStyle> styleCache = new HashMap<Integer, CellStyle>(6);
    private Locale locale = null;
    private boolean isEndSheet = true;
    protected int curRowNum = -1;
    private List<String> fieldOrder = new ArrayList<String>();
    protected boolean isHasComment = false;

    public AbstractExternalExcel2007SheetWriter(Excel2007Writer excelWriter) {
        super(excelWriter);
        this.initCellStyle();
    }

    protected abstract List<String> getFieldOrder();

    protected abstract void megeCell() throws IOException;

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        try {
            this.defaultColStyle(structInfo.getFieldCollection().size());
            this.beginSheetData();
            this.fieldOrder = this.getFieldOrder();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void setDimension(int rowspan, int colspan) {
        String dimension = ExcelUtil.getDimension(rowspan, colspan);
        try {
            this.setDimension(dimension);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public void defaultColStyle(int colsize) throws IOException {
        this.beginCols();
        for (int i = 0; i < colsize; ++i) {
            this.insertDefaultColStyle(i + 1, 20);
        }
        this.endCols();
    }

    @Override
    public void writeLine(Map data) throws TaskRunnerException {
        try {
            this.insertRow(this.curRowNum);
            int size = this.fieldOrder.size();
            for (int i = 0; i < size; ++i) {
                Object cellValue = data.get(this.fieldOrder.get(i));
                if (cellValue == null || StringUtils.isEmpty((String)cellValue.toString())) continue;
                this.writeCell(this.curRowNum, i, cellValue);
            }
            this.endRow();
            ++this.curRowNum;
        }
        catch (Exception ex) {
            throw new TaskRunnerException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openWriter() throws TaskRunnerException {
        try {
            XSSFWorkbook xSSFWorkbook = this.getExcelWriter().getWb();
            synchronized (xSSFWorkbook) {
                this.sheet = this.getWb().createSheet(this.sheetName);
            }
            String sheetRef = this.sheet.getPackagePart().getPartName().getName();
            File tmp = File.createTempFile("sheet", ".xml");
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF-8");
            this.setSw(new Excel2007SheetWriter.SpreadsheetWriter(fw));
            this.beginWorkSheet();
            this.isEndSheet = false;
            this.putSheetFile(sheetRef, tmp);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void closeWriter() throws TaskRunnerException {
        try {
            if (!this.isEndSheet) {
                this.endSheetData();
                this.megeCell();
                if (this.isHasComment) {
                    this.writeComment();
                }
                this.endWorkSheet();
                this.getSw().get_out().close();
                this.isHasComment = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void initCellStyle() {
        this.createOrgStructCellStyle();
        this.createOrgStructCellStyle1();
        this.createOrgStructNeedCellStyle();
        this.createTitleCellStyle();
        this.createValueCellStyle();
        this.createDateCellStyle();
        this.createDateTimeCellStyle();
        this.createDigitStyle();
        this.createCustomDigitStyle();
    }

    public void writeCell(int row, int col, DataToken data) throws ExcelWritingException {
        if (data != null) {
            this.writeCell(row, col, data.data);
        } else {
            this.writeCell(row, col, "");
        }
    }

    public void writeCell(int row, int col, Object data) throws ExcelWritingException {
        if (this.sheet == null) {
            String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "visitpage", this.locale) + this.sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fail", this.locale);
            ExcelWritingException err = new ExcelWritingException(detail);
            throw err;
        }
        try {
            this.addValueCell((Sheet)this.sheet, row, col, data);
        }
        catch (Exception ex) {
            throw new ExcelWritingException(ex.getMessage(), ex.getCause());
        }
    }

    public void addValueCell(Sheet sht, int rowNum, int colNum, Object value) throws Exception {
        if (value == null) {
            this.createCell(colNum, "", (int)this.valueStyle.getIndex());
            return;
        }
        if (value instanceof String) {
            this.createCell(colNum, (String)value, (int)this.valueStyle.getIndex());
        } else if (value instanceof Float) {
            this.createCell(colNum, ((Float)value).floatValue(), (int)this.digitStyle.getIndex());
        } else if (value instanceof Integer) {
            this.createCell(colNum, (Integer)value, (int)this.customDigitStyle.getIndex());
        } else if (value instanceof Double) {
            this.createCell(colNum, (Double)value, (int)this.digitStyle.getIndex());
        } else if (value instanceof BigDecimal) {
            this.createCell(colNum, (BigDecimal)value, (int)this.createDynamicStyle(((BigDecimal)value).scale()).getIndex());
        } else if (value instanceof Date) {
            this.createCell(colNum, value.toString(), (int)this.valueStyle.getIndex());
        } else if (value instanceof Timestamp) {
            this.createCell(colNum, (Date)value, (int)this.dateTimeStyle.getIndex());
        } else if (value instanceof Boolean) {
            this.createCell(colNum, (Boolean)value, (int)this.valueStyle.getIndex());
        } else {
            this.createCell(colNum, value.toString(), (int)this.valueStyle.getIndex());
        }
    }

    public void addOrgStructCell(int colNum, String value) throws Exception {
        this.createCell(colNum, value, (int)this.orgStructStyle.getIndex());
    }

    public void addOrgStructCell1(int colNum, String value, boolean isNecessary) throws Exception {
        if (isNecessary) {
            this.createCell(colNum, value, (int)this.orgStructNeedCellStyle.getIndex());
        } else {
            this.createCell(colNum, value, (int)this.orgStructStyle1.getIndex());
        }
    }

    public void addTitleCell(int colNum, String value) throws Exception {
        this.createCell(colNum, value, (int)this.titleStyle.getIndex());
    }

    private void createOrgStructCellStyle() {
        this.orgStructStyle = null;
        if (this.orgStructStyle == null) {
            this.orgStructStyle = this.getWb().createCellStyle();
            this.orgStructStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
            this.orgStructStyle.setAlignment(HorizontalAlignment.LEFT);
            this.orgStructStyle.setHidden(false);
            this.orgStructStyle.setLocked(false);
            this.orgStructStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle.setBottomBorderColor(backColorIndex);
            this.orgStructStyle.setTopBorderColor(backColorIndex);
            this.orgStructStyle.setLeftBorderColor(backColorIndex);
            this.orgStructStyle.setRightBorderColor(backColorIndex);
            this.orgStructStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle.setFont((Font)defaultFont);
        }
    }

    private void createOrgStructCellStyle1() {
        this.orgStructStyle1 = null;
        if (this.orgStructStyle1 == null) {
            this.orgStructStyle1 = this.getWb().createCellStyle();
            this.orgStructStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle1.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructStyle1.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructStyle1.setHidden(false);
            this.orgStructStyle1.setLocked(false);
            this.orgStructStyle1.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle1.setBottomBorderColor(backColorIndex);
            this.orgStructStyle1.setTopBorderColor(backColorIndex);
            this.orgStructStyle1.setLeftBorderColor(backColorIndex);
            this.orgStructStyle1.setRightBorderColor(backColorIndex);
            this.orgStructStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle1.setFont((Font)defaultFont);
        }
    }

    private void createOrgStructNeedCellStyle() {
        this.orgStructNeedCellStyle = null;
        if (this.orgStructNeedCellStyle == null) {
            this.orgStructNeedCellStyle = this.getWb().createCellStyle();
            this.orgStructNeedCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructNeedCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructNeedCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructNeedCellStyle.setHidden(false);
            this.orgStructNeedCellStyle.setLocked(false);
            this.orgStructNeedCellStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructNeedCellStyle.setBottomBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setTopBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setLeftBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setRightBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructNeedCellStyle.setFont((Font)defaultFont);
        }
    }

    private void createValueCellStyle() {
        this.valueStyle = this.createCellStyle();
        XSSFDataFormat df = this.getWb().createDataFormat();
        this.valueStyle.setDataFormat(df.getFormat("@"));
    }

    private void createCustomDigitStyle() {
        this.customDigitStyle = this.createCellStyle();
        XSSFDataFormat df = this.getWb().createDataFormat();
        this.customDigitStyle.setDataFormat(df.getFormat("0"));
    }

    private CellStyle createDynamicStyle(int scale) {
        if (scale <= 0) {
            return this.customDigitStyle;
        }
        CellStyle style = this.styleCache.get(scale);
        if (style != null) {
            return style;
        }
        String scaleStr = "0.00000000000000000";
        String scaleSubStr = scaleStr.substring(0, scale + 2);
        CellStyle newStyle = this.createCellStyle();
        newStyle.setAlignment(HorizontalAlignment.RIGHT);
        XSSFDataFormat df = this.getWb().createDataFormat();
        newStyle.setDataFormat(df.getFormat(scaleSubStr));
        this.styleCache.put(scale, newStyle);
        return newStyle;
    }

    private void createDateCellStyle() {
        this.dateStyle = this.createCellStyle();
        XSSFDataFormat df = this.getWb().createDataFormat();
        String dateFormat = "yyyy/m/d h:mm:ss";
        this.dateStyle.setDataFormat(df.getFormat(dateFormat));
    }

    private void createDateTimeCellStyle() {
        this.dateTimeStyle = this.createCellStyle();
        XSSFDataFormat df = this.getWb().createDataFormat();
        String dateTimeFormat = "yyyy/m/d h:mm:ss";
        this.dateTimeStyle.setDataFormat(df.getFormat(dateTimeFormat));
    }

    private void createDigitStyle() {
        this.digitStyle = this.createCellStyle();
        XSSFDataFormat df = this.getWb().createDataFormat();
        String decimalformat = "0.00";
        this.digitStyle.setDataFormat(df.getFormat(decimalformat));
    }

    private CellStyle createCellStyle() {
        XSSFCellStyle valueStyle = null;
        valueStyle = this.getWb().createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        valueStyle.setLocked(false);
        valueStyle.setBorderLeft(BorderStyle.DOTTED);
        valueStyle.setBorderRight(BorderStyle.DOTTED);
        valueStyle.setBorderTop(BorderStyle.DOTTED);
        valueStyle.setBorderBottom(BorderStyle.DOTTED);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont defaultFont = this.getWb().createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont((Font)defaultFont);
        return valueStyle;
    }

    private void createTitleCellStyle() {
        this.titleStyle = null;
        if (this.titleStyle == null) {
            this.titleStyle = this.getWb().createCellStyle();
            this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.titleStyle.setAlignment(HorizontalAlignment.LEFT);
            this.titleStyle.setHidden(false);
            this.titleStyle.setLocked(false);
            this.titleStyle.setBorderLeft(BorderStyle.NONE);
            this.titleStyle.setBorderRight(BorderStyle.NONE);
            this.titleStyle.setBorderTop(BorderStyle.NONE);
            this.titleStyle.setBorderBottom(BorderStyle.NONE);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.titleStyle.setBottomBorderColor(backColorIndex);
            this.titleStyle.setTopBorderColor(backColorIndex);
            this.titleStyle.setLeftBorderColor(backColorIndex);
            this.titleStyle.setRightBorderColor(backColorIndex);
            this.titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
            short size = 18;
            defaultFont.setFontHeight(size);
            defaultFont.setFontHeightInPoints(size);
            this.titleStyle.setFont((Font)defaultFont);
        }
    }

    private void writeComment() throws IOException {
        String refId = null;
        List relations = this.sheet.getRelations();
        for (int i = 0; i < relations.size(); ++i) {
            POIXMLDocumentPart relation = (POIXMLDocumentPart)relations.get(i);
            if (!(relation instanceof XSSFVMLDrawing)) continue;
            refId = relation.getRelationId(relation);
            break;
        }
        this.comment(refId);
    }

    public Cell getCell(Sheet sht, int rowNum, int colNum) {
        int rowCount = sht.getPhysicalNumberOfRows();
        Row row = null;
        row = rowNum >= rowCount ? sht.createRow(rowNum) : sht.getRow(rowNum);
        Cell cell = row.getCell((int)((short)colNum));
        if (cell == null) {
            cell = row.createCell((int)((short)colNum));
        }
        return cell;
    }

    public void orderByColNumber(List<FieldPropertyInfo> fields) {
        if (fields == null || fields.size() <= 1) {
            return;
        }
        int size = fields.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                FieldPropertyInfo fpii = fields.get(i);
                FieldPropertyInfo fpij = fields.get(j);
                if (fpii.getFieldColNumber() <= fpij.getFieldColNumber()) continue;
                fields.set(i, fpij);
                fields.set(j, fpii);
            }
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
        if (StringUtils.isEmpty((String)this.sheetName)) {
            this.sheetName = "Sheet1";
        }
    }

    @Override
    public void setFileName(String fileName) {
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public void setLocacle(Locale l) {
        this.locale = l;
    }

    @Override
    public Locale getLocacle() {
        return this.locale;
    }
}

