/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007SheetWriter {
    private Excel2007Writer excelWriter;
    private SpreadsheetWriter sw;

    public Excel2007SheetWriter(Excel2007Writer excelWriter) {
        this.excelWriter = excelWriter;
    }

    public XSSFWorkbook getWb() {
        return this.excelWriter.getWb();
    }

    public Excel2007Writer getExcelWriter() {
        return this.excelWriter;
    }

    public void putSheetFile(String sheetRef, File sheetXml) {
        this.excelWriter.putSheetFile(sheetRef.substring(1), sheetXml);
    }

    public void beginSheet() throws IOException {
        this.sw.beginSheet();
    }

    public void beginWorkSheet() throws IOException {
        this.sw.beginWorkSheet();
    }

    public void setDimension(String rowCounts) throws IOException {
        this.sw.setDimension(rowCounts);
    }

    public void beginSheetData() throws IOException {
        this.sw.beginSheetData();
    }

    public void endSheetData() throws IOException {
        this.sw.endSheetData();
    }

    public void endWorkSheet() throws IOException {
        this.sw.endWorkSheet();
    }

    public void beginMergeCells(int count) throws IOException {
        this.sw.beginMergeCells(count);
    }

    public void endMergeCells() throws IOException {
        this.sw.endMergeCells();
    }

    public void mergeCell(int r1, int c1, int r2, int c2) throws IOException {
        this.sw.mergeCell(r1, c1, r2, c2);
    }

    public void comment(String refId) throws IOException {
        this.sw.comment(refId);
    }

    public void insertRow(int rowNum) throws IOException {
        this.sw.insertRow(rowNum);
    }

    public void createCell(int columnIndex, String value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, double value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, float value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, float value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, int value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, int value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, BigDecimal value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, BigDecimal value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, Date value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, Date value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, boolean value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, boolean value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void beginCols() throws IOException {
        this.sw.beginCols();
    }

    public void endCols() throws IOException {
        this.sw.endCols();
    }

    public void insertDefaultColStyle(int col, int width) throws IOException {
        this.sw.insertDefaultColStyle(col, width);
    }

    public void insertDefaultColStyle(int col, int width, int styleIndex) throws IOException {
        this.sw.insertDefaultColStyle(col, width, styleIndex);
    }

    public void endRow() throws IOException {
        this.sw.endRow();
    }

    public void endSheet() throws IOException {
        this.sw.endSheet();
    }

    public SpreadsheetWriter getSw() {
        return this.sw;
    }

    public void setSw(SpreadsheetWriter sw) {
        this.sw = sw;
    }

    public static class SpreadsheetWriter {
        private final Writer _out;
        private int _rownum;

        public Writer get_out() {
            return this._out;
        }

        public SpreadsheetWriter(Writer out) {
            this._out = out;
        }

        public void endSheet() throws IOException {
            this.endWorkSheet();
            this.endSheetData();
        }

        public void beginSheet() throws IOException {
            this.beginWorkSheet();
            this.beginSheetData();
        }

        public void beginWorkSheet() throws IOException {
            this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        }

        public void setDimension(String rowCounts) throws IOException {
            this._out.write("<dimension ref=\"" + rowCounts + "\"/>");
        }

        public void endWorkSheet() throws IOException {
            this._out.write("</worksheet>");
        }

        public void beginSheetData() throws IOException {
            this._out.write("<sheetData>\n");
        }

        public void endSheetData() throws IOException {
            this._out.write("</sheetData>");
        }

        public void insertRow(int rownum) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\">\n");
            this._rownum = rownum;
        }

        public void endRow() throws IOException {
            this._out.write("</row>\n");
        }

        public void beginMergeCells(int count) throws IOException {
            this._out.write("<mergeCells count=\"" + count + "\">");
        }

        public void endMergeCells() throws IOException {
            this._out.write("</mergeCells>");
        }

        public void mergeCell(int r1, int c1, int r2, int c2) throws IOException {
            String ref1 = new CellReference(r1, c1).formatAsString();
            String ref2 = new CellReference(r2, c2).formatAsString();
            this._out.write("<mergeCell ref=\"" + ref1 + ":" + ref2 + "\">");
            this._out.write("</mergeCell>");
        }

        public void beginCols() throws IOException {
            this._out.write("<cols>");
        }

        public void endCols() throws IOException {
            this._out.write("</cols>");
        }

        public void insertDefaultColStyle(int col, int width, int styleIndex) throws IOException {
            if (width <= 0) {
                width = 10;
            }
            this._out.write("<col min=\"" + col + "\" max=\"" + col + "\" width=\"" + width + "\" style=\"" + styleIndex + "\"/>");
        }

        public void insertDefaultColStyle(int col, int width) throws IOException {
            if (width <= 0) {
                width = 10;
            }
            this._out.write("<col min=\"" + col + "\" max=\"" + col + "\" width=\"" + width + "\" />");
        }

        public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<is><t>" + XmlUtil.convert(value) + "</t></is>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, String value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, float value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, float value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, int value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, BigDecimal value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, BigDecimal value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, int value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, Date value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Date value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Date)value, (boolean)false), styleIndex);
        }

        public void createCell(int columnIndex, boolean value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, boolean value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<is><t>" + value + "</t></is>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, double value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Calendar value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Calendar)value, (boolean)false), styleIndex);
        }

        public void comment(String refId) throws IOException {
            this._out.write("<legacyDrawing r:id=\"" + refId + "\"/>");
        }
    }
}

