/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.tools.datatask.export.AbstractExcel2007Writer;
import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelWritingException;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFVMLDrawing;

public class ExternalExcelDataWriter2007
extends AbstractExcel2007Writer
implements IExternalDataWriter {
    private static final Logger logger = Logger.getLogger(ExternalExcelDataWriter2007.class);
    private boolean isEndSheet = true;
    private String sheetName;
    private XSSFSheet sheet = null;
    private int curRowNum = -1;
    private Map keyCol = new HashMap();
    private Locale locale = null;
    private boolean isExportTemplate = false;
    private ExternalStructInfo structInfo;
    private boolean isHasComment = false;
    private CellStyle customDigitStyle = null;
    private Map<Integer, CellStyle> styleCache = new HashMap<Integer, CellStyle>(6);
    private CellStyle orgStructStyle = null;
    private CellStyle orgStructStyle1 = null;
    private CellStyle orgStructNeedCellStyle = null;
    private CellStyle valueStyle = null;
    private CellStyle titleStyle = null;

    public ExternalStructInfo getStructInfo() {
        return this.structInfo;
    }

    public void setStructInfo(ExternalStructInfo structInfo) {
        this.structInfo = structInfo;
    }

    public ExternalExcelDataWriter2007() {
        this.initCellStyle();
    }

    public void writeCell(int row, int col, DataToken data) throws ExcelWritingException {
        if (data != null) {
            this.writeCell(row, col, data.data);
        } else {
            this.writeCell(row, col, "");
        }
    }

    public void writeCell(int row, int col, Object data) throws ExcelWritingException {
        if (this.sheet == null) {
            String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "visitpage", this.locale) + this.sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fail", this.locale);
            ExcelWritingException err = new ExcelWritingException(detail);
            throw err;
        }
        try {
            this.addValueCell((Sheet)this.sheet, row, col, data);
        }
        catch (Exception ex) {
            throw new ExcelWritingException(ex.getMessage(), ex.getCause());
        }
    }

    private void addOrgStructCell(int colNum, String value) throws Exception {
        this.createCell(colNum, value, (int)this.orgStructStyle.getIndex());
    }

    private void addOrgStructCell1(int colNum, String value, boolean isNecessary) throws Exception {
        if (isNecessary) {
            this.createCell(colNum, value, (int)this.orgStructNeedCellStyle.getIndex());
        } else {
            this.createCell(colNum, value, (int)this.orgStructStyle1.getIndex());
        }
    }

    private void addTitleCell(int colNum, String value) throws Exception {
        this.createCell(colNum, value, (int)this.titleStyle.getIndex());
    }

    private void addValueCell(Sheet sht, int rowNum, int colNum, Object value) throws Exception {
        if (value == null) {
            this.createCell(colNum, "", (int)this.valueStyle.getIndex());
            return;
        }
        if (value instanceof String) {
            this.createCell(colNum, (String)value, (int)this.valueStyle.getIndex());
        } else if (value instanceof Float) {
            this.createCell(colNum, ((Float)value).floatValue(), (int)this.valueStyle.getIndex());
        } else if (value instanceof Integer) {
            this.createCell(colNum, (Integer)value, (int)this.valueStyle.getIndex());
        } else if (value instanceof Double) {
            this.createCell(colNum, (Double)value, (int)this.valueStyle.getIndex());
        } else if (value instanceof BigDecimal) {
            this.createCell(colNum, (BigDecimal)value, (int)this.createDynamicStyle(((BigDecimal)value).scale()).getIndex());
        } else if (value instanceof Date) {
            this.createCell(colNum, value.toString(), (int)this.valueStyle.getIndex());
        } else if (value instanceof Boolean) {
            this.createCell(colNum, (Boolean)value, (int)this.valueStyle.getIndex());
        } else {
            this.createCell(colNum, value.toString(), (int)this.valueStyle.getIndex());
        }
    }

    private void createOrgStructCellStyle() {
        this.orgStructStyle = null;
        if (this.orgStructStyle == null) {
            this.orgStructStyle = this.getWb().createCellStyle();
            this.orgStructStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
            this.orgStructStyle.setAlignment(HorizontalAlignment.LEFT);
            this.orgStructStyle.setHidden(false);
            this.orgStructStyle.setLocked(false);
            this.orgStructStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle.setBottomBorderColor(backColorIndex);
            this.orgStructStyle.setTopBorderColor(backColorIndex);
            this.orgStructStyle.setLeftBorderColor(backColorIndex);
            this.orgStructStyle.setRightBorderColor(backColorIndex);
            this.orgStructStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle.setFont((Font)defaultFont);
        }
    }

    private void createOrgStructCellStyle1() {
        this.orgStructStyle1 = null;
        if (this.orgStructStyle1 == null) {
            this.orgStructStyle1 = this.getWb().createCellStyle();
            this.orgStructStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle1.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructStyle1.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructStyle1.setHidden(false);
            this.orgStructStyle1.setLocked(false);
            this.orgStructStyle1.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle1.setBottomBorderColor(backColorIndex);
            this.orgStructStyle1.setTopBorderColor(backColorIndex);
            this.orgStructStyle1.setLeftBorderColor(backColorIndex);
            this.orgStructStyle1.setRightBorderColor(backColorIndex);
            this.orgStructStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle1.setFont((Font)defaultFont);
        }
    }

    private void createOrgStructNeedCellStyle() {
        this.orgStructNeedCellStyle = null;
        if (this.orgStructNeedCellStyle == null) {
            this.orgStructNeedCellStyle = this.getWb().createCellStyle();
            this.orgStructNeedCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructNeedCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructNeedCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructNeedCellStyle.setHidden(false);
            this.orgStructNeedCellStyle.setLocked(false);
            this.orgStructNeedCellStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructNeedCellStyle.setBottomBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setTopBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setLeftBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setRightBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructNeedCellStyle.setFont((Font)defaultFont);
        }
    }

    private void createValueCellStyle() {
        this.valueStyle = null;
        if (this.valueStyle == null) {
            this.valueStyle = this.getWb().createCellStyle();
            this.valueStyle.setAlignment(HorizontalAlignment.LEFT);
            this.valueStyle.setHidden(true);
            this.valueStyle.setLocked(false);
            this.valueStyle.setBorderLeft(BorderStyle.DOTTED);
            this.valueStyle.setBorderRight(BorderStyle.DOTTED);
            this.valueStyle.setBorderTop(BorderStyle.DOTTED);
            this.valueStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.valueStyle.setBottomBorderColor(backColorIndex);
            this.valueStyle.setTopBorderColor(backColorIndex);
            this.valueStyle.setLeftBorderColor(backColorIndex);
            this.valueStyle.setRightBorderColor(backColorIndex);
            this.valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.valueStyle.setFont((Font)defaultFont);
            XSSFDataFormat df = this.getWb().createDataFormat();
            this.valueStyle.setDataFormat(df.getFormat("@"));
        }
    }

    private void createCustomDigitStyle() {
        this.customDigitStyle = this.createCellStyle();
        XSSFDataFormat df = this.getWb().createDataFormat();
        this.customDigitStyle.setDataFormat(df.getFormat("0"));
    }

    private CellStyle createDynamicStyle(int scale) {
        if (scale <= 0) {
            return this.customDigitStyle;
        }
        CellStyle style = this.styleCache.get(scale);
        if (style != null) {
            return style;
        }
        String scaleStr = "0.00000000000000000";
        String scaleSubStr = scaleStr.substring(0, scale + 2);
        CellStyle newStyle = this.createCellStyle();
        newStyle.setAlignment(HorizontalAlignment.RIGHT);
        XSSFDataFormat df = this.getWb().createDataFormat();
        newStyle.setDataFormat(df.getFormat(scaleSubStr));
        this.styleCache.put(scale, newStyle);
        return newStyle;
    }

    private CellStyle createCellStyle() {
        XSSFCellStyle valueStyle = null;
        valueStyle = this.getWb().createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        valueStyle.setLocked(false);
        valueStyle.setBorderLeft(BorderStyle.DOTTED);
        valueStyle.setBorderRight(BorderStyle.DOTTED);
        valueStyle.setBorderTop(BorderStyle.DOTTED);
        valueStyle.setBorderBottom(BorderStyle.DOTTED);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont defaultFont = this.getWb().createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont((Font)defaultFont);
        return valueStyle;
    }

    private void createTitleCellStyle() {
        this.titleStyle = null;
        if (this.titleStyle == null) {
            this.titleStyle = this.getWb().createCellStyle();
            this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.titleStyle.setAlignment(HorizontalAlignment.LEFT);
            this.titleStyle.setHidden(false);
            this.titleStyle.setLocked(false);
            this.titleStyle.setBorderLeft(BorderStyle.NONE);
            this.titleStyle.setBorderRight(BorderStyle.NONE);
            this.titleStyle.setBorderTop(BorderStyle.NONE);
            this.titleStyle.setBorderBottom(BorderStyle.NONE);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.titleStyle.setBottomBorderColor(backColorIndex);
            this.titleStyle.setTopBorderColor(backColorIndex);
            this.titleStyle.setLeftBorderColor(backColorIndex);
            this.titleStyle.setRightBorderColor(backColorIndex);
            this.titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFFont defaultFont = this.getWb().createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
            short size = 18;
            defaultFont.setFontHeight(size);
            defaultFont.setFontHeightInPoints(size);
            this.titleStyle.setFont((Font)defaultFont);
        }
    }

    private void initCellStyle() {
        this.createOrgStructCellStyle();
        this.createOrgStructCellStyle1();
        this.createOrgStructNeedCellStyle();
        this.createTitleCellStyle();
        this.createValueCellStyle();
        this.createCustomDigitStyle();
    }

    @Override
    public void openWriter() throws TaskRunnerException {
        try {
            this.finishSheet();
            this.sheet = this.getWb().createSheet(this.sheetName);
            String sheetRef = this.sheet.getPackagePart().getPartName().getName();
            File tmp = File.createTempFile("sheet", ".xml");
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF-8");
            this.setSw(new AbstractExcel2007Writer.SpreadsheetWriter(fw));
            this.beginWorkSheet();
            this.isEndSheet = false;
            this.putSheetFile(sheetRef, tmp);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void finishSheet() throws Exception {
        if (!this.isEndSheet) {
            this.endSheetData();
            this.beginMergeCells(1);
            int size = this.structInfo.getFieldCollection().size();
            size = size < 3 ? 3 : size;
            this.mergeCell(0, 2, 1, size - 1);
            this.endMergeCells();
            if (this.isHasComment) {
                this.writeComment();
            }
            this.endWorkSheet();
            this.getSw().get_out().close();
            this.isHasComment = false;
        }
    }

    private void writeComment() throws IOException {
        String refId = null;
        List relations = this.sheet.getRelations();
        for (int i = 0; i < relations.size(); ++i) {
            POIXMLDocumentPart relation = (POIXMLDocumentPart)relations.get(i);
            if (!(relation instanceof XSSFVMLDrawing)) continue;
            refId = relation.getRelationId(relation);
            break;
        }
        if (StringUtils.isEmpty(refId)) {
            refId = "rId3";
        }
        this.comment(refId);
    }

    @Override
    public void closeWriter() throws TaskRunnerException {
        try {
            this.finishSheet();
            this.processFile();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, e.getMessage(), e);
        }
    }

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        try {
            FieldPropertyInfo fpi;
            int i;
            int i2;
            this.structInfo = structInfo;
            this.beginCols();
            ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
            int size = fields.size();
            for (i2 = 0; i2 < size; ++i2) {
                this.insertDefaultColStyle(i2 + 1, 9, this.valueStyle.getIndex());
            }
            this.endCols();
            this.beginSheetData();
            this.insertRow(0);
            this.addOrgStructCell(0, structInfo.getProductName());
            this.addOrgStructCell(1, structInfo.getVersion());
            this.addTitleCell(2, structInfo.getObjectDesc());
            for (i2 = 3; i2 < size; ++i2) {
                this.addTitleCell(i2, "");
            }
            this.endRow();
            this.insertRow(1);
            this.addOrgStructCell(0, structInfo.getObjectName());
            this.addOrgStructCell(1, structInfo.getObjectDesc());
            for (i2 = 2; i2 < size; ++i2) {
                this.addTitleCell(i2, "");
            }
            this.endRow();
            this.orderByColNumber(fields);
            this.insertRow(2);
            XSSFDrawing p = this.sheet.createDrawingPatriarch();
            for (i = 0; i < size; ++i) {
                fpi = (FieldPropertyInfo)fields.get(i);
                this.addOrgStructCell(i, fpi.getFieldName());
                this.keyCol.put(fpi.getFieldName(), new Integer(i));
                if (StringUtils.isEmpty((String)fpi.getFiledMemo())) continue;
                this.isHasComment = true;
                XSSFComment comment = null;
                comment = i <= 2 ? p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 7, 7, 10, 10)) : p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)(3 + i)), 3 + i, (int)((short)(8 + i)), 8 + i));
                XSSFRichTextString rtf = new XSSFRichTextString(fpi.getFiledMemo());
                XSSFFont commentFormatter = this.getWb().createFont();
                rtf.applyFont((Font)commentFormatter);
                comment.setString((RichTextString)rtf);
                Cell cell = this.getCell((Sheet)this.sheet, 3, i);
                cell.setCellComment((Comment)comment);
            }
            this.endRow();
            this.insertRow(3);
            for (i = 0; i < size; ++i) {
                fpi = (FieldPropertyInfo)fields.get(i);
                String fieldDesc = fpi.getFieldDesc();
                if (fpi.getIsNecessary()) {
                    fieldDesc = "*" + fieldDesc;
                    this.addOrgStructCell1(i, fieldDesc, true);
                    continue;
                }
                this.addOrgStructCell1(i, fieldDesc, false);
            }
            this.endRow();
            this.curRowNum = 4;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Cell getCell(Sheet sht, int rowNum, int colNum) {
        int rowCount = sht.getPhysicalNumberOfRows();
        Row row = null;
        row = rowNum >= rowCount ? sht.createRow(rowNum) : sht.getRow(rowNum);
        Cell cell = row.getCell((int)((short)colNum));
        if (cell == null) {
            cell = row.createCell((int)((short)colNum));
        }
        return cell;
    }

    private void orderByColNumber(List<FieldPropertyInfo> fields) {
        if (fields == null || fields.size() <= 1) {
            return;
        }
        int size = fields.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                FieldPropertyInfo fpii = fields.get(i);
                FieldPropertyInfo fpij = fields.get(j);
                if (fpii.getFieldColNumber() <= fpij.getFieldColNumber()) continue;
                fields.set(i, fpij);
                fields.set(j, fpii);
            }
        }
    }

    private List<CellObject> dataOrderByColNum(Map data) throws TaskRunnerException {
        ArrayList<CellObject> dataList = new ArrayList<CellObject>();
        for (String key : data.keySet()) {
            dataList.add(new CellObject(this.getColNumByFieldName(key), data.get(key)));
        }
        Collections.sort(dataList, (Comparator)new Comparator<CellObject>(){

            @Override
            public int compare(CellObject o1, CellObject o2) {
                if (o1.getColNum() > o2.getColNum()) {
                    return 1;
                }
                if (o1.getColNum() < o2.getColNum()) {
                    return -1;
                }
                return 0;
            }
        });
        return dataList;
    }

    @Override
    public void writeLine(Map data) throws TaskRunnerException {
        List<CellObject> dataOrder = this.dataOrderByColNum(data);
        try {
            this.insertRow(this.curRowNum);
            for (int i = 0; i < dataOrder.size(); ++i) {
                this.writeCell(this.curRowNum, dataOrder.get(i).getColNum(), dataOrder.get(i).getValue());
            }
            this.endRow();
            ++this.curRowNum;
        }
        catch (Exception ex) {
            throw new TaskRunnerException(ex.getMessage(), (Throwable)ex);
        }
    }

    private int getColNumByFieldName(String key) throws TaskRunnerException {
        Integer colNum = (Integer)this.keyCol.get(key);
        if (colNum == null) {
            throw new TaskRunnerException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "nofindfield", this.locale) + key);
        }
        return colNum;
    }

    @Override
    public void setLocacle(Locale l) {
        this.locale = l;
    }

    @Override
    public Locale getLocacle() {
        return this.locale;
    }

    public boolean isExportTemplate() {
        return this.isExportTemplate;
    }

    public void setExportTemplate(boolean isExportTemplate) {
        this.isExportTemplate = isExportTemplate;
    }

    @Override
    public String getFileName() {
        return this.getProduceFileName();
    }

    @Override
    public void setFileName(String fileName) {
        if (this.isExportTemplate) {
            this.setProduceFileName(fileName);
        } else {
            this.setProduceFileName(GlobalFunction.getFilePathForServer() + File.separator + fileName);
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        if (StringUtils.isEmpty((String)sheetName)) {
            sheetName = "Sheet1";
        }
        if (sheetName.length() > 30) {
            sheetName = sheetName.substring(0, 30);
        }
        this.sheetName = sheetName;
    }

    class CellObject {
        int colNum;
        Object value;

        public CellObject(int colNum, Object value) {
            this.colNum = colNum;
            this.value = value;
        }

        public int getColNum() {
            return this.colNum;
        }

        public void setColNum(int colNum) {
            this.colNum = colNum;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

