/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class ExternalXmlDataWriter
implements IExternalDataWriter {
    private OutputStreamWriter fw = null;
    private BufferedWriter bw = null;
    private String encoding = "UTF-8";
    private ExternalStructInfo structInfo = null;
    private static final String product = "product";
    private static final String version = "version";
    private static final String objectName = "objectName";
    private static final String objectDesc = "objectDesc";
    private List<FieldPropertyInfo> fieldsArray = null;
    private Element el = new Element("easrecord");
    private Element struct = new Element("struct");
    private Element records = new Element("records");
    private String fileName = null;
    private boolean isExportTemplate = false;
    private Document doc = null;
    private Locale lc = null;

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        this.structInfo = structInfo;
        this.doc = new Document(this.el);
        this.el.setAttribute(product, this.getNotNullString(structInfo.getProductName()));
        this.el.setAttribute(version, this.getNotNullString(structInfo.getVersion()));
        this.el.setAttribute(objectName, this.getNotNullString(structInfo.getObjectName()));
        this.el.setAttribute(objectDesc, this.getNotNullString(structInfo.getObjectDesc()));
        this.initStructElement(structInfo);
        this.el.addContent((Content)this.struct);
    }

    private void initStructElement(ExternalStructInfo structInfo) {
        ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
        this.orderByColNumber(fields);
        this.fieldsArray = fields;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo fpi = (FieldPropertyInfo)fields.get(i);
            Element field = new Element("field");
            field.setAttribute("name", this.getNotNullString(fpi.getFieldName()));
            field.setAttribute("desc", this.getNotNullString(fpi.getFieldDesc()));
            field.setAttribute("isNeed", String.valueOf(fpi.getIsNecessary()));
            field.setAttribute("memo", this.getNotNullString(fpi.getFiledMemo()));
            this.struct.addContent((Content)field);
        }
    }

    private String getNotNullString(String str) {
        return str == null ? "" : str;
    }

    private void orderByColNumber(List<FieldPropertyInfo> fields) {
        if (fields == null || fields.size() <= 1) {
            return;
        }
        int size = fields.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                FieldPropertyInfo fpii = fields.get(i);
                FieldPropertyInfo fpij = fields.get(j);
                if (fpii.getFieldColNumber() <= fpij.getFieldColNumber()) continue;
                fields.set(i, fpij);
                fields.set(j, fpii);
            }
        }
    }

    @Override
    public void writeLine(Map data) throws TaskRunnerException {
        Element record = new Element("record");
        int size = this.fieldsArray.size();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo fpi = this.fieldsArray.get(i);
            String fieldName = fpi.getFieldName();
            if (!data.containsKey(fieldName)) continue;
            Object o = data.get(fieldName);
            String oneValue = o.toString();
            Element field = new Element("field");
            field.setAttribute("name", fieldName);
            field.setText(oneValue);
            record.addContent((Content)field);
        }
        this.records.addContent((Content)record);
    }

    public boolean isExportTemplate() {
        return this.isExportTemplate;
    }

    public void setExportTemplate(boolean isExportTemplate) {
        this.isExportTemplate = isExportTemplate;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = this.isExportTemplate ? fileName : GlobalFunction.getFilePathForServer() + File.separator + fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void openWriter() throws TaskRunnerException {
        FileOutputStream fop = null;
        File f = new File(this.fileName);
        try {
            if (f.exists()) {
                f.delete();
            }
            fop = new FileOutputStream(f);
            this.fw = new OutputStreamWriter((OutputStream)fop, this.getCharsetName());
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getCharsetName() {
        return this.encoding;
    }

    @Override
    public void closeWriter() throws TaskRunnerException {
        if (this.doc == null) {
            return;
        }
        this.el.addContent((Content)this.records);
        XMLOutputter outputter = new XMLOutputter();
        try {
            outputter.output(this.doc, (Writer)this.bw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fw = null;
        }
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bw = null;
        }
        this.doc = null;
    }

    @Override
    public void setLocacle(Locale l) {
        this.lc = l;
    }

    @Override
    public Locale getLocacle() {
        return this.lc;
    }
}

