/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.log;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.ExcelImportState;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class ExcelTaskLog
implements ILog {
    private final String fileName;
    private final String fileUuID;
    private final String logUuID;
    private TaskStateEnum taskState = TaskStateEnum.INITTASK;
    private Throwable ex = null;
    private String errMsg = "";
    private Context ctx;
    private static final int MSG_SIZE = 15;
    private AtomicInteger expAllRowCount = new AtomicInteger();
    private AtomicInteger expCurrentRowCount = new AtomicInteger();
    private CopyOnWriteArrayList<String> errArry = new CopyOnWriteArrayList();
    private List entryList = new ArrayList();
    private ConcurrentHashMap<Integer, ExcelSheetTaskLog> sheetList = new ConcurrentHashMap();

    public List getEntryList() {
        return this.entryList;
    }

    public void setEntryList(List entryList) {
        this.entryList = entryList;
    }

    public ExcelTaskLog(String logUuID, String fileUuID, String fileName) {
        this.fileName = fileName;
        this.logUuID = logUuID;
        this.fileUuID = fileUuID;
    }

    public ExcelSheetTaskLog get(int sheetId) {
        return this.sheetList.get(sheetId);
    }

    public ExcelSheetTaskLog get(String sheetName) {
        for (Map.Entry<Integer, ExcelSheetTaskLog> entry : this.sheetList.entrySet()) {
            ExcelSheetTaskLog sheetLog = entry.getValue();
            String _sheetName = sheetLog.getSheetName();
            if (!_sheetName.equals(sheetName)) continue;
            return sheetLog;
        }
        return null;
    }

    public ExcelSheetTaskLog put(int sheetId, String sheetName) {
        ExcelSheetTaskLog sheetlog = new ExcelSheetTaskLog(sheetId, sheetName);
        ExcelSheetTaskLog _sheetlog = this.sheetList.putIfAbsent(sheetId, sheetlog);
        if (_sheetlog == null) {
            _sheetlog = sheetlog;
        }
        return _sheetlog;
    }

    public synchronized void setTaskLogInfo(TaskStateEnum taskState, String errMsg, Throwable ex) {
        this.taskState = taskState;
        this.errMsg = this.errMsg + errMsg + "</br>";
        this.ex = ex;
    }

    public synchronized void setTaskLogInfo(TaskStateEnum taskState) {
        if (this.taskState.getValue() == 4) {
            return;
        }
        this.taskState = taskState;
    }

    public TaskStateEnum getTaskState() {
        return this.taskState;
    }

    public synchronized ExcelTaskLog getTaskLogInfo() {
        ExcelTaskLog log = new ExcelTaskLog(this.logUuID, this.fileUuID, this.fileName);
        log.errMsg = this.errMsg;
        log.ex = new Throwable(this.ex.getMessage());
        log.taskState = this.taskState;
        return log;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean isImported() {
        for (Map.Entry<Integer, ExcelSheetTaskLog> entry : this.sheetList.entrySet()) {
            ExcelSheetTaskLog sheetLog = entry.getValue();
            if (!sheetLog.isImported()) continue;
            return true;
        }
        return false;
    }

    public boolean isImported(int sheetId) {
        ExcelSheetTaskLog sheetlog = this.get(sheetId);
        if (sheetlog != null) {
            return sheetlog.isImported();
        }
        return false;
    }

    public boolean isSucced(Set<Integer> sheetIds) {
        int sheetId;
        boolean rs = true;
        Iterator<Integer> iterator = sheetIds.iterator();
        while (iterator.hasNext() && (rs = this.isSucced(sheetId = iterator.next().intValue()))) {
        }
        return rs;
    }

    public boolean isSucced(int sheetId) {
        boolean rs = false;
        ExcelSheetTaskLog sheetlog = this.get(sheetId);
        if (sheetlog != null && sheetlog.getSheetResultState().getValue() == 3) {
            rs = true;
        }
        return rs;
    }

    public Map<Integer, ExcelSheetTaskLog> getSheetList() {
        return this.sheetList;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getLogUuID() {
        return this.logUuID;
    }

    @Override
    public String getFileUuID() {
        return this.fileUuID;
    }

    @Override
    public String getLogType() {
        return null;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public int getExpAllRowCount() {
        return this.expAllRowCount.get();
    }

    public void setExpAllRowCount(int expAllRowCount) {
        this.expAllRowCount.addAndGet(expAllRowCount);
    }

    public int getExpCurrentRowCount() {
        return this.expCurrentRowCount.get();
    }

    public void setExpCurrentRowCount() {
        this.expCurrentRowCount.incrementAndGet();
    }

    public String getExcelErrorInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getErrMsg());
        for (String msg : this.errArry) {
            sb.append(msg).append("<br/>");
        }
        return sb.toString();
    }

    public boolean hasErrMsg() {
        return !StringUtils.isEmpty((String)this.getErrMsg()) || this.errArry.size() > 0;
    }

    public void setExcelErrorInfo(String errMsg) {
        if (this.errArry.size() <= 7) {
            this.errArry.add(errMsg);
        }
    }

    public void setTaskState(TaskStateEnum taskState) {
        this.taskState = taskState;
    }

    public class ExcelSheetTaskLog {
        private String sheetErrMsg = null;
        private volatile TaskStateEnum sheetResultState = TaskStateEnum.INITTASK;
        private volatile ExcelImportState sheetImportState = ExcelImportState.waitForImport;
        private final String sheetName;
        private final int sheetID;
        private AtomicInteger rowCount = new AtomicInteger();
        private AtomicInteger successRowCount = new AtomicInteger();
        private AtomicInteger blankRowCount = new AtomicInteger();
        private int failRowCount = 0;
        private TreeMap<Integer, String> errorSubMap = new TreeMap();
        private TreeMap<Integer, String> errBlockMsg = new TreeMap();
        private Map<Integer, Integer> blockMap = new HashMap<Integer, Integer>();

        public ExcelSheetTaskLog(int sheetId, String sheetName) {
            this.sheetID = sheetId;
            this.sheetName = sheetName;
        }

        public boolean isImported() {
            int size = this.successRowCount.get() + this.failRowCount;
            return size > 0;
        }

        public synchronized void setErrorInfo(int currow, String errorSubject) {
            ++this.failRowCount;
            Object[] joins = new String[]{Integer.toString(currow)};
            String errorPrifix = EASResourceJoinUtil.getServerString("whichRow", joins, ExcelTaskLog.this.ctx.getLocale());
            this.errorSubMap.put(currow, errorPrifix + errorSubject);
        }

        public synchronized void setBlockErrorInfo(int currow, int endrow, String errorSubject) {
            int diff = endrow - currow;
            int errSize = this.getErrSize(currow, endrow);
            this.failRowCount += diff - errSize + 1;
            if (diff > 0) {
                Object[] joins = new String[]{currow + "", endrow + ""};
                String errorPrifix = EASResourceJoinUtil.getServerString("beginToEnd", joins, ExcelTaskLog.this.ctx.getLocale());
                this.errBlockMsg.put(currow, errorPrifix + errorSubject);
                this.blockMap.put(currow, endrow);
            } else if (!this.errorSubMap.containsKey(currow)) {
                Object[] joins = new String[]{currow + ""};
                String errorPrifix = EASResourceJoinUtil.getServerString("whichRow", joins, ExcelTaskLog.this.ctx.getLocale());
                this.errorSubMap.put(currow, errorPrifix + errorSubject);
            }
        }

        public void setSuccessRowCount(int currow, int endrow) {
            int diff = endrow - currow;
            if (diff == 0) {
                if (!this.errorSubMap.containsKey(currow) && !this.errBlockMsg.containsKey(currow)) {
                    this.successRowCount.incrementAndGet();
                }
            } else if (!this.blockMap.containsKey(currow)) {
                int errsize = this.getErrSize(currow, endrow);
                this.successRowCount.addAndGet(diff - errsize + 1);
            }
        }

        private int getErrSize(int currow, int endrow) {
            int errSize = 0;
            for (int key : this.errorSubMap.keySet()) {
                if (key < currow || key > endrow) continue;
                ++errSize;
            }
            return errSize;
        }

        public synchronized void setSheetError(String errMsg) {
            this.sheetErrMsg = errMsg;
            this.sheetResultState = TaskStateEnum.FAILEND;
        }

        public synchronized void setSheetErrMsg(String errMsg) {
            this.sheetErrMsg = errMsg;
        }

        public synchronized String getSheetErrMsg() {
            return this.sheetErrMsg;
        }

        public synchronized String[] getErrorInfo(int currow) {
            String[] rs = new String[]{this.failRowCount + ""};
            StringBuilder error = new StringBuilder();
            for (Map.Entry<Integer, String> entry : this.errorSubMap.entrySet()) {
                if (entry.getKey() < currow) continue;
                error.append(entry.getValue()).append("<br/>");
            }
            rs[1] = error.toString();
            return rs;
        }

        public synchronized String getErrorInfo() {
            StringBuilder error = new StringBuilder();
            int msgSize = 1;
            int i = 1;
            Integer key = 1;
            Integer key2 = 1;
            if (this.errBlockMsg.size() > 0) {
                key = this.errBlockMsg.lastKey();
            }
            if (this.errorSubMap.size() > 0) {
                key2 = this.errorSubMap.lastKey();
            }
            int maxKey = Math.max(key, key2);
            do {
                if (this.errBlockMsg.containsKey(i)) {
                    error.append(this.errBlockMsg.get(i)).append("<br/>");
                    ++msgSize;
                    continue;
                }
                if (!this.errorSubMap.containsKey(i)) continue;
                error.append(this.errorSubMap.get(i)).append("<br/>");
                ++msgSize;
            } while (msgSize <= 15 && ++i <= maxKey);
            if (!StringUtils.isEmpty((String)ExcelTaskLog.this.errMsg)) {
                error.append(ExcelTaskLog.this.errMsg);
            }
            if (!StringUtils.isEmpty((String)this.getSheetErrMsg())) {
                error.append(this.getSheetErrMsg());
            }
            if (msgSize > 15) {
                String msg = EASResourceJoinUtil.getServerString("moreImportErr", ExcelTaskLog.this.ctx.getLocale());
                error.append(msg).append("<br/>");
            }
            return error.toString();
        }

        public TaskStateEnum getSheetResultState() {
            return this.sheetResultState;
        }

        public void setSheetResultState(TaskStateEnum sheetResultState) {
            this.sheetResultState = sheetResultState;
        }

        public void setSheetResultState() {
            if (this.sheetImportState.getValue() == ExcelImportState.unfinishedImport.getValue() || this.getFailRowCount() > 0) {
                this.sheetResultState = TaskStateEnum.FAILEND;
                ExcelTaskLog.this.setTaskLogInfo(TaskStateEnum.FAILEND);
            } else {
                this.sheetResultState = TaskStateEnum.SUCCESSEND;
                ExcelTaskLog.this.setTaskLogInfo(TaskStateEnum.SUCCESSEND);
            }
        }

        public ExcelImportState getSheetImportState() {
            return this.sheetImportState;
        }

        public void setSheetImportState(ExcelImportState sheetImportState) {
            this.sheetImportState = sheetImportState;
        }

        public int getFailRowCount() {
            return this.failRowCount;
        }

        public Map<Integer, String> getErrorSubMap() {
            return this.errorSubMap;
        }

        public Map<Integer, Integer> getBlockMap() {
            return this.blockMap;
        }

        public Map<Integer, String> getErrBlockMsg() {
            return this.errBlockMsg;
        }

        public int getRowCount() {
            return this.rowCount.get();
        }

        public void setRowCount(int rowCount) {
            this.rowCount.addAndGet(rowCount);
        }

        public int getSuccessRowCount() {
            return this.successRowCount.get();
        }

        public void setSuccessRowCount(int successRowCount) {
            this.successRowCount.addAndGet(successRowCount);
        }

        public int getBlankRowCount() {
            return this.blankRowCount.get();
        }

        public void setBlankRowCount(int blankRowCount) {
            this.blankRowCount.addAndGet(blankRowCount);
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public int getSheetID() {
            return this.sheetID;
        }

        public String getFileUuId() {
            return ExcelTaskLog.this.getFileUuID();
        }
    }
}

