/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellType;
import org.jdom2.Element;

public class FieldPropertyInfo
implements Serializable {
    private static Logger logger = Logger.getLogger(FieldPropertyInfo.class);
    private String fieldName;
    private String fieldDesc;
    private boolean isNecessary;
    private CellType fieldType = CellType._NONE;
    private int fieldColNumber = -1;
    private String filedMemo;
    private boolean isVirtualField;
    private int xPoint;
    private int yPoint;
    private boolean isSeq;
    private int rowNumber;
    private DIETemplateFieldEntryInfo entryInfo = null;

    public void setEntryInfo(DIETemplateFieldEntryInfo entryInfo) {
        this.entryInfo = entryInfo;
    }

    public DIETemplateFieldEntryInfo getEntryInfo() {
        return this.entryInfo;
    }

    public void setFieldName(String vFieldName) {
        this.fieldName = vFieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldDesc(String vFieldDesc) {
        this.fieldDesc = vFieldDesc;
    }

    public String getFieldDesc() {
        return this.fieldDesc;
    }

    public void setFieldType(CellType vFieldType) {
        this.fieldType = vFieldType;
    }

    public CellType getFieldType() {
        return this.fieldType;
    }

    public void setIsNecessary(boolean vIsNex) {
        this.isNecessary = vIsNex;
    }

    public boolean getIsNecessary() {
        return this.isNecessary;
    }

    public void setFieldColNumber(int colNumber) {
        this.fieldColNumber = colNumber;
    }

    public int getFieldColNumber() {
        return this.fieldColNumber;
    }

    public void load(Element elmExcelField) throws Exception {
        this.fieldName = elmExcelField.getAttribute("fieldName").getValue();
        this.fieldDesc = elmExcelField.getAttribute("fieldDescription").getValue();
        logger.info((Object)("field description:" + this.fieldDesc));
        this.isNecessary = Boolean.valueOf(elmExcelField.getAttribute("isNecessary").getValue());
        if (elmExcelField.getAttribute("fieldColNumber") != null) {
            this.fieldColNumber = Integer.parseInt(elmExcelField.getAttribute("fieldColNumber").getValue());
        }
        this.fieldType = elmExcelField.getAttribute("cellType").getValue().compareTo(CellType.NUMERIC.toString()) == 0 ? CellType.NUMERIC : CellType.STRING;
        this.isVirtualField = Boolean.valueOf(elmExcelField.getAttribute("isVirtualField").getValue());
        this.isSeq = Boolean.valueOf(elmExcelField.getAttribute("isSeq").getValue());
        this.xPoint = Integer.parseInt(elmExcelField.getAttribute("xPoint").getValue());
        this.yPoint = Integer.parseInt(elmExcelField.getAttribute("yPoint").getValue());
        this.rowNumber = Integer.parseInt(elmExcelField.getAttribute("rowNumber").getValue());
    }

    public Element store() throws Exception {
        Element elmExcelField = new Element("mapField");
        elmExcelField.setAttribute("fieldName", this.fieldName);
        elmExcelField.setAttribute("fieldDescription", this.fieldDesc);
        elmExcelField.setAttribute("cellType", this.fieldType.toString());
        elmExcelField.setAttribute("isNecessary", String.valueOf(this.isNecessary));
        elmExcelField.setAttribute("fieldColNumber", String.valueOf(this.fieldColNumber));
        elmExcelField.setAttribute("isVirtualField", String.valueOf(this.isVirtualField));
        elmExcelField.setAttribute("xPoint", String.valueOf(this.xPoint));
        elmExcelField.setAttribute("yPoint", String.valueOf(this.yPoint));
        elmExcelField.setAttribute("isSeq", String.valueOf(this.isSeq));
        elmExcelField.setAttribute("rowNumber", String.valueOf(this.rowNumber));
        return elmExcelField;
    }

    public String toString() {
        return this.fieldName;
    }

    public String getFiledMemo() {
        return this.filedMemo;
    }

    public void setFiledMemo(String filedMemo) {
        this.filedMemo = filedMemo;
    }

    public boolean isVirtualField() {
        return this.isVirtualField;
    }

    public void setVirtualField(boolean isVirtualField) {
        this.isVirtualField = isVirtualField;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public void setSeq(boolean isSeq) {
        this.isSeq = isSeq;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getXPoint() {
        return this.xPoint;
    }

    public void setXPoint(int xPoint) {
        this.xPoint = xPoint;
    }

    public int getYPoint() {
        return this.yPoint;
    }

    public void setYPoint(int yPoint) {
        this.yPoint = yPoint;
    }
}

