/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class GenerateErrorDataExcel {
    private static final Logger logger = Logger.getLogger(GenerateErrorDataExcel.class);
    private static HSSFWorkbook workbook = null;
    ArrayList params = null;
    private String excelPath;
    private TaskLog logs;
    private static int dataRowNum;
    private final String ERRORFIELDNUM = "ErrorReason";
    private HSSFCellStyle orgStructStyle = null;
    private HSSFCellStyle orgStructStyle1 = null;
    private HSSFCellStyle orgStructNeedCellStyle = null;
    private HSSFCellStyle valueStyle = null;
    private HSSFCellStyle errorReasonStyle = null;
    private HSSFCellStyle titleStyle = null;

    public GenerateErrorDataExcel(ArrayList param, String excelPath, TaskLog logs, int dataRowNum) {
        this.params = param;
        this.excelPath = excelPath;
        this.logs = logs;
        GenerateErrorDataExcel.dataRowNum = dataRowNum;
    }

    public GenerateErrorDataExcel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ReadExcel() throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(this.excelPath);
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)in);
            String newStrPath = this.getNewExcelName(this.excelPath);
            DatataskParameter param = (DatataskParameter)this.params.get(0);
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                if (!StringUtils.equals((String)sheet.getSheetName(), (String)param.alias)) continue;
                this.CreatNewExcel(sheet, wb, newStrPath);
                break;
            }
            String string = newStrPath;
            return string;
        }
    }

    private void CreatNewExcel(HSSFSheet sheet, HSSFWorkbook wb, String newStrPath) throws IOException {
        HSSFWorkbook wbCreat = new HSSFWorkbook();
        workbook = wbCreat;
        HSSFSheet sheetCreat = wbCreat.createSheet(sheet.getSheetName());
        this.createOrgStructCellStyle();
        this.createOrgStructCellStyle1();
        this.createOrgStructNeedCellStyle();
        this.createTitleCellStyle();
        this.createValueCellStyle();
        this.createErrorReasonStyle();
        this.MergerRegion(sheetCreat, sheet);
        int firstRow = sheet.getFirstRowNum();
        int lastRow = sheet.getLastRowNum();
        int fieldNumRowNum = dataRowNum - 2;
        int fieldNameRowNum = dataRowNum - 1;
        DatataskParameter param = (DatataskParameter)this.params.get(0);
        ErrorHandleModeEnum errorHandleMode = (ErrorHandleModeEnum)((Object)param.getContextParam().get("errorHandleMode"));
        ArrayList<Integer> errorRowNumList = new ArrayList<Integer>();
        for (int i = 0; i < this.logs.getErrorDetailCount(); ++i) {
            errorRowNumList.add(this.logs.getErrorRowNum(i) - 1);
        }
        int m = 0;
        for (int i = firstRow; i <= lastRow; ++i) {
            String errorDetail = null;
            int newRowNum = 0;
            if (errorHandleMode == ErrorHandleModeEnum.ReturnWhenFinish) {
                if (i >= dataRowNum && errorRowNumList.contains(i - dataRowNum)) {
                    errorDetail = this.logs.getErrorDetail(errorRowNumList.indexOf(i - dataRowNum));
                    newRowNum = fieldNameRowNum + ++m;
                } else if (i >= dataRowNum) continue;
            }
            if (errorHandleMode == ErrorHandleModeEnum.ReturnRightnow) {
                int errorNum = 0;
                errorNum = this.logs.isBatchLog() ? this.logs.getBlockBeginorRowNum(0) - 1 : (Integer)errorRowNumList.get(0);
                if (i >= (errorNum += dataRowNum)) {
                    errorDetail = "";
                    newRowNum = i - errorNum;
                    if (errorRowNumList.contains(i - dataRowNum)) {
                        errorDetail = this.logs.getErrorDetail(errorRowNumList.indexOf(i - dataRowNum));
                    }
                } else if (i >= dataRowNum && errorRowNumList.contains(i)) {
                    errorDetail = this.logs.getErrorDetail(errorRowNumList.indexOf(i));
                    newRowNum = fieldNameRowNum + ++m;
                } else if (i >= dataRowNum && i < errorNum) continue;
            }
            HSSFRow rowCreat = null;
            rowCreat = i < dataRowNum ? sheetCreat.createRow(i) : sheetCreat.createRow(newRowNum);
            HSSFRow row = sheet.getRow(i);
            int firstCell = 0;
            int lastCell = row.getLastCellNum();
            block11: for (int j = firstCell; j < lastCell; ++j) {
                sheetCreat.setDefaultColumnStyle(j, (CellStyle)this.valueStyle);
                int n = j;
                if (i >= fieldNumRowNum) {
                    ++n;
                }
                if (rowCreat.getCell(n) == null) {
                    rowCreat.createCell(n);
                }
                rowCreat.getCell(n).setCellStyle(this.valueStyle);
                if (i <= fieldNumRowNum) {
                    rowCreat.getCell(n).setCellStyle(this.orgStructStyle);
                }
                if (i == fieldNumRowNum && j == firstCell) {
                    rowCreat.createCell(j).setCellValue("ErrorReason");
                    rowCreat.getCell(j).setCellStyle(this.orgStructStyle);
                }
                if (i == fieldNameRowNum) {
                    rowCreat.getCell(n).setCellStyle(this.orgStructStyle1);
                }
                if (i == fieldNameRowNum && j == firstCell) {
                    String errReason = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason");
                    rowCreat.createCell(j).setCellValue(errReason);
                    rowCreat.getCell(j).setCellStyle(this.errorReasonStyle);
                }
                if (i >= dataRowNum && j == firstCell) {
                    rowCreat.createCell(j).setCellValue(errorDetail);
                    rowCreat.getCell(j).setCellStyle(this.errorReasonStyle);
                }
                if (!(i != 0 && i != 1 || j != 0 && j != 1)) {
                    rowCreat.createCell(n).setCellStyle(this.orgStructStyle);
                }
                if (i == 0 && j == 2) {
                    rowCreat.createCell(n).setCellStyle(this.titleStyle);
                }
                if (row.getCell(j) == null) continue;
                switch (row.getCell(j).getCellType()) {
                    case STRING: {
                        String strVal = row.getCell(j).getStringCellValue();
                        if (strVal.contains("*")) {
                            rowCreat.getCell(n).setCellStyle(this.orgStructNeedCellStyle);
                        }
                        rowCreat.getCell(n).setCellValue(strVal);
                        continue block11;
                    }
                    case NUMERIC: {
                        rowCreat.getCell(n).setCellValue(row.getCell(j).getNumericCellValue());
                        continue block11;
                    }
                    case FORMULA: {
                        try {
                            rowCreat.getCell(n).setCellValue(String.valueOf(row.getCell(j).getNumericCellValue()));
                            continue block11;
                        }
                        catch (IllegalStateException e) {
                            try {
                                rowCreat.getCell(n).setCellValue(String.valueOf(row.getCell(j).getRichStringCellValue()));
                                continue block11;
                            }
                            catch (Exception ex) {
                                rowCreat.getCell(n).setCellValue("error data");
                            }
                        }
                    }
                }
            }
        }
        FileOutputStream fileOut = new FileOutputStream(newStrPath);
        wbCreat.write((OutputStream)fileOut);
        fileOut.close();
        if (GenerateErrorDataExcel.isWindows()) {
            String cmd = "cmd /c start " + newStrPath.replace(" ", "\" \"");
            Runtime.getRuntime().exec(cmd);
        } else {
            String[] cmdArray = new String[]{"xdg-open", newStrPath};
            Runtime.getRuntime().exec(cmdArray);
        }
    }

    private void MergerRegion(HSSFSheet sheetCreat, HSSFSheet sheet) {
        int sheetMergerCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergerCount; ++i) {
            sheetCreat.addMergedRegion(sheet.getMergedRegion(i));
        }
    }

    private boolean isInMergerCellRegion(HSSFSheet sheet, int intCellRow, int intCellCol) throws IOException {
        boolean retVal = false;
        int sheetMergerCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergerCount; ++i) {
            CellRangeAddress cra = sheet.getMergedRegion(i);
            int firstRow = cra.getFirstRow();
            int firstCol = cra.getFirstColumn();
            int lastRow = cra.getFirstColumn();
            int lastCol = cra.getLastColumn();
            if (intCellRow < firstRow || intCellRow > lastRow || intCellCol < firstCol || intCellCol > lastCol) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private String getNewExcelName(String strPath) {
        if (strPath == null) {
            return null;
        }
        try {
            String filename = strPath;
            int i = filename.lastIndexOf(46);
            int j = filename.lastIndexOf(File.separator);
            if (i > 0 && i < filename.length() - 1 && j < i) {
                filename = filename.substring(j + 1, i);
                File clientFile = File.createTempFile(filename + System.currentTimeMillis(), ".xls");
                return clientFile.getAbsolutePath();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private void createOrgStructCellStyle() {
        this.orgStructStyle = null;
        if (this.orgStructStyle == null) {
            this.orgStructStyle = workbook.createCellStyle();
            this.orgStructStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
            this.orgStructStyle.setAlignment(HorizontalAlignment.LEFT);
            this.orgStructStyle.setHidden(false);
            this.orgStructStyle.setLocked(false);
            this.orgStructStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle.setBottomBorderColor(backColorIndex);
            this.orgStructStyle.setTopBorderColor(backColorIndex);
            this.orgStructStyle.setLeftBorderColor(backColorIndex);
            this.orgStructStyle.setRightBorderColor(backColorIndex);
            this.orgStructStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle.setFont(defaultFont);
        }
    }

    private void createOrgStructCellStyle1() {
        this.orgStructStyle1 = null;
        if (this.orgStructStyle1 == null) {
            this.orgStructStyle1 = workbook.createCellStyle();
            this.orgStructStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle1.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructStyle1.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructStyle1.setHidden(false);
            this.orgStructStyle1.setLocked(false);
            this.orgStructStyle1.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle1.setBottomBorderColor(backColorIndex);
            this.orgStructStyle1.setTopBorderColor(backColorIndex);
            this.orgStructStyle1.setLeftBorderColor(backColorIndex);
            this.orgStructStyle1.setRightBorderColor(backColorIndex);
            this.orgStructStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle1.setFont(defaultFont);
        }
    }

    private void createOrgStructNeedCellStyle() {
        this.orgStructNeedCellStyle = null;
        if (this.orgStructNeedCellStyle == null) {
            this.orgStructNeedCellStyle = workbook.createCellStyle();
            this.orgStructNeedCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructNeedCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructNeedCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructNeedCellStyle.setHidden(false);
            this.orgStructNeedCellStyle.setLocked(false);
            this.orgStructNeedCellStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructNeedCellStyle.setBottomBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setTopBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setLeftBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setRightBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructNeedCellStyle.setFont(defaultFont);
        }
    }

    private void createValueCellStyle() {
        this.valueStyle = null;
        if (this.valueStyle == null) {
            this.valueStyle = workbook.createCellStyle();
            this.valueStyle.setAlignment(HorizontalAlignment.LEFT);
            this.valueStyle.setHidden(true);
            this.valueStyle.setLocked(false);
            this.valueStyle.setBorderLeft(BorderStyle.DOTTED);
            this.valueStyle.setBorderRight(BorderStyle.DOTTED);
            this.valueStyle.setBorderTop(BorderStyle.DOTTED);
            this.valueStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.valueStyle.setBottomBorderColor(backColorIndex);
            this.valueStyle.setTopBorderColor(backColorIndex);
            this.valueStyle.setLeftBorderColor(backColorIndex);
            this.valueStyle.setRightBorderColor(backColorIndex);
            this.valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.valueStyle.setFont(defaultFont);
            this.valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        }
    }

    private void createErrorReasonStyle() {
        this.errorReasonStyle = null;
        if (this.errorReasonStyle == null) {
            this.errorReasonStyle = workbook.createCellStyle();
            this.errorReasonStyle.setAlignment(HorizontalAlignment.CENTER);
            this.errorReasonStyle.setHidden(true);
            this.errorReasonStyle.setLocked(false);
            this.errorReasonStyle.setBorderLeft(BorderStyle.DOTTED);
            this.errorReasonStyle.setBorderRight(BorderStyle.DOTTED);
            this.errorReasonStyle.setBorderTop(BorderStyle.DOTTED);
            this.errorReasonStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.errorReasonStyle.setBottomBorderColor(backColorIndex);
            this.errorReasonStyle.setTopBorderColor(backColorIndex);
            this.errorReasonStyle.setLeftBorderColor(backColorIndex);
            this.errorReasonStyle.setRightBorderColor(backColorIndex);
            this.errorReasonStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.errorReasonStyle.setFont(defaultFont);
            this.errorReasonStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        }
    }

    private void createTitleCellStyle() {
        this.titleStyle = null;
        if (this.titleStyle == null) {
            this.titleStyle = workbook.createCellStyle();
            this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.titleStyle.setAlignment(HorizontalAlignment.LEFT);
            this.titleStyle.setHidden(false);
            this.titleStyle.setLocked(false);
            this.titleStyle.setBorderLeft(BorderStyle.NONE);
            this.titleStyle.setBorderRight(BorderStyle.NONE);
            this.titleStyle.setBorderTop(BorderStyle.NONE);
            this.titleStyle.setBorderBottom(BorderStyle.NONE);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.titleStyle.setBottomBorderColor(backColorIndex);
            this.titleStyle.setTopBorderColor(backColorIndex);
            this.titleStyle.setLeftBorderColor(backColorIndex);
            this.titleStyle.setRightBorderColor(backColorIndex);
            this.titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
            short size = 18;
            defaultFont.setFontHeight(size);
            defaultFont.setFontHeightInPoints(size);
            this.titleStyle.setFont(defaultFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delErrorLogColumn(String strPath) throws Exception {
        FileInputStream in = null;
        FileOutputStream fileOut = null;
        try {
            HSSFWorkbook wb;
            in = new FileInputStream(strPath);
            workbook = wb = new HSSFWorkbook((InputStream)in);
            this.createOrgStructCellStyle();
            this.createOrgStructCellStyle1();
            this.createOrgStructNeedCellStyle();
            this.createValueCellStyle();
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                int fieldNumRowNum;
                HSSFSheet sheet = wb.getSheetAt(i);
                int rowCount = sheet.getPhysicalNumberOfRows();
                for (int j = fieldNumRowNum = dataRowNum - 2; j < rowCount; ++j) {
                    HSSFRow row = sheet.getRow(j);
                    this.delCell(row, 0);
                }
            }
            fileOut = new FileOutputStream(strPath);
            wb.write((OutputStream)fileOut);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void delCell(HSSFRow row, int index) {
        short lastcell = row.getLastCellNum();
        int rowNum = row.getRowNum();
        block9: for (int i = index; i < lastcell - 1; ++i) {
            if (rowNum <= dataRowNum - 2) {
                row.getCell(i).setCellStyle(this.orgStructStyle);
            } else if (rowNum == dataRowNum - 1) {
                row.getCell(i).setCellStyle(this.orgStructStyle1);
            } else {
                row.getCell(i).setCellStyle(this.valueStyle);
            }
            if (row.getCell(i + 1) == null) {
                row.createCell(i + 1);
                row.getCell(i + 1).setCellType(CellType.STRING);
            }
            switch (row.getCell(i + 1).getCellType()) {
                case STRING: {
                    String strVal = row.getCell(i + 1).getStringCellValue();
                    if (strVal.contains("*")) {
                        row.getCell(i).setCellStyle(this.orgStructNeedCellStyle);
                    }
                    row.getCell(i).setCellValue(strVal);
                    continue block9;
                }
                case NUMERIC: {
                    row.getCell(i).setCellValue(row.getCell(i + 1).getNumericCellValue());
                    continue block9;
                }
                case FORMULA: {
                    try {
                        row.getCell(i).setCellValue(String.valueOf(row.getCell(i + 1).getNumericCellValue()));
                    }
                    catch (IllegalStateException e) {
                        try {
                            row.getCell(i).setCellValue(String.valueOf(row.getCell(i + 1).getRichStringCellValue()));
                        }
                        catch (Exception ex) {
                            row.getCell(i).setCellValue("error data");
                        }
                    }
                    continue block9;
                }
                default: {
                    row.getCell(i).setCellValue("");
                }
            }
        }
        row.removeCell((Cell)row.getCell(lastcell - 1));
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

