/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.task.AbstractTaskBaseRunner;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractTaskRunner
extends AbstractTaskBaseRunner {
    protected boolean isCodeImplementTrans;
    protected boolean isUserDefineTrans;
    protected boolean isScriptTrans;
    protected IDataTransmission iDataTrans;
    protected DefaultDataTransmission defaultTrans;
    protected int submittype;
    protected TaskExternalCode taskCode;
    protected boolean isAfterAllProcess;
    protected boolean isSkipMainProcess;

    public AbstractTaskRunner(ITask task, Context ctx) {
        super(task, ctx);
        this.taskCode = (TaskExternalCode)task;
    }

    protected abstract boolean hasNext() throws TaskRunnerException;

    protected abstract void onEachRunningLoop() throws Exception;

    protected abstract void onDataError(Throwable var1) throws TaskRunnerException;

    protected abstract void onDataSuccess() throws TaskRunnerException;

    protected abstract void onAfterProcess() throws TaskRunnerException;

    @Override
    protected void onMainRunningProcess() throws TaskRunnerException {
        this.onBeforeProcess();
        this.onRecordProcess();
        this.onAfterProcess();
    }

    protected void onBeforeProcess() throws TaskRunnerException {
        try {
            this.onInitBizDataTransmit();
        }
        catch (TaskRunnerException e) {
            throw new TaskRunnerException(4, (Throwable)((Object)e));
        }
    }

    protected void onBeforeLoop() throws TaskRunnerException {
    }

    protected void onRecordProcess() throws TaskRunnerException {
        while (this.hasNext()) {
            try {
                this.onEachRunningLoop();
            }
            catch (Throwable ex) {
                this.onDataError(ex);
            }
            this.onDataSuccess();
        }
    }

    private void onInitBizDataTransmit() throws TaskRunnerException {
        this.isCodeImplementTrans = TaskUtil.isCodeImplementTrans(this.taskCode);
        this.isUserDefineTrans = TaskUtil.isUserDefineTrans(this.taskCode);
        this.isScriptTrans = TaskUtil.isScriptTrans(this.taskCode);
        if (this.isCodeImplementTrans) {
            this.createDataTransmissionObject();
        } else {
            this.iDataTrans = new DefaultDataTransmission(this.ctx);
            ((DefaultDataTransmission)this.iDataTrans).setDIETemplateInfo(this.taskCode.getDIETemplateInfo());
            ((DefaultDataTransmission)this.iDataTrans).setContext(this.ctx);
            this.iDataTrans.setContextParameter(this.initContextParameter());
        }
        if (this.iDataTrans instanceof DefaultDataTransmission) {
            this.defaultTrans = (DefaultDataTransmission)this.iDataTrans;
        } else {
            this.defaultTrans = new DefaultDataTransmission(this.ctx);
            this.defaultTrans.setDIETemplateInfo(this.taskCode.getDIETemplateInfo());
            this.defaultTrans.setContext(this.ctx);
            this.defaultTrans.setContextParameter(this.initContextParameter());
        }
        this.isAfterAllProcess = this.iDataTrans.isAfterAllProcess();
        this.isSkipMainProcess = this.iDataTrans.isSkipMainProcess();
        this.submittype = this.iDataTrans.getSubmitType();
        this.defaultTrans.setCodeImplementTrans(this.isCodeImplementTrans);
        this.defaultTrans.setUserDefineTrans(this.isUserDefineTrans);
        if (this.iDataTrans instanceof BlockDataTransmission) {
            this.submittype = 1;
        }
    }

    private void createDataTransmissionObject() throws TaskRunnerException {
        if (StringUtils.isEmpty((String)this.taskCode.getDataTransmissionClassName())) {
            return;
        }
        try {
            Class<?> classDefinition = Class.forName(this.taskCode.getDataTransmissionClassName());
            this.iDataTrans = (IDataTransmission)classDefinition.newInstance();
            this.iDataTrans.setContextParameter(this.initContextParameter());
        }
        catch (Exception e) {
            logger.error((Object)e);
            String detail = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "62_TaskExportEASDataRunner", new Object[]{this.taskCode.getDataTransmissionClassName()});
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, e);
        }
    }

    private Map initContextParameter() {
        HashMap contextParam = new HashMap();
        DatataskParameter dp = (DatataskParameter)this.taskCode.getTaskParameter();
        if (dp == null) {
            dp = (DatataskParameter)this.taskCode.getTaskParameterMap().values().iterator().next();
        }
        if (dp != null) {
            Map myParam = dp.getContextParam();
            contextParam.putAll(myParam);
        }
        return contextParam;
    }

    protected int getSubmitType() {
        if (this.iDataTrans != null) {
            return this.iDataTrans.getSubmitType();
        }
        return 0;
    }

    private TaskExternalCode getTaskExternalCode(String solutionName) throws BOSException {
        IDIETemplate dt = DIETemplateFactory.getLocalInstance(this.ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterItemInfo itemInfo = new FilterItemInfo("number", (Object)solutionName);
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().getFilterItems().add(itemInfo);
        DIETemplateInfo templateInfo = dt.getDIETemplateCollection(viewInfo).get(0);
        if (templateInfo == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"2_DatataskRunServerControllerBean", (Locale)this.ctx.getLocale()) + solutionName + ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"3_DatataskRunServerControllerBean", (Locale)this.ctx.getLocale()));
        }
        return TaskTemplateAdapter.getTaskExternalCode(templateInfo, this.locale);
    }
}

