/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.task.InspectorCreator;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InspectorCreatorWithCache {
    private static String CREATOR = "FCreatorNumber";
    private static String CREATIME = "FCreateTime";
    private static Logger logger = SysLog.getLogger(InspectorCreator.class);
    private Map<String, UserInfo> cache = new HashMap<String, UserInfo>();
    private Set<String> notFoundCache = new HashSet<String>();

    public CoreBaseInfo attachCreator(CoreBaseInfo info, Map data, Context ctx) throws TaskRunnerException {
        if (info instanceof ObjectBaseInfo) {
            ObjectBaseInfo tmpInfo = (ObjectBaseInfo)info;
            DataToken dt = (DataToken)data.get(CREATOR);
            if (dt != null) {
                String creatorNumber = (String)dt.data;
                UserInfo creatorInfo = this.cache.get(creatorNumber);
                if (creatorInfo == null && !this.notFoundCache.contains(creatorNumber) && tmpInfo.getCreator() == null && creatorNumber != null && !creatorNumber.trim().equals("")) {
                    IUser user = null;
                    UserCollection uc = null;
                    try {
                        user = UserFactory.getLocalInstance((Context)ctx);
                        uc = user.getUserCollection("where number = '" + creatorNumber + "'");
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                    if (uc != null && uc.size() > 0) {
                        creatorInfo = uc.get(0);
                        this.cache.put(creatorNumber, creatorInfo);
                    } else {
                        this.notFoundCache.add(creatorNumber);
                    }
                }
                if (tmpInfo != null && creatorInfo != null) {
                    tmpInfo.setCreator(creatorInfo);
                }
            }
            DataToken dt1 = (DataToken)data.get(CREATIME);
            if (dt != null && dt1 != null) {
                String createTime = (String)dt1.data;
                if (tmpInfo.getCreateTime() == null && createTime != null && !createTime.trim().equals("")) {
                    Date d = ExcelUtil.formatNationalDate(ctx, createTime);
                    if (d != null) {
                        Timestamp ts = new Timestamp(d.getTime());
                        tmpInfo.setCreateTime(ts);
                    } else {
                        String df = ExcelUtil.getDateFomartString(ctx);
                        String s = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "dateFormatError", ctx.getLocale());
                        MessageFormat mf = new MessageFormat(s);
                        throw new TaskExternalException(mf.format(new Object[]{df, CREATIME, createTime}));
                    }
                }
            }
            return tmpInfo;
        }
        return info;
    }
}

