/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskParameter;
import com.kingdee.eas.tools.datatask.task.MultiExcelInfo;
import com.kingdee.eas.tools.datatask.task.MultitaskExcelSchedule;
import com.kingdee.eas.tools.datatask.task.MultitaskImportExcelRunner;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.task.WriterToExcelFile;
import com.kingdee.eas.tools.datatask.task.util.ExcelParam;
import com.kingdee.eas.tools.datatask.task.util.TaskEnum;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MultitaskImportParse
implements Callable<Boolean> {
    private static Logger logger = SysLog.getLogger(MultitaskImportParse.class);
    private Map<String, MultiExcelInfo> excelMap = new HashMap<String, MultiExcelInfo>();
    private Context ctx;
    private Map<String, List<DatataskParameter>> solutionFile = new HashMap<String, List<DatataskParameter>>();
    private Map<Integer, List<String>> seq2Solu = new TreeMap<Integer, List<String>>();
    private Map<String, Excel2007Writer> errExcelWriteMap = new HashMap<String, Excel2007Writer>();
    private Map<String, ITask> taskMap = new HashMap<String, ITask>();
    private Map<String, Integer> solu2Seq = new HashMap<String, Integer>();
    private List<TaskResult> currentTaskRs = new ArrayList<TaskResult>();
    private Map<String, Future<TaskResult>> fImportMap = new HashMap<String, Future<TaskResult>>();
    private CompletionService<TaskResult> esc;
    private final BlockingQueue<TaskResult> interruptTaskRs = new ArrayBlockingQueue<TaskResult>(20);
    private String filePath;
    private String taskUuId;
    private Map ctxParam;

    public MultitaskImportParse(String taskUuId, List<MultiExcelInfo> excelList, Map ctxParam, Context ctx) {
        this.ctx = ctx;
        this.filePath = GlobalFunction.getFilePathForServer();
        this.taskUuId = taskUuId;
        this.ctxParam = ctxParam;
        this.esc = MultitaskExcelSchedule.getCompletionSrv();
        this.init(excelList);
    }

    private void init(List<MultiExcelInfo> excelList) {
        this.orderBySeq(excelList);
        this.initBizParam();
    }

    @Override
    public Boolean call() throws Exception {
        boolean rs = true;
        try {
            this.parseTask();
        }
        catch (TaskRunnerException e) {
            logger.error((Object)e);
        }
        finally {
            MultitaskExcelSchedule.putDonemap(this.taskUuId, true);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseTask() throws TaskRunnerException {
        try {
            Map<String, ExcelParam> shareParams = this.getAllExcelSheetParam();
            for (Map.Entry<Integer, List<String>> seqSolu : this.seq2Solu.entrySet()) {
                int seq = seqSolu.getKey();
                List<String> soluList = seqSolu.getValue();
                for (String solu : soluList) {
                    ITask task = this.taskMap.get(solu);
                    Map<String, ExcelParam> expMap = this.getExcelParamMap(solu);
                    MultitaskImportExcelRunner taskRunner = new MultitaskImportExcelRunner(task, expMap, this.ctx, this.interruptTaskRs);
                    taskRunner.setTaskRsKey(solu);
                    taskRunner.setShareParams(shareParams);
                    Future<TaskResult> fImport = this.esc.submit(taskRunner);
                    this.fImportMap.put(solu, fImport);
                }
                this.taskRsDeal();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, e.getCause());
        }
        finally {
            this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskRsDeal() throws TaskRunnerException {
        block7: {
            boolean dealRs = true;
            try {
                int size = this.fImportMap.size();
                for (int i = 0; i < size; ++i) {
                    TaskResult rs = this.interruptTaskRs.take();
                    String solu = rs.getKey();
                    if (!rs.getTaskEnum().equals((Object)TaskEnum.importTask)) continue;
                    this.currentTaskRs.add(rs);
                    this.fImportMap.remove(solu);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread();
                Thread.interrupted();
                logger.error((Object)e);
                dealRs = false;
            }
            finally {
                this.interruptChildThread();
                if (dealRs) {
                    dealRs = this.getBatchTaskRs();
                }
                if (dealRs) break block7;
                throw new TaskRunnerException(4, "");
            }
        }
    }

    private boolean getBatchTaskRs() {
        boolean dealRs = true;
        for (TaskResult rs : this.currentTaskRs) {
            if (rs.isSucced()) continue;
            dealRs = false;
            break;
        }
        return dealRs;
    }

    private void checkHasNextTask(TaskResult rs) throws BOSException {
        if (!rs.isSucced()) {
            String key = rs.getKey();
            int seq = Integer.parseInt(key.substring(key.indexOf("_") + 1));
            Set<Integer> seqs = this.seq2Solu.keySet();
            for (int i : seqs) {
                if (i <= seq) continue;
                throw new BOSException("");
            }
        }
    }

    private void initBizParam() {
        Set<String> soluSet = this.solutionFile.keySet();
        try {
            for (String solu : soluSet) {
                TaskExternalCode task = TaskTemplateAdapter.getTaskExternalCode(solu, this.ctx);
                ErrorHandleModeEnum errMode = this.setDataErrorHandle(this.solu2Seq.get(solu));
                List<DatataskParameter> taskParamList = this.solutionFile.get(solu);
                task.setTaskParameterMap(this.buildBizParam(taskParamList, errMode));
                task.setTaskUuID(this.taskUuId);
                this.taskMap.put(solu, task);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private ErrorHandleModeEnum setDataErrorHandle(int seq) {
        ErrorHandleModeEnum errMode = ErrorHandleModeEnum.ReturnWhenFinish;
        return errMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptChildThread() {
        for (Map.Entry<String, Future<TaskResult>> childTask : this.fImportMap.entrySet()) {
            Future<TaskResult> fu = childTask.getValue();
            if (fu.isDone()) continue;
            fu.cancel(true);
        }
        int size = this.fImportMap.size();
        try {
            for (int i = 0; i < size; ++i) {
                this.interruptTaskRs.take();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        finally {
            this.interruptTaskRs.clear();
            this.fImportMap.clear();
        }
    }

    private void startWriteErrTask() {
        Map<String, ExcelParam> expMap = this.getUnImportParamMap();
        for (Map.Entry<String, ExcelParam> entry : expMap.entrySet()) {
            ExcelParam exp = entry.getValue();
            String fileUuId = entry.getKey();
            WriterToExcelFile taskRunner = new WriterToExcelFile(exp, this.interruptTaskRs);
            taskRunner.setTaskRsKey(fileUuId);
            Future<TaskResult> fImport = this.esc.submit(taskRunner);
            this.fImportMap.put(fileUuId, fImport);
        }
    }

    private void delTemFile() {
        for (String fileUuId : this.excelMap.keySet()) {
            String tempFileName = GlobalFunction.getFileTempSavePath(fileUuId);
            File file = new File(tempFileName);
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        List<String> errFiles = this.getImportedFile();
        for (String fileUuId : errFiles) {
            this.processFile(fileUuId);
        }
        this.startWriteErrTask();
        try {
            int count = this.fImportMap.size();
            for (int i = 0; i < count; ++i) {
                TaskResult rs = this.interruptTaskRs.take();
                String fileUuId = rs.getKey();
                if (!rs.getTaskEnum().equals((Object)TaskEnum.exportTask)) continue;
                this.processFile(fileUuId);
                this.fImportMap.remove(fileUuId);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            for (Map.Entry<String, Future<TaskResult>> importTask : this.fImportMap.entrySet()) {
                Future<TaskResult> fu = importTask.getValue();
                if (fu == null || fu.isDone()) continue;
                fu.cancel(true);
            }
            this.interruptTaskRs.clear();
            this.fImportMap.clear();
        }
    }

    private void processFile(String fileUuId) {
        try {
            Excel2007Writer excelWriter = this.errExcelWriteMap.get(fileUuId);
            MultiExcelInfo excelInfo = this.excelMap.get(fileUuId);
            Set<Integer> errSheets = excelWriter.getErrSheets();
            Set<Integer> notImportSheets = excelWriter.getNotImportSheets();
            errSheets.addAll(notImportSheets);
            Map<Integer, String> sheetIdAndName = excelInfo.takeSubSheetId2NameBySheetId(errSheets);
            int index = 0;
            Object[] sheetIds = sheetIdAndName.keySet().toArray(new Integer[0]);
            Arrays.sort(sheetIds);
            Object[] objectArray = sheetIds;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                int sheetId = (Integer)objectArray[i];
                excelWriter.getWb().setSheetOrder(sheetIdAndName.get(sheetId), index);
                ++index;
            }
            excelWriter.processFile();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Map<String, ExcelParam> getUnImportParamMap() {
        HashMap<String, ExcelParam> expMap = new HashMap<String, ExcelParam>();
        for (Map.Entry<String, Excel2007Writer> entry : this.errExcelWriteMap.entrySet()) {
            Set<Integer> notImportSheets;
            String fileUuId = entry.getKey();
            Excel2007Writer excelWriter = entry.getValue();
            if (!excelWriter.hasErrSheets() || (notImportSheets = excelWriter.getNotImportSheets()).size() <= 0) continue;
            MultiExcelInfo excelInfo = this.excelMap.get(fileUuId);
            ExcelParam exp = this.getExcelParam(excelInfo, notImportSheets);
            expMap.put(fileUuId, exp);
        }
        return expMap;
    }

    private List<String> getImportedFile() {
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry<String, Excel2007Writer> entry : this.errExcelWriteMap.entrySet()) {
            String fileUuId = entry.getKey();
            Excel2007Writer excelWriter = entry.getValue();
            if (!excelWriter.hasErrSheets()) continue;
            Set<Integer> notImportSheets = excelWriter.getNotImportSheets();
            Set<Integer> errSheets = excelWriter.getErrSheets();
            if (errSheets.size() <= 0 || notImportSheets.size() != 0) continue;
            files.add(fileUuId);
        }
        return files;
    }

    private Map<String, ITaskParameter> buildBizParam(List<DatataskParameter> taskparamList, ErrorHandleModeEnum errMode) {
        HashMap<String, ITaskParameter> map = new HashMap<String, ITaskParameter>();
        for (DatataskParameter taskparam : taskparamList) {
            taskparam.datataskMode = Integer.parseInt(this.ctxParam.get("DATATASKMODE").toString());
            String solu = taskparam.getSolutionName();
            HashMap<String, Integer> bizmap = (HashMap<String, Integer>)this.ctxParam.get(solu);
            if (bizmap == null) {
                bizmap = new HashMap<String, Integer>();
            }
            bizmap.put("DATATASKMODE", taskparam.datataskMode);
            taskparam.setContextParam(bizmap);
            taskparam.getContextParam().put("errorHandleMode", errMode);
            taskparam.getContextParam().putAll(this.ctxParam);
            map.put(taskparam.getFileUuId(), taskparam);
        }
        return map;
    }

    private ExcelParam getExcelParam(MultiExcelInfo excelInfo, Set<Integer> sheetIds) {
        String fileUuId = excelInfo.getFileUuId();
        Excel2007Writer excelWriter = this.errExcelWriteMap.get(fileUuId);
        HashMap<Integer, ExternalStructInfo> structMap = new HashMap<Integer, ExternalStructInfo>();
        DatataskParameter taskparam = new DatataskParameter();
        taskparam.setFileUuId(fileUuId);
        taskparam.setFileName(excelInfo.getFileName());
        if (sheetIds == null) {
            sheetIds = excelInfo.getSheetId2Name().keySet();
            taskparam.setSheetIdAndName(excelInfo.getSheetId2Name());
        } else {
            taskparam.setSheetIdAndName(excelInfo.takeSubSheetId2NameBySheetId(sheetIds));
        }
        for (int sheetId : sheetIds) {
            String solu = excelInfo.getSheetId2Solu().get(sheetId);
            TaskExternalCode task = (TaskExternalCode)this.taskMap.get(solu);
            structMap.put(sheetId, task.getExternalStructInfo());
        }
        ExcelParam exp = new ExcelParam(excelWriter, taskparam, structMap);
        return exp;
    }

    public Map<String, ExcelParam> getAllExcelSheetParam() {
        HashMap<String, ExcelParam> param = new HashMap<String, ExcelParam>();
        for (String fileUuId : this.excelMap.keySet()) {
            MultiExcelInfo excelInfo = this.excelMap.get(fileUuId);
            param.put(fileUuId, this.getExcelParam(excelInfo, null));
        }
        return param;
    }

    private Map<String, ExcelParam> getExcelParamMap(String solu) {
        HashMap<String, ExcelParam> expMap = new HashMap<String, ExcelParam>();
        TaskExternalCode task = (TaskExternalCode)this.taskMap.get(solu);
        List<DatataskParameter> taskparamList = this.solutionFile.get(solu);
        for (DatataskParameter taskparam : taskparamList) {
            String fileUuId = taskparam.getFileUuId();
            Excel2007Writer excelWriter = this.errExcelWriteMap.get(fileUuId);
            Set<Integer> sheetIds = taskparam.getSheetIdAndName().keySet();
            HashMap<Integer, ExternalStructInfo> structMap = new HashMap<Integer, ExternalStructInfo>();
            for (int sheetId : sheetIds) {
                structMap.put(sheetId, task.getExternalStructInfo());
            }
            ExcelParam exp = new ExcelParam(excelWriter, taskparam, structMap);
            expMap.put(fileUuId, exp);
        }
        return expMap;
    }

    private void orderBySeq(List<MultiExcelInfo> excelList) {
        for (MultiExcelInfo excelinfo : excelList) {
            String fileUuId = excelinfo.getFileUuId();
            this.excelMap.put(fileUuId, excelinfo);
            this.errExcelWriteMap.put(fileUuId, new Excel2007Writer(this.filePath + excelinfo.getErrFileUuId()));
            Map<String, Integer> ssmap = excelinfo.getSolu2Seq();
            this.solu2Seq.putAll(ssmap);
            for (Map.Entry<String, Integer> entry : ssmap.entrySet()) {
                String solution = entry.getKey();
                int seq = entry.getValue();
                Map<Integer, String> sheetIdAndName = excelinfo.takeSheetId2NameBySolu(solution);
                DatataskParameter taskparam = new DatataskParameter();
                taskparam.setFileUuId(fileUuId);
                taskparam.setFileName(excelinfo.getFileName());
                taskparam.setSolutionName(solution);
                taskparam.setSheetIdAndName(sheetIdAndName);
                List<DatataskParameter> taskList = this.solutionFile.get(solution);
                if (taskList == null) {
                    taskList = new ArrayList<DatataskParameter>();
                }
                taskList.add(taskparam);
                this.solutionFile.put(solution, taskList);
                List<String> soluList = this.seq2Solu.get(seq);
                if (soluList == null) {
                    soluList = new ArrayList<String>();
                }
                if (soluList.contains(solution)) continue;
                soluList.add(solution);
                this.seq2Solu.put(seq, soluList);
            }
        }
    }
}

