/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.core.TaskType;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskParameter;
import com.kingdee.eas.tools.datatask.task.ITaskRunnerAdapter;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.jdom2.Attribute;
import org.jdom2.Element;

public abstract class TaskBase
implements ITask,
Serializable {
    protected String name = "";
    protected HashMap nameMap = new HashMap();
    protected String number = "";
    protected int nChecked = 16;
    protected int taskErrHandleStrategy = 0;
    protected int dataErrHandleStrategy = 5;
    protected int rollbackStrategy;
    protected int dbIndex = 1;
    protected int taskType = 0;
    protected Window parent = null;
    protected DefaultKingdeeTreeNode myNode = null;
    protected ITaskRunnerAdapter runner = null;
    protected boolean isServerRunning = false;
    protected boolean isOptimize = false;
    protected static Locale locale = null;
    private String taskUuID;
    private ITaskParameter _param = null;
    private Map<String, ITaskParameter> paramMap;

    public TaskBase(Window parent) {
        this.parent = parent;
        locale = SysContext.getSysContext().getLocale();
    }

    @Override
    public void setTaskUuID(String uuid) {
        this.taskUuID = uuid;
    }

    @Override
    public String getTaskUuID() {
        return this.taskUuID;
    }

    @Override
    public void setIsOptimize(boolean isOptimize) {
        this.isOptimize = isOptimize;
    }

    @Override
    public boolean isOptimize() {
        return this.isOptimize;
    }

    @Override
    public void setRollbackStrategy(int rollbackStrategy) {
        this.rollbackStrategy = rollbackStrategy;
    }

    @Override
    public int getRollbackStrategy() {
        return this.rollbackStrategy;
    }

    @Override
    public boolean isServerRunning() {
        return this.isServerRunning;
    }

    public void addMultiLangName(Locale locale, String value) {
        Locale tmp = locale;
        if (tmp == null) {
            return;
        }
        this.nameMap.put("name_" + tmp.getCountry().toString().toLowerCase(), value);
        if (tmp.getCountry().toString().equalsIgnoreCase("l2")) {
            this.name = value;
        }
    }

    public String getMultiLangName(Locale locale) {
        Locale tmp = locale;
        if (tmp == null) {
            return null;
        }
        return (String)this.nameMap.get("name_" + tmp.getCountry().toString().toLowerCase());
    }

    @Override
    public ITaskRunnerAdapter getRunnerAdapter() {
        return this.runner;
    }

    public Window getParent() {
        return this.parent;
    }

    public void setNode(DefaultKingdeeTreeNode myNode) {
        this.myNode = myNode;
    }

    protected DefaultKingdeeTreeNode getNode() {
        return this.myNode;
    }

    protected ArrayList getSiblings() {
        ArrayList<Object> siblings = new ArrayList<Object>();
        if (this.myNode != null) {
            Enumeration<? extends TreeNode> emSiblings = this.myNode.getParent().children();
            while (emSiblings.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)emSiblings.nextElement();
                if (node.equals(this.myNode)) continue;
                siblings.add(node.getUserObject());
            }
        }
        return siblings;
    }

    public void setParent(KDFrame parent) {
        this.parent = parent;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    public void setChecked(int nChecked) {
        this.nChecked = nChecked;
    }

    public int getChecked() {
        return this.nChecked;
    }

    public void setDbIndex(int index) {
        this.dbIndex = index;
    }

    @Override
    public int getDbIndex() {
        return this.dbIndex;
    }

    @Override
    public int getType() {
        return this.taskType;
    }

    @Override
    public int getDataErrHandleStrategy() {
        return this.dataErrHandleStrategy;
    }

    @Override
    public int getErrHandStrategy() {
        return this.taskErrHandleStrategy;
    }

    @Override
    public void setErrHandStrategy(int eht) {
        this.taskErrHandleStrategy = eht;
    }

    public void load(Element elmBase) throws Exception {
        if (elmBase.getAttribute("number") != null) {
            this.number = elmBase.getAttribute("number").getValue();
        }
        this.name = locale == null ? elmBase.getAttribute("name_l2").getValue() : (locale.toString().equals("l1") ? elmBase.getAttribute("name_l1").getValue() : (locale.toString().equals("l2") ? elmBase.getAttribute("name_l2").getValue() : (locale.toString().equals("l3") ? elmBase.getAttribute("name_l3").getValue() : elmBase.getAttribute("name_l2").getValue())));
        String tmp = elmBase.getAttribute("name_l2").getValue();
        this.nameMap.put("name_l2", tmp);
        tmp = elmBase.getAttribute("name_l3").getValue();
        this.nameMap.put("name_l3", tmp);
        this.nChecked = elmBase.getAttribute("status").getIntValue();
        this.taskErrHandleStrategy = elmBase.getAttribute("taskErrHandleType").getIntValue();
        this.dataErrHandleStrategy = elmBase.getAttribute("dataErrHandleType").getIntValue();
        this.dbIndex = elmBase.getAttribute("dbIndex").getIntValue();
        if (elmBase.getAttribute("isServerRunning") != null) {
            this.isServerRunning = elmBase.getAttribute("isServerRunning").getBooleanValue();
        }
        if (elmBase.getAttribute("rollbackStrategy") != null) {
            this.rollbackStrategy = elmBase.getAttribute("rollbackStrategy").getIntValue();
        }
        if (elmBase.getAttribute("isOptimize") != null) {
            this.isOptimize = elmBase.getAttribute("isOptimize").getBooleanValue();
        }
    }

    public Element store() throws Exception {
        Element elmBase = new Element("Node");
        elmBase.setAttribute(new Attribute("number", this.number));
        if (locale == null) {
            elmBase.setAttribute(new Attribute("name_l2", this.name));
        } else if (locale.toString().equals("l1")) {
            elmBase.setAttribute(new Attribute("name_l1", this.name));
        } else if (locale.toString().equals("l2")) {
            elmBase.setAttribute(new Attribute("name_l2", this.name));
        } else if (locale.toString().equals("l3")) {
            elmBase.setAttribute(new Attribute("name_l3", this.name));
        } else {
            elmBase.setAttribute(new Attribute("name_l2", this.name));
        }
        elmBase.setAttribute(new Attribute("name_l2", (String)this.nameMap.get("name_l2") == null ? "" : (String)this.nameMap.get("name_l2")));
        elmBase.setAttribute(new Attribute("name_l3", (String)this.nameMap.get("name_l3") == null ? "" : (String)this.nameMap.get("name_l3")));
        elmBase.setAttribute(new Attribute("type", TaskType.getString(this.getType())));
        elmBase.setAttribute(new Attribute("status", String.valueOf(this.getChecked())));
        elmBase.setAttribute(new Attribute("dbIndex", String.valueOf(this.getDbIndex())));
        elmBase.setAttribute(new Attribute("taskErrHandleType", String.valueOf(this.getErrHandStrategy())));
        elmBase.setAttribute(new Attribute("dataErrHandleType", String.valueOf(this.dataErrHandleStrategy)));
        elmBase.setAttribute(new Attribute("rollbackStrategy", String.valueOf(this.rollbackStrategy)));
        elmBase.setAttribute("isServerRunning", String.valueOf(this.isServerRunning));
        elmBase.setAttribute("isOptimize", String.valueOf(this.isOptimize));
        return elmBase;
    }

    @Override
    public void run(ITaskRunnerAdapter runnerProxy) throws Exception {
        this.runner = runnerProxy;
        runnerProxy.run();
    }

    @Override
    public void setTaskParameter(ITaskParameter param) {
        this._param = param;
    }

    @Override
    public ITaskParameter getTaskParameter() {
        return this._param;
    }

    @Override
    public void setTaskParameterMap(Map<String, ITaskParameter> paramMap) {
        this.paramMap = paramMap;
    }

    @Override
    public Map<String, ITaskParameter> getTaskParameterMap() {
        return this.paramMap;
    }
}

