/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.export.ExternalCSVDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter2007;
import com.kingdee.eas.tools.datatask.export.ExternalTxtDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalXmlDataWriter;
import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskIERunner;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaskExportEASDataRunner
extends TaskIERunner {
    private static Logger logger = SysLog.getLogger(TaskExportEASDataRunner.class);
    private IRowSet rs = null;
    private int allRowCount = 0;
    private int currentRowCount = 0;
    private int fetchRowCount = 0;
    int maxQueryCount = 0;
    int maxExcelSheetRowCount2003 = 60000;
    int maxExcelSheetRowCount2007 = 100000;
    private IQueryExecutor exec = null;
    private int sheetIndex = 0;
    private IDataTransmission iDataTrans;
    private Context ctx;
    private IExternalDataWriter writer = null;
    private DatataskParameter dp = null;
    private boolean isCodeImplementTrans = true;
    private boolean isUserDefineTrans = false;
    private boolean isScriptTrans = false;
    private DefaultDataTransmission defaultTrans = null;
    private String fileName = "";

    public TaskExportEASDataRunner(ITask task) {
        super(task, null);
    }

    public TaskExportEASDataRunner(ITask task, Context ctx) {
        super(task, ctx);
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        super.onInitResources();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        this.dp = (DatataskParameter)taskCode.getTaskParameter();
        this.ctx = (Context)this.dp.getContextParam().get("context");
        String fileType = this.dp.getFileType();
        if ("xls".equals(fileType)) {
            this.writer = new ExternalExcelDataWriter();
            this.writer.setLocacle(this.ctx.getLocale());
            ((ExternalExcelDataWriter)this.writer).setExportTemplate(false);
            ((ExternalExcelDataWriter)this.writer).setSheetName(this.dp.alias);
        } else if ("txt".equals(fileType)) {
            this.writer = new ExternalTxtDataWriter();
            this.writer.setLocacle(this.ctx.getLocale());
        } else if ("csv".equals(fileType)) {
            this.writer = new ExternalCSVDataWriter();
            this.writer.setLocacle(this.ctx.getLocale());
        } else if ("xml".equals(fileType)) {
            this.writer = new ExternalXmlDataWriter();
            this.writer.setLocacle(this.ctx.getLocale());
        } else if ("xlsx".equals(fileType)) {
            this.writer = new ExternalExcelDataWriter2007();
            this.writer.setLocacle(this.ctx.getLocale());
            ((ExternalExcelDataWriter2007)this.writer).setSheetName(this.dp.alias);
        } else {
            this.writer = new ExternalTxtDataWriter();
            this.writer.setLocacle(this.ctx.getLocale());
        }
        this.writer.setFileName(this.dp.getOpenFileName());
        this.fileName = this.writer.getFileName();
        this.writer.openWriter();
        this.writer.writeStruct(taskCode.getExternalStructInfo());
        if (this.dp.getContextParam().get("exportTemplateOnly") != null) {
            this.continueCondition = false;
            return;
        }
    }

    @Override
    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        super.onBeforeEachRunningLoop();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        this.isCodeImplementTrans = TaskUtil.isCodeImplementTrans(taskCode);
        this.isUserDefineTrans = TaskUtil.isUserDefineTrans(taskCode);
        this.isScriptTrans = TaskUtil.isScriptTrans(taskCode);
        this.defaultTrans = new DefaultDataTransmission(this.ctx);
        this.defaultTrans.setDIETemplateInfo(taskCode.getDIETemplateInfo());
        this.defaultTrans.setContext(this.ctx);
        this.iDataTrans = this.createDataTransmissionObject();
        IMetaDataPK mainQueryPK = this.getQueryMetaDataPK();
        EntityViewInfo mainQuery = this.getMainQuery();
        try {
            this.exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQueryPK);
            this.exec.setObjectView(mainQuery);
            this.allRowCount = this.exec.getRowCount();
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            this.maxQueryCount = manager.getCriticalIDList();
            if (this.maxQueryCount == 0) {
                this.maxQueryCount = 10000;
            }
            this.rs = this.exec.executeQuery(0, this.maxQueryCount);
            this.fetchRowCount = this.rs.size();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("getexportdatafail", this.locale), e);
        }
    }

    private IMetaDataPK getQueryMetaDataPK() throws TaskRunnerException {
        IMetaDataPK mainQueryPK = null;
        if (this.isExportFromListUI()) {
            mainQueryPK = (IMetaDataPK)this.dp.getContextParam().get("mainQueryPK");
            if (mainQueryPK == null) {
                return this.getCodeMetaDataPK();
            }
            return mainQueryPK;
        }
        return this.getCodeMetaDataPK();
    }

    private IMetaDataPK getCodeMetaDataPK() throws TaskRunnerException {
        MetaDataPK mainQueryPK = null;
        String fullName = null;
        if (this.isCodeImplementTrans) {
            fullName = this.iDataTrans.getExportQueryInfo(this.ctx);
        } else if (this.isUserDefineTrans) {
            fullName = this.defaultTrans.getExportQueryInfo(this.ctx);
        }
        if (fullName == null) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("exportnotimplement", this.locale));
        }
        QueryInfo queryInfo = TaskExportEASDataRunner.getQueryInfo(this.ctx, fullName);
        if (queryInfo == null) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("exportnotimplement", this.locale));
        }
        mainQueryPK = new MetaDataPK(fullName);
        return mainQueryPK;
    }

    private EntityViewInfo getMainQuery() throws TaskRunnerException {
        EntityViewInfo mainQuery = null;
        if (this.isExportFromListUI()) {
            mainQuery = (EntityViewInfo)this.dp.getContextParam().get("mainQuery");
            if (mainQuery == null) {
                FilterInfo filterInfo = null;
                if (this.isCodeImplementTrans) {
                    filterInfo = this.iDataTrans.getExportFilterForQuery(this.ctx);
                } else if (this.isUserDefineTrans) {
                    filterInfo = this.defaultTrans.getExportFilterForQuery(this.ctx);
                }
                EntityViewInfo commonFilter = new EntityViewInfo();
                mainQuery = this.getEntityViewInfo(filterInfo, commonFilter);
            }
        } else {
            String queryName;
            QueryInfo queryInfo;
            ArrayList entityNames;
            FilterInfo filterInfo = null;
            if (this.isCodeImplementTrans) {
                filterInfo = this.iDataTrans.getExportFilterForQuery(this.ctx);
            } else if (this.isUserDefineTrans && (entityNames = TaskExportEASDataRunner.getEntitiyNames(queryInfo = TaskExportEASDataRunner.getQueryInfo(this.ctx, queryName = this.defaultTrans.getDIETemplateInfo().getQueryName()))).size() > 0) {
                String name = (String)entityNames.get(0);
                EntityObjectInfo entityObjectInfo = TaskExportEASDataRunner.getEntity(this.ctx, name);
                PropertyCollection coll = TaskExportEASDataRunner.getAllEntityProperties(entityObjectInfo);
                for (int j = 0; j < coll.size(); ++j) {
                    String proName;
                    PropertyInfo info = coll.get(j);
                    if (!TaskExportEASDataRunner.isValidProp(info) || !(proName = info.getName()).equalsIgnoreCase("CU")) continue;
                    filterInfo = this.defaultTrans.getExportFilterForQuery(this.ctx);
                    break;
                }
            }
            EntityViewInfo commonFilter = null;
            commonFilter = this.dp.getContextParam().get("commonFilter") instanceof EntityViewInfo ? (EntityViewInfo)this.dp.getContextParam().get("commonFilter") : new EntityViewInfo();
            mainQuery = this.getEntityViewInfo(filterInfo, commonFilter);
        }
        return mainQuery;
    }

    private boolean isExportFromListUI() {
        return this.dp.getContextParam().get("exportFrom") == null;
    }

    private void checkRsSize() throws TaskRunnerException {
        if (this.rs != null && this.rs.size() > 60000) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exportrecordtoolarge", new Object[]{60000}));
        }
    }

    protected final EntityViewInfo getEntityViewInfo(FilterInfo filterCU, EntityViewInfo QueryFilter) throws TaskRunnerException {
        if (filterCU != null && filterCU.size() > 0) {
            if (QueryFilter.getFilter() != null && QueryFilter.getFilter().size() > 0 && !QueryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = QueryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    try {
                        QueryFilter.getFilter().mergeFilter(filterCU, "AND");
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                        throw new TaskRunnerException(EASResourceJoinUtil.getServerString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "61_TaskExportEASDataRunner", this.locale));
                    }
                }
            } else {
                QueryFilter.setFilter(filterCU);
            }
        }
        return QueryFilter;
    }

    private IDataTransmission createDataTransmissionObject() throws TaskRunnerException {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        if (taskCode.getDataTransmissionClassName() == null || taskCode.getDataTransmissionClassName().equals("")) {
            return null;
        }
        IDataTransmission iObject = null;
        try {
            Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
            iObject = (IDataTransmission)classDefinition.newInstance();
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            iObject.setContextParameter(contextParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
            String detail = EASResourceJoinUtil.getServerString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "62_TaskExportEASDataRunner", new Object[]{taskCode.getDataTransmissionClassName()}, this.locale);
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, e);
        }
        return iObject;
    }

    @Override
    protected boolean hasMoreRecord() throws TaskRunnerException {
        boolean rtn = false;
        try {
            if (this.currentRowCount >= this.fetchRowCount && this.currentRowCount < this.allRowCount) {
                this.rs = this.exec.executeQuery(this.currentRowCount, this.maxQueryCount);
                this.fetchRowCount += this.rs.size();
            }
            rtn = this.rs.next();
            ++this.currentRowCount;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        return rtn;
    }

    @Override
    protected void onEachRunningLoop() throws Exception {
        Map data = null;
        if (this.isCodeImplementTrans) {
            data = this.iDataTrans.exportTransmit(this.rs, this.ctx);
        }
        if (this.isUserDefineTrans) {
            Map userMap = this.defaultTrans.exportTransmit(this.rs, this.ctx);
            if (data != null) {
                data.putAll(userMap);
            } else {
                data = userMap;
            }
        }
        if (this.isHasData(data)) {
            TaskExternalCode taskCode;
            String fileType = this.dp.getFileType();
            if ("xls".equals(fileType) && (this.currentRowCount + 1) % this.maxExcelSheetRowCount2003 == 0) {
                ((ExternalExcelDataWriter)this.writer).setSheetName(this.dp.alias + ++this.sheetIndex);
                ((ExternalExcelDataWriter)this.writer).openWriter();
                taskCode = (TaskExternalCode)this.task;
                this.writer.writeStruct(taskCode.getExternalStructInfo());
            }
            if ("xlsx".equals(fileType) && (this.currentRowCount + 1) % this.maxExcelSheetRowCount2007 == 0) {
                ((ExternalExcelDataWriter2007)this.writer).setSheetName(this.dp.alias + ++this.sheetIndex);
                ((ExternalExcelDataWriter2007)this.writer).openWriter();
                taskCode = (TaskExternalCode)this.task;
                this.writer.writeStruct(taskCode.getExternalStructInfo());
            }
            this.writer.writeLine(data);
            ++this.nSuccessCount;
        }
    }

    private boolean isHasData(Map data) {
        if (data == null || data.size() <= 0) {
            return false;
        }
        Set sets = data.keySet();
        Iterator it = sets.iterator();
        int blankDataCount = 0;
        while (it.hasNext()) {
            Object oneData = data.get(it.next());
            if (oneData != null && !oneData.equals("")) {
                return true;
            }
            ++blankDataCount;
        }
        return blankDataCount != data.size();
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
        if (this.writer != null) {
            this.writer.closeWriter();
            this.writer = null;
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.rs = null;
        }
    }

    @Override
    protected String getMsgOnDataErr() {
        return EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exportno", this.locale) + this.nCurCount + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "lineData", this.locale);
    }

    public static QueryInfo getQueryInfo(Context ctx, String queryName) {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getQuery((IMetaDataPK)queryPK);
    }

    protected static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (subObjectInfo instanceof SubEntityInfo) {
                SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
                String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
                entityNames.add(entityName);
                continue;
            }
            if (!(subObjectInfo instanceof SubQueryInfo)) continue;
            QueryInfo subQueryInfo = ((SubQueryInfo)subObjectInfo).getQueryRef();
            entityNames.addAll(TaskExportEASDataRunner.getEntitiyNames(subQueryInfo));
        }
        return entityNames;
    }

    public static EntityObjectInfo getEntity(Context ctx, String entityName) {
        MetaDataPK entityPK = new MetaDataPK(entityName);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity((IMetaDataPK)entityPK);
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    private static boolean isValidProp(PropertyInfo info) {
        return info instanceof LinkPropertyInfo;
    }

    public String getFileName() {
        return this.fileName;
    }
}

