/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskAbstractRunnerAdapter;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import org.apache.log4j.Logger;

public abstract class TaskRecordRunnerAdapter
extends TaskAbstractRunnerAdapter {
    protected boolean continueCondition = false;
    protected int nCurCount;
    protected int nSuccessCount;
    protected int nFailCount;
    protected int nBlankCount;
    private static Logger logger = SysLog.getLogger(TaskRecordRunnerAdapter.class);
    private static final int maxFailCount = 100;
    protected boolean stopOnDataErr = false;

    public TaskRecordRunnerAdapter(ITask task) {
        this(task, null);
    }

    public TaskRecordRunnerAdapter(ITask task, Context ctx) {
        super(task, ctx);
        this.task = task;
        this.tl.setLogUuID(task.getTaskUuID());
        this.nCurCount = 0;
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        this.tl.setLogUuID(this.task.getTaskUuID());
        this.tl.setTaskState(TaskStateEnum.INITTASK);
        TaskLogUtil.putLog(this.tl);
        this.continueCondition = true;
    }

    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        if (this.needInitCountFlag) {
            this.nCurCount = 0;
            this.nFailCount = 0;
            this.nSuccessCount = 0;
        } else if (this.tl != null) {
            this.nFailCount = this.tl.getFailRecordCount();
            this.nSuccessCount = this.tl.getSuccessRecordCount();
        }
    }

    protected abstract boolean hasMoreRecord() throws TaskRunnerException;

    @Override
    protected void onMainRunningProcess() throws TaskRunnerException {
        try {
            if (this.continueCondition) {
                this.onBeforeEachRunningLoop();
            }
        }
        catch (TaskRunnerException ex) {
            logger.error((Object)this.emptyIfNull(ex.getMessage()), (Throwable)((Object)ex));
            this.onDataError((Throwable)((Object)ex));
        }
        this.onRecordProcess();
    }

    protected void onRecordProcess() throws TaskRunnerException {
        while (this.hasMoreRecord() && this.continueCondition) {
            ++this.nCurCount;
            try {
                this.onEachRunningLoop();
                if (this.nSuccessCount % 100 != 0) continue;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Throwable ex) {
                logger.error((Object)this.emptyIfNull(ex.getMessage()), ex);
                ++this.nFailCount;
                this.onDataError(ex);
            }
        }
        if (this.nSuccessCount % 100 != 0) {
            this.tl.setSuccessRecordCount(this.nSuccessCount);
        }
        if (this.nFailCount <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog(this.tl);
    }

    protected String emptyIfNull(String message) {
        if (message == null) {
            return "";
        }
        return message;
    }

    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)((Object)ex)).getExceptionCode() == 4) {
            throw (TaskRunnerException)((Object)ex);
        }
        String errMsg = this.getMsgOnDataErr();
        if (this.nFailCount > 100) {
            ex = new TaskRunnerException(ex.getMessage());
        }
        this.tl.addException(errMsg, (Throwable)ex, this.nCurCount);
        this.tl.setFailRecordCount(this.nFailCount);
        TaskLogUtil.putLog(this.tl);
        this.dataErrorHandle((Throwable)ex);
    }

    protected void dataErrorHandle(Throwable ex) throws TaskRunnerException {
        if (this.task.getDataErrHandleStrategy() == 4) {
            this.onDataErrorSkip(ex);
        } else if (this.task.getDataErrHandleStrategy() == 5) {
            this.onDataErrorStop(ex);
        }
    }

    protected String getMsgOnDataErr() {
        return EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "importNo", this.locale) + this.nCurCount + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "lineData", this.locale);
    }

    @Override
    public void callRollbackProcess() throws Exception {
    }

    protected void onDataErrorStop(Throwable ex) {
        this.continueCondition = false;
        this.stopOnDataErr = true;
    }

    protected void onDataErrorSkip(Throwable ex) {
        this.continueCondition = true;
        this.stopOnDataErr = false;
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
    }

    protected abstract void onEachRunningLoop() throws Exception;
}

