/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.TemplateFolderInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataMeta;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;

public class TaskTemplateAdapter {
    public static TaskExternalCode getTaskExternalCode(DIETemplateInfo info, Locale locale) {
        TaskExternalCode task = new TaskExternalCode(null);
        task.setNumber(info.getNumber());
        task.setName(info.getName());
        task.setImportPermItemName(info.getImportPermName());
        task.setExportPermItemName(info.getExportPermName());
        task.setDataTransmissionClassName(info.getImplementClassName());
        task.setHintInTool(info.isIsHintInTool());
        ExternalStructInfo structInfo = new ExternalStructInfo();
        structInfo.setLocale(locale);
        structInfo.setObjectDesc(info.getName());
        structInfo.setObjectName(info.getNumber());
        structInfo.setProductName(ExternalDataMeta.productName);
        structInfo.setVersion(ExternalDataMeta.productVersion);
        structInfo.setComment(info.getDescription());
        structInfo.setSheetName(info.getSheetName());
        DIETemplateFieldEntryCollection coll = info.getFieldEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo tmpInfo = TaskTemplateAdapter.toFiledProperty(coll.get(i));
            structInfo.addField(tmpInfo);
        }
        task.setExternalStructInfo(structInfo);
        task.setDIETemplateInfo(info);
        return task;
    }

    public static TaskExternalCode getTaskExternalCode(String solutionName, Context ctx) throws BOSException {
        Locale locale = ctx.getLocale();
        IDIETemplate dt = DIETemplateFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (solutionName.indexOf(".") > -1) {
            String[] tmp = solutionName.split("\\.");
            solutionName = tmp[tmp.length - 1];
        }
        FilterItemInfo itemInfo = new FilterItemInfo("number", (Object)solutionName);
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().getFilterItems().add(itemInfo);
        DIETemplateInfo templateInfo = dt.getDIETemplateCollection(viewInfo).get(0);
        if (templateInfo == null) {
            String resClassName = "com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource";
            throw new BOSException(ResourceBase.getString((String)resClassName, (String)"2_DatataskRunServerControllerBean", (Locale)locale) + solutionName + ResourceBase.getString((String)resClassName, (String)"3_DatataskRunServerControllerBean", (Locale)locale));
        }
        return TaskTemplateAdapter.getTaskExternalCode(templateInfo, locale);
    }

    public static Map<String, ExternalStructInfo> getStructMap(List<String> solus, Context ctx) throws BOSException {
        IDIETemplate dt = DIETemplateFactory.getLocalInstance(ctx);
        StringBuilder sb = new StringBuilder();
        for (String solu : solus) {
            sb.append(",'").append(solu).append("'");
        }
        String numbers = sb.substring(1);
        DIETemplateCollection coll = dt.getDIETemplateCollection(" where number in(" + numbers + ")");
        HashMap<String, ExternalStructInfo> smap = new HashMap<String, ExternalStructInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            ExternalStructInfo struct = TaskTemplateAdapter.getStruct(coll.get(i));
            struct.setLocale(ctx.getOriginLocale());
            smap.put(struct.getObjectName(), struct);
        }
        return smap;
    }

    public static ExternalStructInfo getStruct(DIETemplateInfo info) {
        ExternalStructInfo structInfo = new ExternalStructInfo();
        structInfo.setObjectDesc(info.getName());
        structInfo.setObjectName(info.getNumber());
        structInfo.setProductName(ExternalDataMeta.productName);
        structInfo.setVersion(ExternalDataMeta.productVersion);
        structInfo.setComment(info.getDescription());
        structInfo.setSheetName(info.getSheetName());
        DIETemplateFieldEntryCollection coll = info.getFieldEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo tmpInfo = TaskTemplateAdapter.toFiledProperty(coll.get(i));
            structInfo.addField(tmpInfo);
        }
        return structInfo;
    }

    public static DIETemplateInfo getDIETemplateInfo(TaskExternalCode task) {
        DIETemplateInfo info = new DIETemplateInfo();
        info.setNumber(task.getNumber());
        info.setName(task.getName());
        info.setImplementClassName(task.getDataTransmissionClassName());
        info.setImportPermName(task.getImportPermItemName());
        info.setExportPermName(task.getExportPermItemName());
        info.setIsHintInTool(task.isHintInTool());
        ExternalStructInfo structInfo = task.getExternalStructInfo();
        info.setSheetName(structInfo.getSheetName());
        ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
        if (fields != null) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                DIETemplateFieldEntryInfo tmp = TaskTemplateAdapter.toEntryInfo((FieldPropertyInfo)fields.get(i));
                info.getFieldEntries().add(tmp);
            }
        }
        DatataskParameter dp = (DatataskParameter)task.getTaskParameter();
        TemplateFolderInfo tfInfo = (TemplateFolderInfo)dp.getContextParam().get("folderInfo");
        info.setParentFolder(tfInfo);
        info.put("parent", tfInfo);
        info.setLongNumber(tfInfo.getLongNumber() + "!" + info.getNumber());
        info.setLevel((short)(tfInfo.getLevel() + 1));
        return info;
    }

    private static DIETemplateFieldEntryInfo toEntryInfo(FieldPropertyInfo fieldInfo) {
        DIETemplateFieldEntryInfo entryInfo = new DIETemplateFieldEntryInfo();
        entryInfo.setNumber(fieldInfo.getFieldName());
        entryInfo.setName(fieldInfo.getFieldDesc());
        entryInfo.setIsNeed(fieldInfo.getIsNecessary());
        entryInfo.setIsPrimary(false);
        return entryInfo;
    }

    private static FieldPropertyInfo toFiledProperty(DIETemplateFieldEntryInfo entryInfo) {
        FieldPropertyInfo info = new FieldPropertyInfo();
        info.setFieldColNumber(entryInfo.getSeq());
        info.setFieldName(entryInfo.getNumber());
        info.setFieldDesc(entryInfo.getName());
        info.setIsNecessary(entryInfo.isIsNeed());
        info.setFieldType(CellType.STRING);
        info.setFiledMemo(entryInfo.getMemo());
        info.setEntryInfo(entryInfo);
        return info;
    }

    public static TaskExternalCode getTaskExternalCode(String solutionName, Locale locale) throws BOSException {
        IDIETemplate dt = DIETemplateFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (solutionName.indexOf(".") > -1) {
            String[] tmp = solutionName.split("\\.");
            solutionName = tmp[tmp.length - 1];
        }
        FilterItemInfo itemInfo = new FilterItemInfo("number", (Object)solutionName);
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().getFilterItems().add(itemInfo);
        DIETemplateInfo templateInfo = dt.getDIETemplateCollection(viewInfo).get(0);
        if (templateInfo == null) {
            String resClassName = "com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource";
            throw new BOSException(ResourceBase.getString((String)resClassName, (String)"2_DatataskRunServerControllerBean", (Locale)locale) + solutionName + ResourceBase.getString((String)resClassName, (String)"3_DatataskRunServerControllerBean", (Locale)locale));
        }
        return TaskTemplateAdapter.getTaskExternalCode(templateInfo, locale);
    }
}

