/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task.util;

import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class EnhancedXMLStreamWriter
implements XMLStreamWriter {
    private XMLStreamWriter delegate;
    private Stack<String> xpathNodes = new Stack();
    private int indent = 0;
    private Stack<Boolean> hasSubElements = new Stack();

    public EnhancedXMLStreamWriter(XMLStreamWriter delegate) {
        this.delegate = delegate;
    }

    private void beforeStartElement(String localName) throws XMLStreamException {
        if (!this.hasSubElements.isEmpty()) {
            this.hasSubElements.pop();
            this.hasSubElements.push(Boolean.TRUE);
        }
        this.hasSubElements.push(Boolean.FALSE);
        this.delegate.writeCharacters("\n");
        this.printIndents();
        ++this.indent;
        this.xpathNodes.push(localName);
    }

    private void beforeEndElement() throws XMLStreamException {
        --this.indent;
        if (!this.hasSubElements.isEmpty() && this.hasSubElements.pop().booleanValue()) {
            this.delegate.writeCharacters("\n");
            this.printIndents();
        }
    }

    private void printIndents() throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("    ");
        }
        this.delegate.writeCharacters(sb.toString());
    }

    private void afterEndElement() {
        this.xpathNodes.pop();
    }

    public String[] getXpathNodes() {
        return this.xpathNodes.toArray(new String[this.xpathNodes.size()]);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.beforeStartElement(localName);
        this.delegate.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.beforeStartElement(localName);
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.beforeStartElement(localName);
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.beforeStartElement(localName);
        this.delegate.writeEmptyElement(namespaceURI, localName);
        this.beforeEndElement();
        this.afterEndElement();
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.beforeStartElement(localName);
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
        this.beforeEndElement();
        this.afterEndElement();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.beforeStartElement(localName);
        this.delegate.writeEmptyElement(localName);
        this.beforeEndElement();
        this.afterEndElement();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.beforeEndElement();
        this.delegate.writeEndElement();
        this.afterEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.delegate.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }
}

