/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class XMLElementAssembeler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tools.datatask.task.util.XMLElementAssembeler");
    protected Connection conn;
    protected Statement statement;
    protected ResultSet rowset;
    private Object[] objectList;
    protected Element root;
    protected Context ctx;
    protected CompanyOrgUnitInfo companyInfo;
    protected PeriodInfo periodinfo;
    protected List<PeriodInfo> periods = new ArrayList<PeriodInfo>();

    public abstract String prePareSQL();

    public abstract void addToElement() throws SQLException;

    protected void setObjectList(Object[] objectList) {
        this.objectList = objectList;
    }

    public XMLElementAssembeler(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        this.root = root;
        this.ctx = ctx;
        this.companyInfo = companyInfo;
        this.periodinfo = periodinfo;
        this.periods.add(periodinfo);
    }

    public XMLElementAssembeler(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periods) {
        this.root = root;
        this.ctx = ctx;
        this.companyInfo = companyInfo;
        this.periods.addAll(periods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excuteAssemble() {
        try {
            String sql = this.prePareSQL();
            if (sql != null) {
                this.conn = EJBFactory.getConnection((Context)this.ctx);
                if (this.objectList == null) {
                    this.statement = this.conn.createStatement();
                    this.rowset = this.statement.executeQuery(sql);
                } else {
                    PreparedStatement preparedStatement = this.conn.prepareStatement(sql);
                    this.statement = preparedStatement;
                    for (int i = 0; i < this.objectList.length; ++i) {
                        preparedStatement.setObject(i + 1, this.objectList[i]);
                    }
                    this.rowset = preparedStatement.executeQuery();
                }
            }
            this.addToElement();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    public void close() {
        XMLElementAssembeler.closeJdbcResource(this.rowset);
        XMLElementAssembeler.closeJdbcResource(this.statement);
        XMLElementAssembeler.closeJdbcResource(this.conn);
    }

    private static void closeJdbcResource(Object jdbcResourceObj) {
        if (jdbcResourceObj == null) {
            return;
        }
        if (jdbcResourceObj instanceof Connection) {
            try {
                Connection conn = (Connection)jdbcResourceObj;
                conn.close();
            }
            catch (SQLException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else if (jdbcResourceObj instanceof Statement) {
            try {
                Statement statement = (Statement)jdbcResourceObj;
                statement.close();
            }
            catch (SQLException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else if (jdbcResourceObj instanceof ResultSet) {
            try {
                ResultSet rs = (ResultSet)jdbcResourceObj;
                rs.close();
            }
            catch (SQLException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

