/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tools.datatask.task.util.DummyElement;
import com.kingdee.eas.tools.datatask.task.util.EnhancedXMLStreamWriter;
import com.kingdee.eas.tools.datatask.task.util.XMLStreamWriterDelegate;
import com.kingdee.eas.util.client.EASResource;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class XMLGenerator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tools.datatask.task.util.XMLGenerator");
    private final String XMLNS = "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema";
    private final String INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private final int BUFFER_SIZE = 524288;
    private XMLStreamWriterDelegate xmlWriter;
    private Stack<Element> elements = new Stack();
    protected File file;
    protected String fileName = "";
    protected BufferedWriter bufferedWriter;
    private List exceptionList = new ArrayList();

    public XMLGenerator() {
        try {
            this.file = File.createTempFile("generatedXml", ".xml");
            this.file.deleteOnExit();
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "GB18030"), 524288);
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(this.bufferedWriter);
            xmlStreamWriter = new EnhancedXMLStreamWriter(xmlStreamWriter);
            this.xmlWriter = new XMLStreamWriterDelegate(xmlStreamWriter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract File generate(Context var1, CompanyOrgUnitInfo var2, PeriodInfo var3);

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodInfo) {
        return this.file;
    }

    public Document generateXML(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodInfo) {
        return null;
    }

    public void addException(Exception e) {
        this.exceptionList.add(e);
    }

    public List getException() {
        return this.exceptionList;
    }

    protected Element initHeadAndFileName(Context ctx, CompanyOrgUnitInfo companyInfo, String type) {
        this.xmlWriter.writeStartDocument("GB18030", "1.0");
        this.xmlWriter.writeStartElement(type);
        this.xmlWriter.writeNamespace("xmlns", "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema");
        this.xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xmlWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema " + type + ".xsd");
        this.xmlWriter.writeAttribute(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"150_XMLGenerator"), "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema");
        DummyElement element = new DummyElement(type);
        this.elements.push(element);
        return element;
    }

    private String getBlankByLength(int length) {
        StringBuffer str = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            str.append(" ");
        }
        return str.toString();
    }

    protected Element startElement(String localName) {
        DummyElement element = new DummyElement(localName);
        this.xmlWriter.writeStartElement(localName);
        this.elements.push(element);
        return element;
    }

    protected void endElement() {
        this.xmlWriter.writeEndElement();
        this.elements.pop();
    }

    protected void addDateElement(Element root, String pName, Date value) {
        if (value == null) {
            this.addStringElement(root, pName, null, 8, true);
        } else {
            String date = new SimpleDateFormat("yyyyMMdd").format(value);
            this.addStringElement(root, pName, date, 8, true);
        }
    }

    protected void addNumberElement(Element root, String pName, String value) {
        if (root != this.elements.peek()) {
            throw new IllegalArgumentException("Reordering writing was not supported!");
        }
        this.addStringElement(root, pName, value == null ? "0" : value, Integer.MAX_VALUE, false);
    }

    protected void addStringElement(Element root, String pName, String value) {
        this.addStringElement(root, pName, value, Integer.MAX_VALUE, false);
    }

    protected void addStringElement(Element root, String pName, String value, int max, boolean fixedlength) {
        if (root != this.elements.peek()) {
            throw new IllegalArgumentException("Reordering writing was not supported!");
        }
        if (!fixedlength) {
            if (value == null) {
                this.xmlWriter.writeEmptyElement(pName);
                return;
            }
            value = value.trim();
        } else {
            if (value == null) {
                value = this.getBlankByLength(max);
            }
            if (value.length() < max) {
                value = value + this.getBlankByLength(max - value.length());
            }
        }
        if (value.length() > max) {
            value = value.substring(0, max);
        }
        this.xmlWriter.writeStartElement(pName);
        this.xmlWriter.writeCharacters(value);
        this.xmlWriter.writeEndElement();
    }

    public CtrlUnitInfo getCtrlUnit(CompanyOrgUnitInfo companyInfo, Context ctx) {
        if (companyInfo.getCU() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getCU().getId());
            try {
                return CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected void close() {
        if (this.xmlWriter != null) {
            this.xmlWriter.close();
        }
        this.closeIfNotNull(this.bufferedWriter);
    }

    private void closeIfNotNull(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

