/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.util;

import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.ZipUtil;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;

public class ZipUtilForServer {
    private static Logger logger = Logger.getLogger(ZipUtil.class);
    private static String filePath = GlobalFunction.getFilePathForServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFiles2Zip(Map<String, String> fileMap, String zipFilePath) {
        if (fileMap != null && fileMap.size() > 0) {
            ZipArchiveOutputStream zaos = null;
            try {
                File zipFile = new File(zipFilePath);
                zaos = new ZipArchiveOutputStream(zipFile);
                zaos.setUseZip64(Zip64Mode.AsNeeded);
                zaos.setEncoding("GBK");
                zaos.setFallbackToUTF8(true);
                for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                    String realName = entry.getKey();
                    String alias = entry.getValue();
                    File file = new File(filePath + realName);
                    ZipUtilForServer.zipArchiveEntry(file, alias, zaos);
                }
                zaos.finish();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (zaos != null) {
                        zaos.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void zipArchiveEntry(File file, String fileName, ZipArchiveOutputStream zaos) {
        if (file != null) {
            if (StringUtils.isEmpty((String)fileName)) {
                fileName = file.getName();
            }
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(file, fileName);
            InputStream is = null;
            try {
                zaos.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                is = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[5120];
                int len = -1;
                while ((len = is.read(buffer)) != -1) {
                    zaos.write(buffer, 0, len);
                }
                zaos.closeArchiveEntry();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                file.delete();
            }
        }
    }

    public static void compressFiles2Zip(File[] files, String zipFilePath) {
        if (files != null && files.length > 0 && ZipUtilForServer.isEndsWithZip(zipFilePath)) {
            ZipArchiveOutputStream zaos = null;
            try {
                File zipFile = new File(zipFilePath);
                zaos = new ZipArchiveOutputStream(zipFile);
                zaos.setUseZip64(Zip64Mode.AsNeeded);
                zaos.setEncoding("GBK");
                zaos.setFallbackToUTF8(true);
                for (File file : files) {
                    ZipUtilForServer.zipArchiveEntry(file, "", zaos);
                }
                zaos.finish();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (zaos != null) {
                        zaos.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void decompressZip(String zipFilePath, String saveFileDir) {
        File file;
        if (ZipUtilForServer.isEndsWithZip(zipFilePath) && (file = new File(zipFilePath)).exists()) {
            FileInputStream is = null;
            ZipArchiveInputStream zais = null;
            try {
                is = new FileInputStream(file);
                zais = new ZipArchiveInputStream((InputStream)is);
                ArchiveEntry archiveEntry = null;
                while ((archiveEntry = zais.getNextEntry()) != null) {
                    String entryFileName = archiveEntry.getName();
                    String entryFilePath = saveFileDir + entryFileName;
                    byte[] content = new byte[(int)archiveEntry.getSize()];
                    zais.read(content);
                    OutputStream os = null;
                    FileOutputStream out = null;
                    try {
                        File entryFile = new File(entryFilePath);
                        out = new FileOutputStream(entryFile);
                        os = new BufferedOutputStream(out);
                        os.write(content);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    finally {
                        try {
                            if (os != null) {
                                os.flush();
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            if (out == null) continue;
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (zais != null) {
                        zais.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static boolean isEndsWithZip(String fileName) {
        return !StringUtils.isEmpty((String)fileName) && fileName.toLowerCase(Locale.ENGLISH).endsWith(".zip");
    }
}

