/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain;

import com.kingdee.eas.framework.ObjectBaseInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class StringUtil {
    public static boolean isNumber(String numStr) {
        if (numStr == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(numStr);
        }
        catch (NumberFormatException nex) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() <= 0;
    }

    public static String toString(BigDecimal dec) {
        Method method = null;
        Class<?> cls = dec.getClass();
        try {
            method = cls.getMethod("toPlainString", null);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)dec, null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return dec.toString();
    }

    public static String nameFromSplits(String[] splits, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(splits[i]);
        }
        return sb.toString();
    }

    public static String getKeyIdList(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(ids[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    public static String getKeyIdList(ObjectBaseInfo[] vos, String delim) {
        if (vos == null || vos.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vos.length; ++i) {
            if (vos[i] == null) continue;
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(vos[i].getId().toString());
        }
        return sb.toString();
    }

    public static String getKeyIdListWithOutQuotationMask(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(ids[i]);
        }
        return sb.toString();
    }

    public static LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public static LinkedHashSet getKeyIdList(String ids) {
        return StringUtil.getKeyIdList(ids, ";");
    }
}

