/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.ConfigItemStateEnum;
import com.kingdee.eas.dynbusiness.ConfigItemTypeEnum;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.adv.chain.BactchActionInfo;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainCollection;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainEntryCollection;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainEntryInfo;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainInfo;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorCollection;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorInfo;
import com.kingdee.eas.dynbusiness.adv.chain.ChainCommonFacadeFactory;
import com.kingdee.eas.dynbusiness.adv.chain.ServerUnitTypeEnum;
import com.kingdee.eas.dynbusiness.adv.chain.client.AbstractBusinessProcessChainEditUI;
import com.kingdee.eas.dynbusiness.adv.chain.client.FilterPanelUI;
import com.kingdee.eas.dynbusiness.adv.condition.ConditionData;
import com.kingdee.eas.dynbusiness.adv.condition.ConditionDatas;
import com.kingdee.eas.dynbusiness.adv.condition.ConditionItemData;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class BusinessProcessChainEditUI
extends AbstractBusinessProcessChainEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BusinessProcessChainEditUI.class);
    private KDTEditListener kdtListener = null;
    private String bosType = null;
    private String subSystem = null;
    private String systemName = null;
    private Map condMap = new Hashtable();
    private Map entryCondMap = new Hashtable();
    private JSONObject obj = new JSONObject();
    private String classParam = null;
    private String chainVerison = "0.0.0";
    private static String str = "com.kingdee.eas.dynbusiness.adv.chain.BusinessChainResource";

    public void onLoad() throws Exception {
        this.classParam = (String)this.getUIContext().get("UIClassParam");
        this.kdtEntry.checkParsed();
        this.initCombOp();
        super.onLoad();
        this.addListener();
        this.initPanel();
        this.initData();
    }

    public void loadFields() {
        this.sortProcessor();
        this.setDisplayConditionValue();
        super.loadFields();
        Set chainIDs = this.getIDByType(true);
        Set procorIDs = this.getIDByType(false);
        try {
            BusinessProcessChainCollection chainCon = this.getBizProcChain(chainIDs);
            BusinessProcessorCollection procCon = this.getBizProcor(procorIDs);
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                String id;
                ObjectBaseInfo info;
                int j;
                if (this.kdtEntry.getCell(i, "processor").getValue() == null) continue;
                String proceID = this.kdtEntry.getCell(i, "processor").getValue().toString();
                ServerUnitTypeEnum type = (ServerUnitTypeEnum)((Object)this.kdtEntry.getCell(i, "type").getValue());
                if (type.equals((Object)ServerUnitTypeEnum.BIZCHAIN)) {
                    if (chainCon == null) continue;
                    for (j = 0; j < chainCon.size(); ++j) {
                        info = chainCon.get(j);
                        id = info.getId().toString();
                        if (!id.equals(proceID)) continue;
                        this.kdtEntry.getCell(i, "processorNum").setValue((Object)info);
                        this.kdtEntry.getCell(i, "processorName").setValue((Object)info.getName());
                    }
                    continue;
                }
                if (procCon == null) continue;
                for (j = 0; j < procCon.size(); ++j) {
                    info = procCon.get(j);
                    id = info.getId().toString();
                    if (!id.equals(proceID)) continue;
                    this.kdtEntry.getCell(i, "processorNum").setValue((Object)info);
                    this.kdtEntry.getCell(i, "processorName").setValue((Object)info.getName());
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.setBillType();
    }

    private void sortProcessor() {
        int i;
        BusinessProcessChainEntryCollection entryCol = this.editData.getEntry();
        ArrayList<BusinessProcessChainEntryInfo> sortEntryCol = new ArrayList<BusinessProcessChainEntryInfo>();
        int size = entryCol.size();
        for (i = 0; i < size; ++i) {
            sortEntryCol.add(entryCol.get(i));
        }
        Collections.sort(sortEntryCol, new Comparator<BusinessProcessChainEntryInfo>(){

            @Override
            public int compare(BusinessProcessChainEntryInfo o1, BusinessProcessChainEntryInfo o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.getSeq() - o2.getSeq();
            }
        });
        this.editData.getEntry().clear();
        size = sortEntryCol.size();
        for (i = 0; i < size; ++i) {
            this.editData.getEntry().add((BusinessProcessChainEntryInfo)sortEntryCol.get(i));
        }
    }

    protected IObjectValue createNewData() {
        BusinessProcessChainInfo bccinfo = new BusinessProcessChainInfo();
        bccinfo.setType(ConfigItemTypeEnum.STANDARD);
        BusinessProcessChainEntryInfo entry = new BusinessProcessChainEntryInfo();
        entry.setType(ServerUnitTypeEnum.BIZUNIT);
        entry.setSeq(1);
        entry.setId(BOSUuid.create((String)"046901EC"));
        entry.setTransactionModeEnum(TransactionModeEnum.INHERITED);
        entry.setIsKey(true);
        entry.setIsActive(true);
        entry.setExecMode(ProcessorExecutionModeEnum.MAIN);
        entry.setLevel(this.getLevel());
        bccinfo.getEntry().add(entry);
        bccinfo.setState(ConfigItemStateEnum.OPEN);
        if (this.combOp.getItemCount() > 0) {
            BactchActionInfo action = (BactchActionInfo)this.combOp.getItemAt(0);
            bccinfo.setAction(action.getFBizAction());
        }
        return bccinfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BusinessProcessChainFactory.getRemoteInstance();
    }

    public void actionRuleDown_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        int toRowIndex = rowIndex + 1;
        this.kdtEntry.moveRow(rowIndex, toRowIndex);
        this.kdtEntry.getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    public void actionRuleUp_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.kdtEntry.moveRow(rowIndex, toRowIndex);
        this.kdtEntry.getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    public void actionRuleAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kdtEntry.addRow();
        BusinessProcessChainEntryInfo entry = new BusinessProcessChainEntryInfo();
        entry.setType(ServerUnitTypeEnum.BIZUNIT);
        entry.setExecMode(ProcessorExecutionModeEnum.ORDINAL);
        entry.setTransactionModeEnum(TransactionModeEnum.INHERITED);
        entry.setLevel(this.getLevel());
        entry.setIsActive(true);
        entry.setIsKey(true);
        entry.setId(BOSUuid.create((String)"046901EC"));
        this.loadLineFields(row, (IObjectValue)entry);
        this.setSeq();
    }

    public void actionRuleDelLine_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        String entryID = this.kdtEntry.getCell(rowIndex, "id").getValue().toString();
        this.beforeChengeChainEntry(entryID);
        this.kdtEntry.removeRow(rowIndex);
        this.setSeq();
    }

    public void actionRuleInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int currentRowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        IRow row = this.kdtEntry.addRow(currentRowIndex + 1);
        BusinessProcessChainEntryInfo entry = new BusinessProcessChainEntryInfo();
        entry.setType(ServerUnitTypeEnum.BIZUNIT);
        entry.setExecMode(ProcessorExecutionModeEnum.MAIN);
        this.loadLineFields(row, (IObjectValue)entry);
        this.setSeq();
    }

    private void initPanel() {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        KDCheckBox chk = new KDCheckBox();
        this.kdtEntry.getColumn("isActive").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chk));
        this.kdtEntry.getColumn("isInvokeBeanExt").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chk));
        this.kdtEntry.getColumn("isKey").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chk));
        KDComboBox comb = new KDComboBox();
        comb.addItems(ServerUnitTypeEnum.getEnumList().toArray());
        comb.setSelectedItem((Object)ServerUnitTypeEnum.BIZUNIT);
        this.kdtEntry.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comb));
        KDComboBox combTtan = new KDComboBox();
        combTtan.addItems(TransactionModeEnum.getEnumList().toArray());
        combTtan.setSelectedItem((Object)TransactionModeEnum.INHERITED);
        this.kdtEntry.getColumn("TransactionModeEnum").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combTtan));
        KDComboBox exeMode = new KDComboBox();
        exeMode.addItems(ProcessorExecutionModeEnum.getEnumList().toArray());
        exeMode.removeItem((Object)ProcessorExecutionModeEnum.NESTED);
        this.kdtEntry.getColumn("execMode").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)exeMode));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn("processorNum").setRenderer((IBasicRender)avr);
        KDBizPromptBox prompt = new KDBizPromptBox();
        this.kdtEntry.addKDTEditListener(this.kdtListener);
        this.kdtEntry.getColumn("processorNum").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prompt));
        this.kdtEntry.getActionMap().remove("Paste");
        this.kdtEntry.getActionMap().remove("Delete");
        this.kdtEntry.getActionMap().remove("Copy");
        this.kdtEntry.getActionMap().remove("Cut");
        this.kdtEntry.getSelectManager().setSelectMode(2);
    }

    private void addListener() {
        if (this.kdtListener == null) {
            this.kdtListener = new KDTEditAdapter(){

                public void editStarted(KDTEditEvent e) {
                    int colIndex = e.getColIndex();
                    int rowIndex = e.getRowIndex();
                    if (colIndex == BusinessProcessChainEditUI.this.kdtEntry.getColumnIndex("processorNum")) {
                        BusinessProcessChainEditUI.this.chengeQueryByType(rowIndex, colIndex);
                    }
                    if (colIndex == BusinessProcessChainEditUI.this.kdtEntry.getColumnIndex("condition")) {
                        try {
                            BusinessProcessChainEditUI.this.doCondition(rowIndex, colIndex);
                        }
                        catch (BOSException e1) {
                            BusinessProcessChainEditUI.this.handUIException(e1);
                        }
                        catch (Exception e11) {
                            BusinessProcessChainEditUI.this.handUIException(e11);
                        }
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    int colIndex = e.getColIndex();
                    int rowIndex = e.getRowIndex();
                    if (colIndex == BusinessProcessChainEditUI.this.kdtEntry.getColumnIndex("processorNum") && BusinessProcessChainEditUI.this.kdtEntry.getCell(rowIndex, colIndex).getValue() != null) {
                        Object obj = BusinessProcessChainEditUI.this.kdtEntry.getCell(rowIndex, colIndex).getValue();
                        boolean flag = BusinessProcessChainEditUI.this.checkIsHave(obj, rowIndex);
                        if (flag) {
                            BusinessProcessChainEditUI.this.kdtEntry.getCell(rowIndex, "processorNum").setValue(null);
                            return;
                        }
                        BusinessProcessChainEditUI.this.setBizUnitName(rowIndex, colIndex, BusinessProcessChainEditUI.this.kdtEntry.getCell(rowIndex, colIndex).getValue());
                    } else if (colIndex == BusinessProcessChainEditUI.this.kdtEntry.getColumnIndex("processorNum") && BusinessProcessChainEditUI.this.kdtEntry.getCell(rowIndex, colIndex).getValue() == null) {
                        BusinessProcessChainEditUI.this.kdtEntry.getCell(rowIndex, "processorName").setValue(null);
                    }
                    if (colIndex == BusinessProcessChainEditUI.this.kdtEntry.getColumnIndex("type") && !e.getOldValue().equals(e.getValue())) {
                        BusinessProcessChainEditUI.this.clearTblProcName(rowIndex, colIndex);
                    }
                }
            };
        }
    }

    public void storeFields() {
        super.storeFields();
        if (this.kdtEntry.getRowCount() == 0) {
            return;
        }
        boolean flag = false;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            Integer temp = new Integer(this.kdtEntry.getCell(i, "seq").getValue().toString());
            int seq = temp;
            for (int j = 0; j < this.editData.getEntry().size(); ++j) {
                int entrySeq;
                BusinessProcessChainEntryInfo entry = this.editData.getEntry().get(j);
                if (!flag) {
                    if (this.editData.getEntry().get(j + 1) != null) {
                        entry.setNextProcessor(this.editData.getEntry().get(j + 1));
                    }
                    if (this.condMap.get(j + "") == null) {
                        entry.setCondition(null);
                    } else {
                        entry.setCondition(this.condMap.get(j + "").toString());
                    }
                }
                if (seq == (entrySeq = entry.getSeq()) && this.kdtEntry.getCell(j, "processorNum") != null) {
                    ObjectBaseInfo info;
                    Object obj = this.kdtEntry.getCell(j, "processorNum").getValue();
                    if (obj instanceof BusinessProcessChainInfo) {
                        info = (BusinessProcessChainInfo)obj;
                        entry.setProcessor(info.getId().toString());
                    }
                    if (obj instanceof BusinessProcessorInfo) {
                        info = (BusinessProcessorInfo)obj;
                        entry.setProcessor(info.getId().toString());
                    }
                    if (obj == null) {
                        entry.setProcessor(null);
                    }
                }
                if (j != this.editData.getEntry().size() - 1) continue;
                flag = true;
            }
        }
        this.editData.getEntry().size();
        this.editData.getEntry().get(this.editData.getEntry().size() - 1).setNextProcessor(null);
        if (this.bosType != null) {
            this.editData.setBosType(this.bosType.split("&")[0]);
            BactchActionInfo actionInfo = (BactchActionInfo)this.combOp.getSelectedItem();
            if (actionInfo != null) {
                this.editData.setAction(actionInfo.getFBizAction());
            }
            this.editData.setSystemName(this.systemName);
        }
        flag = false;
    }

    private void chengeQueryByType(int rowIndex, int colIndex) {
        if (this.kdtEntry.getCell(rowIndex, "type").getValue() != null) {
            ServerUnitTypeEnum obj = (ServerUnitTypeEnum)((Object)this.kdtEntry.getCell(rowIndex, "type").getValue());
            KDBizPromptBox prompt = (KDBizPromptBox)this.kdtEntry.getColumn("processorNum").getEditor().getComponent();
            prompt.setDisplayFormat("$number$");
            prompt.setEditFormat("$number$");
            prompt.setCommitFormat("$number$");
            if (obj.equals((Object)ServerUnitTypeEnum.BIZCHAIN)) {
                prompt.setQueryInfo("com.kingdee.eas.dynbusiness.adv.chain.app.BizProcessChainQuery");
            } else {
                prompt.setQueryInfo("com.kingdee.eas.dynbusiness.adv.chain.app.BizProcessorF7Query");
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1), CompareType.EQUALS));
                ev.setFilter(filter);
                prompt.setEntityViewInfo(ev);
            }
        }
    }

    private void setBizUnitName(int rowIndex, int colIndex, Object o) {
        ObjectBaseInfo info;
        if (o instanceof BusinessProcessChainInfo) {
            info = (BusinessProcessChainInfo)o;
            this.kdtEntry.getCell(rowIndex, "processorName").setValue((Object)info.getName());
        }
        if (o instanceof BusinessProcessorInfo) {
            info = (BusinessProcessorInfo)o;
            this.kdtEntry.getCell(rowIndex, "processorName").setValue((Object)info.getName());
        }
    }

    private void setSeq() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            this.kdtEntry.getCell(i, "seq").setValue((Object)(i + 1 + ""));
        }
    }

    private void loadLineFields(IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(this.kdtEntry, row, obj);
    }

    private boolean checkTblIsSelect() {
        return this.kdtEntry.getSelectManager().get(0) != null;
    }

    private BusinessProcessChainCollection getBizProcChain(Set id) throws BOSException {
        if (id.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.INCLUDE));
        view.setFilter(filter);
        return BusinessProcessChainFactory.getRemoteInstance().getBusinessProcessChainCollection(view);
    }

    private BusinessProcessorCollection getBizProcor(Set id) throws BOSException {
        if (id.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.INCLUDE));
        view.setFilter(filter);
        return BusinessProcessorFactory.getRemoteInstance().getBusinessProcessorCollection(view);
    }

    private Set getIDByType(boolean isBizChain) {
        HashSet<String> id = new HashSet<String>();
        BusinessProcessChainEntryCollection entry = this.editData.getEntry();
        if (isBizChain) {
            for (int i = 0; i < entry.size(); ++i) {
                if (!entry.get(i).getType().equals((Object)ServerUnitTypeEnum.BIZCHAIN)) continue;
                id.add(entry.get(i).getProcessor());
            }
        } else {
            for (int i = 0; i < entry.size(); ++i) {
                if (!entry.get(i).getType().equals((Object)ServerUnitTypeEnum.BIZUNIT)) continue;
                id.add(entry.get(i).getProcessor());
            }
        }
        return id;
    }

    private void clearTblProcName(int rowIndex, int colIndex) {
        this.kdtEntry.getCell(rowIndex, "processorNum").setValue(null);
        this.kdtEntry.getCell(rowIndex, "processorName").setValue(null);
        ServerUnitTypeEnum obj = (ServerUnitTypeEnum)((Object)this.kdtEntry.getCell(rowIndex, "type").getValue());
        KDBizPromptBox prompt = (KDBizPromptBox)this.kdtEntry.getColumn("processorNum").getEditor().getComponent();
        prompt.setDisplayFormat("$number$");
        prompt.setEditFormat("$number$");
        prompt.setCommitFormat("$number$");
        prompt.setEntityViewInfo(null);
        if (obj.equals((Object)ServerUnitTypeEnum.BIZCHAIN)) {
            prompt.setQueryInfo("com.kingdee.eas.dynbusiness.chain.app.BizProcessChainQuery");
        } else {
            prompt.setQueryInfo("com.kingdee.eas.dynbusiness.chain.app.BizProcessorF7Query");
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    private void initData() {
        if (this.editData != null && this.editData.getSubSystem() == null) {
            String billName = (String)this.getUIContext().get("billName");
            if (this.getUIContext().get("bosType") != null) {
                this.bosType = (String)this.getUIContext().get("bosType") + "&" + billName;
            }
            String fullName = (String)this.getUIContext().get("fullName");
            this.subSystem = fullName + "&" + billName;
            this.editData.setSubSystem(fullName);
            this.txtBosType.setText(billName);
            this.systemName = billName;
        }
        if (this.classParam != null) {
            if (this.classParam.equals("1")) {
                this.comboType.setSelectedIndex(0);
            } else if (this.classParam.equals("2")) {
                this.comboType.setSelectedIndex(1);
            } else if (this.classParam.equals("3")) {
                this.comboType.setSelectedIndex(2);
            }
            if (this.editData.getVersion() != null) {
                this.chainVerison = this.editData.getVersion();
            }
        }
        this.initOldData((IObjectValue)this.editData);
    }

    private void setBillType() {
        if (this.editData.getSubSystem() != null) {
            this.subSystem = this.editData.getSubSystem();
            this.txtBosType.setText(this.editData.getSystemName());
            this.systemName = this.editData.getSystemName();
        }
        if (this.editData.getBosType() != null) {
            this.bosType = this.editData.getBosType();
        }
        String action = this.editData.getAction();
        for (int i = 0; i < this.combOp.getItemCount(); ++i) {
            BactchActionInfo actionInfo = (BactchActionInfo)this.combOp.getItemAt(i);
            if (!actionInfo.getFBizAction().equals(action)) continue;
            this.combOp.setSelectedIndex(i);
            break;
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection con = super.getSelectors();
        con.add(new SelectorItemInfo("subSystem"));
        con.add(new SelectorItemInfo("systemName"));
        con.add(new SelectorItemInfo("version"));
        return con;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verify();
        super.actionSubmit_actionPerformed(e);
    }

    private void verify() throws Exception {
        ProcessorExecutionModeEnum exeModel;
        int ret;
        if (this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"NUM_NOT_NULL"));
            this.abort();
        } else if (this.txtDescription.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"DESC_NOT_NULL"));
            this.abort();
        } else if (this.kdtEntry.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"TBL_NOT_NULL"));
            this.abort();
        } else if (this.editData.getId() == null) {
            String number = this.txtNumber.getText().trim();
            boolean flag = ChainCommonFacadeFactory.getRemoteInstance().checkNumberExists(true, number);
            if (flag) {
                MsgBox.showInfo((String)EASResource.getString((String)str, (String)"NUMBER_IS_EXISTS"));
                this.abort();
            }
        }
        if (!this.isHaveProcessor()) {
            // empty if block
        }
        if ((ret = this.checkExecMode()) == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"NOT_HAVE_MAIN_PROC"));
            this.abort();
        }
        if (ret == 2) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"ENTRY_NOTHAVE_VALUE"));
            this.abort();
        }
        if (ret == 3) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"ONLY_HAVE_MAINPROC"));
            this.abort();
        }
        if (ret == 4) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"EXCERPT_SELF"));
            this.abort();
        }
        if (ret == 5) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"MAIN_MUST_KEY_ACTIVE"));
            this.abort();
        }
        if (this.kdtEntry.getCell(0, "execMode").getValue() != null && !(exeModel = (ProcessorExecutionModeEnum)((Object)this.kdtEntry.getCell(0, "execMode").getValue())).equals((Object)ProcessorExecutionModeEnum.MAIN)) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"BEFORE_MAINPROC"));
        }
    }

    private void doCondition(int rowIndex, int colIndex) throws Exception {
        if (this.bosType == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("bostype", this.bosType.split("&")[0]);
        uiContext.put("entryCond", this.entryCondMap);
        String entryID = null;
        if (this.kdtEntry.getCell(rowIndex, "id").getValue() != null) {
            entryID = this.kdtEntry.getCell(rowIndex, "id").getValue().toString();
        }
        uiContext.put("entryID", entryID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FilterPanelUI.class.getName(), (Map)uiContext);
        ((JDialog)uiWindow).setResizable(true);
        FilterPanelUI fomulaUI = (FilterPanelUI)uiWindow.getUIObject();
        uiWindow.show();
        ConditionDatas condDatas = fomulaUI.getCondDatas();
        if (condDatas == null) {
            this.condMap.remove(rowIndex + "");
            this.kdtEntry.getCell(rowIndex, colIndex).setValue((Object)"");
            return;
        }
        ArrayList list = condDatas.getConditionData();
        String linkMask = condDatas.getLinkMask();
        JSONObject entryJson = null;
        entryJson = this.condMap.get(rowIndex + "") != null ? (JSONObject)this.condMap.get(rowIndex + "") : new JSONObject();
        for (int i = 0; i < list.size(); ++i) {
            JSONObject details = new JSONObject();
            ConditionData data = (ConditionData)list.get(i);
            if (data != null) {
                ConditionItemData value;
                ConditionItemData item = data.getItem();
                if (item != null) {
                    details.put("leftItem", (Object)item.getConditonItemItem());
                    details.put("leftValue", (Object)item.getConditonItemValue());
                    if (item.getConditionItemType() != null) {
                        details.put("leftType", item.getConditionItemType().getValue());
                    }
                    details.put("comparison", (Object)data.getComparison());
                }
                if ((value = data.getValue()) != null) {
                    details.put("rightItem", (Object)value.getConditonItemItem());
                    details.put("rightValue", (Object)value.getConditonItemValue());
                    if (value.getConditionItemType() != null) {
                        details.put("rightType", value.getConditionItemType().getValue());
                    }
                    if (value.getFunValue() != null) {
                        details.put("param", (Object)value.getFunValue().getParam());
                    }
                }
            }
            entryJson.put(i + "", (Object)details);
        }
        String displayStr = this.parseConditionJSON(entryJson, linkMask);
        this.kdtEntry.getCell(rowIndex, colIndex).setValue((Object)displayStr);
        entryJson.put("linkMask", (Object)linkMask);
        this.condMap.put(rowIndex + "", entryJson);
        this.entryCondMap.put(entryID, entryJson);
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            if (this.editData != null && this.editData.getNumber() == null) {
                this.txtNumber.setAccessAuthority(0);
            } else {
                this.txtNumber.setAccessAuthority(1);
            }
        }
        this.setButtonState();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.editData.getNumber() == null) {
            this.txtNumber.setAccessAuthority(0);
        } else {
            this.txtNumber.setAccessAuthority(1);
        }
    }

    private boolean checkIsHave(Object o, int rowIndex) {
        ObjectBaseInfo baseInfo = (ObjectBaseInfo)o;
        boolean flag = false;
        String currentFid = baseInfo.getId().toString();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (this.kdtEntry.getCell(i, "processorNum").getValue() == null) continue;
            String fid = ((ObjectBaseInfo)this.kdtEntry.getCell(i, "processorNum").getValue()).getId().toString();
            if (rowIndex == i || !currentFid.equals(fid)) continue;
            flag = true;
            break;
        }
        if (flag) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"MORE_PROC"));
        }
        return flag;
    }

    private boolean isHaveProcessor() {
        boolean flag = false;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            ServerUnitTypeEnum type = (ServerUnitTypeEnum)((Object)this.kdtEntry.getCell(i, "type").getValue());
            if (!type.equals((Object)ServerUnitTypeEnum.BIZUNIT)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public boolean checkBeforeWindowClosing() {
        this.getUIContext().remove("bosType");
        this.getUIContext().remove("fullName");
        this.getUIContext().remove("billName");
        return super.checkBeforeWindowClosing();
    }

    private int checkExecMode() {
        int ret = 0;
        int count = 0;
        String fid = "";
        if (this.editData.getId() != null) {
            fid = this.editData.getId().toString();
        }
        for (int i = 0; i < this.editData.getEntry().size(); ++i) {
            BusinessProcessChainEntryInfo entry = this.editData.getEntry().get(i);
            if (entry.getProcessor() == null) {
                ret = 2;
                break;
            }
            if (entry.getExecMode().equals((Object)ProcessorExecutionModeEnum.MAIN)) {
                if (++count >= 2) {
                    ret = 3;
                    break;
                }
                if (!entry.isIsKey() || !entry.isIsActive()) {
                    ret = 5;
                    break;
                }
            }
            if (!fid.equals(entry.getProcessor())) continue;
            ret = 4;
            break;
        }
        if (count == 0) {
            ret = 1;
        }
        return ret;
    }

    private void initCombOp() {
        ArrayList list = null;
        try {
            list = ChainCommonFacadeFactory.getRemoteInstance().getBactchActionInfo();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (list != null) {
            this.combOp.addItems(list.toArray());
        }
    }

    private JSONObject buildConditionJSON() {
        Iterator iterator = this.condMap.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            JSONObject json = (JSONObject)this.condMap.get(key);
            try {
                this.obj.put(i + "", (Object)json);
                ++i;
            }
            catch (JSONException e) {}
        }
        return null;
    }

    private String parseConditionJSON(JSONObject json, String linkMask) throws JSONException {
        String[][] rs = null;
        if (linkMask != null) {
            ExpressionParser parser = ExpressionParser.getInstance();
            rs = parser.splitLinkMask(linkMask);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            try {
                JSONObject o = (JSONObject)json.get(i + "");
                if (i < rs.length) {
                    sb.append(rs[i][0]);
                }
                sb.append(o.get("leftItem")).append(" ");
                sb.append(o.get("comparison")).append(" ");
                sb.append(o.get("rightItem")).append(" ");
                if (i >= rs.length) continue;
                sb.append(rs[i][2]);
                sb.append(rs[i][3]);
                continue;
            }
            catch (JSONException e) {
                break;
            }
        }
        return sb.toString();
    }

    private void setDisplayConditionValue() {
        BusinessProcessChainEntryCollection entrys = this.editData.getEntry();
        this.condMap.clear();
        this.entryCondMap.clear();
        for (int i = 0; i < entrys.size(); ++i) {
            BusinessProcessChainEntryInfo entry = entrys.get(i);
            try {
                if (entry.getCondition() == null) continue;
                JSONObject entryJson = new JSONObject(entry.getCondition());
                String linkMask = "";
                try {
                    linkMask = entryJson.getString("linkMask");
                }
                catch (JSONException e) {
                    // empty catch block
                }
                String displayStr = this.parseConditionJSON(entryJson, linkMask);
                entry.setCondition(displayStr);
                this.condMap.put(i + "", entryJson);
                this.entryCondMap.put(entry.getId().toString(), entryJson);
                continue;
            }
            catch (JSONException e) {
                break;
            }
        }
    }

    private int getLevel() {
        return Integer.parseInt(this.classParam);
    }

    private void setVersion() {
        String[] ver = this.chainVerison.split("\\.");
        if (this.classParam.equals("1")) {
            ver[0] = this.addOne(ver[0]);
        }
        if (this.classParam.equals("2")) {
            ver[1] = this.addOne(ver[1]);
        }
        if (this.classParam.equals("3")) {
            ver[2] = this.addOne(ver[2]);
        }
        this.chainVerison = ver[0] + "." + ver[1] + "." + ver[2];
    }

    private String addOne(String str) {
        Integer ver = new Integer(str);
        return ver + 1 + "";
    }

    private void setButtonState() {
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnRuleUp.setEnabled(true);
            this.btnRuleDown.setEnabled(true);
            this.btnRuleAddLine.setEnabled(true);
            this.btnRuleInsertLine.setEnabled(true);
            this.btnRuleDelLine.setEnabled(true);
        } else {
            this.btnRuleUp.setEnabled(false);
            this.btnRuleDown.setEnabled(false);
            this.btnRuleAddLine.setEnabled(false);
            this.btnRuleInsertLine.setEnabled(false);
            this.btnRuleDelLine.setEnabled(false);
        }
    }

    public void actionExportSQL_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            this.setVersion();
            String fid = this.editData.getId().toString();
            ChainCommonFacadeFactory.getRemoteInstance().updateVersion(fid, this.chainVerison);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            String fid = this.editData.getId().toString();
            ArrayList<String> id = new ArrayList<String>();
            id.add(fid);
            boolean flag = ChainCommonFacadeFactory.getRemoteInstance().isExcerpt(id);
            if (flag) {
                MsgBox.showInfo((String)EASResource.getString((String)str, (String)"CAN_NOT_DEL"));
                return;
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    public void beforeChengeChainEntry(String entryID) {
        int level = 0;
        for (int i = 0; i < this.editData.getEntry().size(); ++i) {
            BusinessProcessChainEntryInfo entry = this.editData.getEntry().get(i);
            if (!entry.getId().toString().equals(entryID)) continue;
            level = entry.getLevel();
            break;
        }
        if (this.classParam.equals("2") && level == 1) {
            MsgBox.showInfo((String)"\u884c\u4e1a\u7ea7\u522b\u4e0b,\u4e0d\u80fd\u5220\u9664\u548c\u4fee\u6539\u6807\u51c6\u4e1a\u52a1\u670d\u52a1\u5355\u5143!");
            this.abort();
        }
        if (this.classParam.equals("3") && (level == 1 || level == 2)) {
            MsgBox.showInfo((String)"\u5ba2\u6237\u5b9a\u5236\u7ea7\u522b\u4e0b,\u4e0d\u80fd\u5220\u9664\u548c\u4fee\u6539\u6807\u51c6\u53ca\u884c\u4e1a\u4e1a\u52a1\u670d\u52a1\u5355\u5143!");
            this.abort();
        }
    }
}

