/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.ChainCommonFacadeFactory;
import com.kingdee.eas.dynbusiness.adv.chain.client.AbstractBusinessProcessorListUI;
import com.kingdee.eas.dynbusiness.adv.chain.client.BusinessProcessorEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BusinessProcessorListUI
extends AbstractBusinessProcessorListUI {
    private static final Logger logger = CoreUIObject.getLogger(BusinessProcessorListUI.class);
    private TreeSelectionListener treeListener = null;
    private static String str = "com.kingdee.eas.dynbusiness.adv.chain.BusinessChainResource";

    public void onLoad() throws Exception {
        if (this.mainQuery == null) {
            FilterInfo filter = new FilterInfo();
            this.mainQuery = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"1111"));
            this.mainQuery.setFilter(filter);
        }
        this.getUIContext().remove("checkLicense");
        super.onLoad();
        IBriefViewTreeNode vtn = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_subsystemEntity", (BOSObjectType)MetaDataTypeList.ENTITY);
        IBriefViewTreeNode rvtn = SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)vtn);
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)rvtn);
        ((KingdeeTreeModel)this.tree.getModel()).setRoot((TreeNode)root);
        this.tblMain.setColumnMoveable(true);
        this.addListener();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BusinessProcessorFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BusinessProcessorEditUI.class.getName();
    }

    private void addListener() {
        if (this.treeListener == null) {
            this.treeListener = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        BusinessProcessorListUI.this.treeMain_valueChanged(e);
                    }
                    catch (Exception exc) {
                        BusinessProcessorListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tree.addTreeSelectionListener(this.treeListener);
    }

    private void treeMain_valueChanged(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            if (node.getParent() == null) {
                this.mainQuery.setFilter(new FilterInfo());
            } else {
                FilterInfo filter = this.initFilterItem(node);
                this.mainQuery.setFilter(filter);
            }
            this.refreshList();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private FilterInfo initFilterItem(DefaultKingdeeTreeNode treeNode) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        String type = (String)this.getUIContext().get("UIClassParam");
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)type, CompareType.EQUALS));
        MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)treeNode.getUserObject();
        if (briefInfo.getBOType() != null) {
            String bostype = briefInfo.getBOType().toString();
            filter.getFilterItems().add(new FilterItemInfo("bostype", (Object)bostype, CompareType.EQUALS));
        } else {
            ArrayList boList = this.getTreeBOList();
            if (boList != null) {
                MetaDataBriefInfo uo = null;
                FilterItemInfo fi = null;
                HashSet<String> set = new HashSet<String>();
                set.add(briefInfo.getRealName());
                for (int i = 0; i < boList.size(); ++i) {
                    uo = (MetaDataBriefInfo)boList.get(i);
                    set.add(uo.getRealName());
                }
                fi = new FilterItemInfo("subSystem", set, CompareType.INCLUDE);
                filter.getFilterItems().add(fi);
            }
        }
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i == 0) {
                maskString.append("#" + i);
                continue;
            }
            maskString.append(" and #" + i);
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    private void initEntityBriefList(DefaultKingdeeTreeNode treeNode, FilterInfo filter) {
        if (treeNode.getParent() == null) {
            return;
        }
        int count = treeNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
            MetaDataBriefInfo childBriefInfo = (MetaDataBriefInfo)childNode.getUserObject();
            if (childBriefInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) || childBriefInfo.isPackage()) {
                String alias = childBriefInfo.getAlias();
                filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)("%" + alias), CompareType.LIKE));
            }
            if (!childBriefInfo.isPackage()) continue;
            this.initEntityBriefList(childNode, filter);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"MUST_SELECT_NODE"));
            return;
        }
        MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)node.getUserObject();
        BOSObjectType bosType = briefInfo.getBOType();
        String fullName = briefInfo.getFullName();
        if (bosType != null) {
            this.getUIContext().put("bosType", bosType.toString());
        }
        String billName = briefInfo.getAlias();
        this.getUIContext().put("fullName", fullName);
        this.getUIContext().put("billName", billName);
        super.actionAddNew_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        String classParam = (String)this.getUIContext().get("UIClassParam");
        if (classParam == null) {
            classParam = "1";
        }
        uiContext.put((Object)"UIClassParam", (Object)classParam);
        super.prepareUIContext(uiContext, e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList != null && idList.size() > 0) {
            boolean flag = ChainCommonFacadeFactory.getRemoteInstance().isExcerpt(idList);
            if (flag) {
                MsgBox.showInfo((String)EASResource.getString((String)str, (String)"CAN_NOT_DEL"));
                return;
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("systemName"));
        return sic;
    }

    private ArrayList getTreeBOList() {
        KDTree tree = this.tree;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        ArrayList list = null;
        if (selectedNode != null && selectedNode.getParent() != null) {
            list = this.getBOList(selectedNode);
        } else {
            logger.debug((Object)"tree event:No select Leaf Node!");
        }
        return list;
    }

    private ArrayList getBOList(DefaultKingdeeTreeNode root) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (root.isLeaf()) {
            list.add(root.getUserObject());
        } else {
            list.add(root.getUserObject());
            for (int i = 0; i < root.getChildCount(); ++i) {
                if (root.getChildAt(i).isLeaf()) {
                    Object childrenNode = ((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                    list.add(childrenNode);
                    continue;
                }
                list.addAll(this.getBOList((DefaultKingdeeTreeNode)root.getChildAt(i)));
            }
        }
        return list;
    }
}

