/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer;

import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.SortedArray;
import com.kingdee.eas.base.form.designer.compare.UniqueIDCompare;
import com.kingdee.eas.base.form.designer.compare.XYCompare;
import com.kingdee.eas.base.form.designer.widget.WidgetItemBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;

public class TabIndexManage {
    private OverlayWindow overWnd;
    private HashMap parentIndexMap;
    private SortedArray dealList;
    private boolean isCompleted;

    public TabIndexManage(OverlayWindow wnd) {
        this.overWnd = wnd;
        this.parentIndexMap = new HashMap();
        this.dealList = new SortedArray();
        this.dealList.setComparer(new UniqueIDCompare());
        this.isCompleted = false;
    }

    public void autoIndex(Container container) {
        WidgetItemBase item;
        int i;
        SortedArray listControl = new SortedArray();
        Component[] coms = container.getComponents();
        for (i = 0; i < coms.length; ++i) {
            if (coms[i] instanceof Container) {
                this.autoIndex((Container)coms[i]);
            }
            if ((item = this.overWnd.getItemFromControl(coms[i])) == null) continue;
            listControl.add(item);
        }
        listControl.setComparer(new XYCompare());
        for (i = 0; i < listControl.getCount(); ++i) {
            item = (WidgetItemBase)listControl.get(i);
            item.setTabIndex(i);
        }
    }

    public void ClickInItem(WidgetItemBase item) {
        Container parent = item.getControl().getParent();
        int currentIndex = 0;
        if (!this.parentIndexMap.containsKey(parent)) {
            this.parentIndexMap.put(parent, new Integer(currentIndex));
        } else {
            currentIndex = Integer.parseInt(this.parentIndexMap.get(parent).toString());
        }
        item.setTabIndex(currentIndex);
        this.parentIndexMap.put(parent, new Integer(this.GetNextIndex(parent, currentIndex)));
        this.dealList.add(item);
        if (this.CheckComplete()) {
            this.dealList.clear();
            this.isCompleted = true;
        } else {
            this.Invalidate(item);
            this.isCompleted = false;
        }
    }

    public int GetNextIndex(Container parent, int index) {
        int rtv;
        int count = parent.getComponentCount();
        if (parent == this.overWnd.getDesignForm()) {
            count -= 2;
        }
        if ((rtv = index + 1) >= count) {
            rtv = 0;
        }
        return rtv;
    }

    public void Invalidate(WidgetItemBase item) {
        item.invalidate();
        for (Component c : item.getChildrenControls()) {
            WidgetItemBase it = this.overWnd.getItemFromControl(c);
            if (it == null) continue;
            this.Invalidate(it);
        }
    }

    public boolean CheckComplete() {
        return this.dealList.getCount() == this.overWnd.getItemContainer().size();
    }

    public void Draw(Graphics gis, Rectangle bounds) {
        for (WidgetItemBase item : this.overWnd.getItemContainer()) {
            Rectangle rect = item.getClientRect();
            if (!rect.intersects(bounds) || !item.isVisible()) continue;
            String s = item.getTabPath();
            int width = gis.getFontMetrics().stringWidth(s);
            int height = gis.getFontMetrics().getHeight();
            rect.width = width + 1;
            rect.height = height + 1;
            if (this.isCompleted || !this.dealList.contains(item)) {
                gis.setColor(Color.WHITE);
                gis.drawRect(rect.x, rect.y, rect.width, rect.height);
                gis.setColor(Color.BLUE);
                gis.fillRect(rect.x, rect.y, rect.width, rect.height);
                gis.setColor(Color.WHITE);
                gis.drawString(s, rect.x, rect.y + rect.height);
                continue;
            }
            gis.setColor(Color.BLACK);
            gis.drawRect(rect.x, rect.y, rect.width, rect.height);
            gis.setColor(Color.WHITE);
            gis.fillRect(rect.x, rect.y, rect.width, rect.height);
            gis.setColor(Color.BLUE);
            gis.drawString(s, rect.x, rect.y + rect.height);
        }
    }
}

