/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.SortedArray;
import com.kingdee.eas.base.form.designer.command.CommandBringToTop;
import com.kingdee.eas.base.form.designer.command.CommandList;
import com.kingdee.eas.base.form.designer.command.CommandSendToBack;
import com.kingdee.eas.base.form.designer.compare.LeftCompare;
import com.kingdee.eas.base.form.designer.compare.TopCompare;
import com.kingdee.eas.base.form.designer.widget.WidgetItemBase;
import com.kingdee.eas.base.form.designer.widget.WidgetLabelContainer;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

public class ToolBarOperation {
    private static final int HorizontalSpacingStep = 5;
    private static final int VerticalSpacingStep = 5;
    private OverlayWindow overWnd;

    public ToolBarOperation(OverlayWindow wnd) {
        this.overWnd = wnd;
    }

    private boolean SelectionCanDoGroupOperation() {
        return !this.overWnd.getSelection().isFatherAndChildSelected();
    }

    public void autoIndex() {
        this.overWnd.autoIndex();
    }

    public void alignLefts() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        int x = this.overWnd.getSelection().getPrimaryItem().getClientRect().x;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            Rectangle rect = item.getClientRect();
            rect.x = x;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void alignCenters() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int x = rect.x + rect.width / 2;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.x = x - rect.width / 2;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void alignRights() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int x = rect.x + rect.width;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.x = x - rect.width;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void alignTops() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int y = rect.y;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.y = y;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void alignMiddles() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int y = rect.y + rect.height / 2;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect = item.getClientRect();
            rect.y = y - rect.height / 2;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void alignBottoms() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int y = rect.y + rect.height;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.y = y - rect.height;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void makeSameWidth() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int width = rect.width;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.width = width;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void makeSameHeight() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        int height = rect.height;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.height = height;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void makeSameSize() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        Dimension sz = rect.getSize();
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            if (item == this.overWnd.getSelection().getPrimaryItem()) continue;
            rect = item.getClientRect();
            rect.setSize(sz);
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void makeHorizontalSpacingEqual() {
        if (this.overWnd.getSelection().getCount() < 3 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new LeftCompare());
        Rectangle rc = ((WidgetItemBase)list.get(list.getCount() - 1)).getClientRect();
        int left = ((WidgetItemBase)list.get((int)0)).getClientRect().x;
        int totalWidth = rc.x + rc.width - left;
        int itemsWidth = 0;
        for (WidgetItemBase item : list.getList()) {
            itemsWidth += item.getClientRect().width;
        }
        int distance = (totalWidth - itemsWidth) / (list.getCount() - 1);
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (int i = 1; i < list.getCount() - 1; ++i) {
            WidgetItemBase item = (WidgetItemBase)list.get(i);
            Rectangle rect = item.getClientRect();
            rc = ((WidgetItemBase)list.get(i - 1)).getClientRect();
            rect.x = rc.x + rc.width + distance;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    private void changeHorizontalSpacing(int step) {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new LeftCompare());
        int index = list.find(this.overWnd.getSelection().getPrimaryItem());
        int left = rect.x;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (int i = 0; i < list.getCount(); ++i) {
            if (i == index) continue;
            WidgetItemBase item = (WidgetItemBase)list.get(i);
            rect = item.getClientRect();
            rect.x = step < 0 ? (i < index ? Math.min(rect.x + (i - index) * step, left) : Math.max(left, rect.x + (i - index) * step)) : (rect.x += (i - index) * step);
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void increaseHorizontalSpacing() {
        this.changeHorizontalSpacing(5);
    }

    public void decreaseHorizontalSpacing() {
        this.changeHorizontalSpacing(-5);
    }

    public void makeGrid() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new TopCompare());
        this.overWnd.getCommandList().PrepareMultiCommand();
        WidgetItemBase item = (WidgetItemBase)list.get(0);
        Rectangle rectSrc = item.getClientRect();
        for (int i = 1; i < list.getCount(); ++i) {
            rectSrc.y = rectSrc.y + rectSrc.height - 1;
            item = (WidgetItemBase)list.get(i);
            item.setClientRect(rectSrc);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void makeHGrid() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new LeftCompare());
        this.overWnd.getCommandList().PrepareMultiCommand();
        WidgetItemBase item = (WidgetItemBase)list.get(0);
        Rectangle rectSrc = item.getClientRect();
        for (int i = 1; i < list.getCount(); ++i) {
            item = (WidgetItemBase)list.get(i);
            Rectangle rect = item.getClientRect();
            rectSrc.x = rectSrc.x + rectSrc.width - 1;
            rect.y = rectSrc.y;
            rect.x = rectSrc.x;
            item.setClientRect(rect);
            rectSrc.width = rect.width;
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void setHorizontalSpacing(int x) {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new LeftCompare());
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (int i = 1; i < list.getCount(); ++i) {
            WidgetItemBase item = (WidgetItemBase)list.get(i);
            Rectangle rect = item.getClientRect();
            Rectangle rc = ((WidgetItemBase)list.get(i - 1)).getClientRect();
            rect.x = rc.x + rc.width + x;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void RemoveHorizontalSpacing() {
        this.setHorizontalSpacing(0);
    }

    public void makeVerticalSpacingEqual() {
        if (this.overWnd.getSelection().getCount() < 3 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new TopCompare());
        Rectangle rc = ((WidgetItemBase)list.get(list.getCount() - 1)).getClientRect();
        int top = ((WidgetItemBase)list.get((int)0)).getClientRect().x;
        int totalHeight = rc.y + rc.height - top;
        int itemsHeight = 0;
        for (WidgetItemBase item : list.getList()) {
            itemsHeight += item.getClientRect().height;
        }
        int distance = (totalHeight - itemsHeight) / (list.getCount() - 1);
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (int i = 1; i < list.getCount() - 1; ++i) {
            WidgetItemBase item = (WidgetItemBase)list.get(i);
            Rectangle rect = item.getClientRect();
            rc = ((WidgetItemBase)list.get(i - 1)).getClientRect();
            rect.y = rc.y + rc.height + distance;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    private void changeVerticalSpacing(int step) {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        Rectangle rect = this.overWnd.getSelection().getPrimaryItem().getClientRect();
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new TopCompare());
        int index = list.find(this.overWnd.getSelection().getPrimaryItem());
        int top = rect.y;
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (int i = 0; i < list.getCount(); ++i) {
            if (i == index) continue;
            WidgetItemBase item = (WidgetItemBase)list.get(i);
            rect = item.getClientRect();
            rect.y = step < 0 ? (i < index ? Math.min(rect.y + (i - index) * step, top) : Math.max(rect.y + (i - index) * step, top)) : (rect.y += (i - index) * step);
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void increaseVerticalSpacing() {
        this.changeVerticalSpacing(5);
    }

    public void decreaseVerticalSpacing() {
        this.changeVerticalSpacing(-5);
    }

    public void setVerticalSpacing(int y) {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        SortedArray list = new SortedArray();
        list.addRange(this.overWnd.getSelection().getSelectList().getList());
        list.setComparer(new TopCompare());
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (int i = 1; i < list.getCount(); ++i) {
            WidgetItemBase item = (WidgetItemBase)list.get(i);
            Rectangle rect = item.getClientRect();
            Rectangle rc = ((WidgetItemBase)list.get(i - 1)).getClientRect();
            rect.y = rc.y + rc.height + y;
            item.setClientRect(rect);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void removeVerticalSpacing() {
        this.setVerticalSpacing(0);
    }

    public void bringToFront() {
        if (this.overWnd.getSelection().getCount() <= 0 || this.overWnd.isLocked()) {
            return;
        }
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            CommandBringToTop cmd = new CommandBringToTop(item, this.overWnd);
            this.overWnd.getCommandList().addCommand(cmd);
            cmd.execute();
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void sendToBack() {
        if (this.overWnd.getSelection().getCount() <= 0 || this.overWnd.isLocked()) {
            return;
        }
        this.overWnd.getCommandList().PrepareMultiCommand();
        for (WidgetItemBase item : this.overWnd.getSelection().getSelectList().getList()) {
            CommandSendToBack cmd = new CommandSendToBack(item, this.overWnd);
            this.overWnd.getCommandList().addCommand(cmd);
            cmd.execute();
        }
    }

    public void deleteSelect() {
        if (this.overWnd != null && this.overWnd.getSelection().getCount() <= 0) {
            MsgBox.showWarning((Component)ComponentUtil.getOwnerWindow(null), (String)"\u8bf7\u9009\u62e9\u5143\u7d20\uff01");
            return;
        }
        this.overWnd.getSelection().deleteSelectItems();
    }

    public void undo() {
        this.overWnd.getCommandList().undo();
        this.overWnd.repaint();
    }

    public void redo() throws BOSException {
        this.overWnd.getCommandList().redo();
        this.overWnd.repaint();
    }

    public void itemContainerSameLabelWidth() {
        if (this.overWnd.getSelection().getCount() < 2 || !this.SelectionCanDoGroupOperation() || this.overWnd.isLocked()) {
            return;
        }
        if (!(this.overWnd.getSelection().getPrimaryItem() instanceof WidgetLabelContainer)) {
            return;
        }
        WidgetLabelContainer item = (WidgetLabelContainer)this.overWnd.getSelection().getPrimaryItem();
        if (item == null) {
            return;
        }
        this.overWnd.getCommandList().PrepareMultiCommand();
        int labelWidth = item.getLabelWidth();
        for (WidgetItemBase it : this.overWnd.getSelection().getSelectList().getList()) {
            WidgetLabelContainer ic;
            if (!(it instanceof WidgetLabelContainer) || (ic = (WidgetLabelContainer)it) == null || ic == item) continue;
            ic.setLabelWidth(labelWidth);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void lock() {
        this.overWnd.setLocked(!this.overWnd.isLocked());
    }

    public CommandList getCommandList() {
        return this.overWnd.getCommandList();
    }
}

