/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.command;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.command.ICommand;
import com.kingdee.eas.base.form.designer.command.MultiCommand;
import com.kingdee.eas.base.form.designer.listenner.CommandListChangedListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class CommandList {
    private OverlayWindow overWnd;
    private List commands;
    private int currentUndoPos = -1;
    private List preparedMultiCmd;
    private int maxLength;
    private static final int MaxCommandListLength = 16;
    private EventListenerList listenerList;

    public void addCommandSizeChangedListener(CommandListChangedListener pl) {
        this.listenerList.add(CommandListChangedListener.class, pl);
    }

    public void removeCommandSizeChangedListener(CommandListChangedListener pl) {
        this.listenerList.remove(CommandListChangedListener.class, pl);
    }

    public CommandList(OverlayWindow wnd) {
        this.overWnd = wnd;
        this.commands = new ArrayList();
        this.preparedMultiCmd = new ArrayList();
        this.maxLength = 16;
        this.listenerList = new EventListenerList();
    }

    public void initToolbarAction() {
        this.fireInitToolbarAction();
    }

    public void setToolbarLocateAction(int selectedCount) {
        this.fireSetToolbarLocateAction(selectedCount);
    }

    public void undo() {
        this.overWnd.comeBackControl();
        if (this.currentUndoPos >= 0) {
            ((ICommand)this.commands.get(this.currentUndoPos)).unExecute();
            --this.currentUndoPos;
            this.fireUndoRedoChanged();
        }
    }

    public void redo() throws BOSException {
        this.overWnd.comeBackControl();
        if (++this.currentUndoPos < this.commands.size()) {
            ((ICommand)this.commands.get(this.currentUndoPos)).execute();
            this.fireUndoRedoChanged();
        }
    }

    public void addCommand(ICommand cmd) {
        if (this.preparedMultiCmd.size() > 0) {
            ((MultiCommand)this.preparedMultiCmd.get(this.preparedMultiCmd.size() - 1)).Add(cmd);
        } else {
            if (this.currentUndoPos < this.commands.size() - 1) {
                ++this.currentUndoPos;
                for (int i = this.commands.size() - 1; i >= this.currentUndoPos; --i) {
                    this.commands.remove(i);
                }
            }
            this.commands.add(cmd);
            if (this.commands.size() > this.maxLength && this.commands.size() > 0) {
                this.commands.remove(0);
            }
            this.currentUndoPos = this.commands.size() - 1;
        }
        this.fireUndoRedoChanged();
    }

    public void PrepareMultiCommand() {
        this.preparedMultiCmd.add(new MultiCommand());
    }

    public void EndMultiCommand() {
        if (this.preparedMultiCmd.size() == 0) {
            // empty if block
        }
        MultiCommand cmd = (MultiCommand)this.preparedMultiCmd.get(this.preparedMultiCmd.size() - 1);
        this.preparedMultiCmd.remove(this.preparedMultiCmd.size() - 1);
        if (cmd.isEmpty()) {
            return;
        }
        if (this.preparedMultiCmd.size() == 0) {
            if (this.currentUndoPos < this.commands.size() - 1) {
                ++this.currentUndoPos;
                for (int i = this.commands.size() - 1; i >= this.currentUndoPos; --i) {
                    this.commands.remove(i);
                }
            }
            this.commands.add(cmd);
            this.currentUndoPos = this.commands.size() - 1;
        } else {
            ((MultiCommand)this.preparedMultiCmd.get(this.preparedMultiCmd.size() - 1)).Add(cmd);
        }
        this.fireUndoRedoChanged();
    }

    public void clear() {
        this.currentUndoPos = -1;
        this.commands.clear();
        this.fireUndoRedoChanged();
    }

    private void fireUndoRedoChanged() {
        boolean undo = false;
        boolean redo = false;
        boolean[] isDo = this.getCanUndoRedo(undo, redo);
        this.overWnd.getEventsProxy().fireUndoRedoStateChanged(isDo[0], isDo[1]);
        this.fireCommandSizeChanged(isDo[0], isDo[1]);
    }

    public void initUndoRedoAction() {
        boolean undo = false;
        boolean redo = false;
        boolean[] isDo = this.getCanUndoRedo(undo, redo);
        this.fireCommandSizeChanged(isDo[0], isDo[1]);
    }

    private boolean[] getCanUndoRedo(boolean undo, boolean redo) {
        undo = true;
        redo = true;
        if (this.commands.size() == 0) {
            undo = false;
            redo = false;
        } else if (this.currentUndoPos < 0) {
            undo = false;
        } else if (this.currentUndoPos == this.commands.size() - 1) {
            redo = false;
        }
        return new boolean[]{undo, redo};
    }

    private void fireCommandSizeChanged(boolean canUndo, boolean canRedo) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandListChangedListener.class) continue;
            ((CommandListChangedListener)listeners[i + 1]).setUndoRedoAction(canUndo, canRedo);
        }
    }

    private void fireInitToolbarAction() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandListChangedListener.class) continue;
            ((CommandListChangedListener)listeners[i + 1]).initToolbarAction();
        }
    }

    private void fireSetToolbarLocateAction(int selectedCount) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandListChangedListener.class) continue;
            ((CommandListChangedListener)listeners[i + 1]).setToolbarLocateAction(selectedCount);
        }
    }
}

