/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.entityrelation;

import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.entityrelation.Arrow;
import com.kingdee.eas.base.form.designer.entityrelation.EntityTable;
import com.kingdee.eas.base.form.designer.widget.WidgetItem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;

public class WidgetArrow
extends WidgetItem {
    private Point[] points = new Point[4];
    private Area area;
    private static final int DefaultWidth = 7;

    public WidgetArrow(OverlayWindow wnd, Arrow com) {
        super(wnd, com);
    }

    @Override
    public HitResult hitTest(Point pt) {
        int length = this.reCalPos();
        Rectangle rc = this.getHitRectFromPoint(this.points[0], this.points[2]);
        if (rc.contains(pt)) {
            return HitResult.InDragMoveHandle;
        }
        rc = this.getHitRectFromPoint(this.points[2], this.points[3]);
        if (rc.contains(pt)) {
            return HitResult.InDragMoveHandle;
        }
        rc = this.getHitRectFromPoint(this.points[3], this.points[1]);
        if (rc.contains(pt)) {
            return HitResult.InDragMoveHandle;
        }
        return HitResult.None;
    }

    private Rectangle getHitRectFromPoint(Point pt1, Point pt2) {
        Rectangle rc = new Rectangle();
        rc.x = pt1.x < pt2.x ? pt1.x : pt2.x;
        rc.y = pt1.y < pt2.y ? pt1.y : pt2.y;
        rc.width = Math.abs(pt1.x - pt2.x);
        if (rc.width == 0) {
            rc.width = 2;
        }
        rc.height = Math.abs(pt1.y - pt2.y);
        if (rc.height == 0) {
            rc.height = 2;
        }
        return rc;
    }

    private Rectangle getHitRectFromPoint(Point pt1) {
        Rectangle rc = new Rectangle();
        rc.x = pt1.x - 2;
        rc.y = pt1.y - 2;
        rc.width = 5;
        rc.height = 5;
        return rc;
    }

    @Override
    public void drawSelectFrame(Graphics g) {
    }

    @Override
    public void drawHandles(Graphics gis, Color brushColor, Color penColor) {
        Rectangle rect = this.getHitRectFromPoint(this.points[0]);
        this.drawHandle(gis, brushColor, penColor, rect);
        rect = this.getHitRectFromPoint(this.points[1]);
        this.drawHandle(gis, brushColor, penColor, rect);
    }

    @Override
    public void draw(Graphics g) {
        boolean width = true;
        if (this.isSelected()) {
            Color color = Color.RED;
        } else {
            Color color = Color.BLACK;
        }
        int length = this.reCalPos();
        Rectangle rc = this.getHitRectFromPoint(this.points[0], this.points[2]);
        g.drawLine(this.points[0].x + length, this.points[0].y, this.points[2].x, this.points[2].y);
        g.drawLine(this.points[2].x, this.points[2].y, this.points[3].x, this.points[3].y);
        g.drawLine(this.points[3].x, this.points[3].y, this.points[1].x, this.points[1].y);
        float x1 = this.points[0].x;
        float y1 = this.points[0].y;
        GeneralPath path = new GeneralPath();
        path.moveTo(x1, y1);
        path.lineTo(x1 + (float)length, y1 - 7.0f);
        path.lineTo(x1 + (float)length, y1 + 7.0f);
        path.lineTo(x1, y1);
        path.closePath();
        path.closePath();
        this.area = new Area(path);
        ((Graphics2D)g).fill(this.area);
    }

    private int reCalPos() {
        boolean isSrc = false;
        Arrow arrow = (Arrow)this.control;
        EntityTable panelSource = arrow.getOrigin();
        EntityTable panelDestination = arrow.getDestination();
        if (panelSource.getX() <= panelDestination.getX()) {
            isSrc = true;
        }
        this.points[0] = panelSource.getItemPoint(arrow.getOriginIndex(), isSrc);
        this.points[1] = panelDestination.getItemPoint(arrow.getDestinationIndex(), !isSrc);
        this.points[2] = new Point(this.points[0].x + (this.points[1].x - this.points[0].x) / 2, this.points[0].y);
        this.points[3] = new Point(this.points[2].x, this.points[1].y);
        int length = isSrc ? 12 : -12;
        return length;
    }
}

