/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.listenner;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.eas.base.form.client.layout.Table.TableLayout;
import com.kingdee.eas.base.form.designer.Designer;
import com.kingdee.eas.base.form.designer.listenner.CommandAddArgs;
import com.kingdee.eas.base.form.designer.listenner.CommandRemoveArgs;
import com.kingdee.eas.base.form.designer.listenner.ComponentBeforeRemoveArgs;
import com.kingdee.eas.base.form.designer.listenner.ComponentPositionChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.ComponentTabIndexChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.GridActiveToDesignArgs;
import com.kingdee.eas.base.form.designer.listenner.IDesignerListener;
import com.kingdee.eas.base.form.designer.listenner.ItemContainerLabelWidthChangedArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareAddControlEventArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareCopyControlEventArgs;
import com.kingdee.eas.base.form.designer.listenner.PrepareCreateItemOnGridArgs;
import com.kingdee.eas.base.form.designer.listenner.QueryAddedArgs;
import com.kingdee.eas.base.form.designer.listenner.RequestTypeDefaultSizeEventArgs;
import com.kingdee.eas.base.form.designer.listenner.SmartTagClickArg;
import com.kingdee.eas.base.form.designer.listenner.TableLayoutChangeArgs;
import com.kingdee.eas.base.form.designer.listenner.UndoRedoStateChangedEventArgs;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.EventListenerList;

public class DesignerEventsProxy {
    private EventListenerList listenerList;
    private boolean lockEvent;
    private Designer designer;

    public DesignerEventsProxy(Designer designer) {
        this.designer = designer;
        this.listenerList = new EventListenerList();
    }

    public void addDesignerListener(IDesignerListener pl) {
        this.listenerList.add(IDesignerListener.class, pl);
    }

    public void removeDesignerListener(IDesignerListener pl) {
        this.listenerList.remove(IDesignerListener.class, pl);
    }

    public Component firePrepareCopyControl(Rectangle rect, Component comp, Container parent) {
        PrepareCopyControlEventArgs e = new PrepareCopyControlEventArgs(rect, comp, parent);
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).prepareCopyControl(this.designer, e);
            }
        }
        return e.getNewComp();
    }

    public void firePrepareAddControl(Object data, Rectangle rect, int createType, Container parent) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).prepareAddControl(this.designer, new PrepareAddControlEventArgs(data, rect, createType, parent));
            }
        }
    }

    public void fireSelectionChanged() {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).selectionChanged(this.designer);
            }
        }
    }

    public void fireUndoRedoStateChanged(boolean undo, boolean redo) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).undoRedoStateChanged(this.designer, new UndoRedoStateChangedEventArgs(undo, redo));
            }
        }
    }

    public void firePrepareCreateItemOnGrid(Object data, int createType, KDTable grid) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).prepareCreateItemOnGrid(this.designer, new PrepareCreateItemOnGridArgs(grid, createType, data));
            }
        }
    }

    public void firePrepareCreateItemOnVGrid(Object data, int createType, KDTable grid) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).prepareCreateItemOnGrid(this.designer, new PrepareCreateItemOnGridArgs(grid, createType, data));
            }
        }
    }

    public void fireComponentTabIndexChanged(Component Component2, int oldIndex, int newIndex) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).ComponentTabIndexChanged(Component2, new ComponentTabIndexChangedArgs(newIndex, oldIndex));
            }
        }
    }

    public void fireComponentPositionChanged(Component Component2, Container oldParent, Rectangle oldPosition) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).componentPositionChanged(Component2, new ComponentPositionChangedArgs(oldParent, oldPosition));
            }
        }
    }

    public SmartTagClickArg fireSmartTagClicked(Component Component2, Container com, Point location) {
        SmartTagClickArg e = new SmartTagClickArg(com, location);
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).smartTagClicked(Component2, e);
            }
        }
        return e;
    }

    public void fireItemContainerLabelWidthChanged(KDLabelContainer item, int oldWidth) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).itemContainerLabelWidthChanged(this.designer, new ItemContainerLabelWidthChangedArgs(item, oldWidth, item.getBoundLabelLength()));
            }
        }
    }

    public boolean fireComponentBeforeRemove(Component Component2) {
        ComponentBeforeRemoveArgs e = new ComponentBeforeRemoveArgs(Component2);
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).componentBeforeRemove(this.designer, e);
            }
        }
        return e.isCancel();
    }

    public void fireGridActiveToDesign(KDTable grid, Container parent) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).gridActiveToDesign(this.designer, new GridActiveToDesignArgs(grid, parent));
            }
        }
    }

    public void fireTableLayoutChanged(Container container) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).tableLayoutChanged(container, new TableLayoutChangeArgs((TableLayout)container.getLayout()));
            }
        }
    }

    public Object fireCommandAddExecute(Component control) {
        Object rtv = null;
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            CommandAddArgs e = new CommandAddArgs(control);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).commandAddExecute(this.designer, e);
            }
            rtv = e.getBindData();
        }
        return rtv;
    }

    public void fireCommandAddUnExecute(Component control, Object bindData) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).commandAddUnExecute(this.designer, new CommandAddArgs(control, bindData));
            }
        }
    }

    public Object FireCommandRemoveExecute(Component control) {
        Object rtv = null;
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            CommandRemoveArgs e = new CommandRemoveArgs(control);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).commandRemoveExecute(this.designer, e);
            }
            rtv = e.getBindData();
        }
        return rtv;
    }

    public void fireCommandRemoveUnExecute(Component control, Object bindData) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).commandRemoveUnExecute(this.designer, new CommandRemoveArgs(control, bindData));
            }
        }
    }

    public boolean fireQueryCanAdded(Object createData, Rectangle rect, int creatType, Component parent) {
        boolean rtv = true;
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            QueryAddedArgs e = new QueryAddedArgs(rect, createData, creatType, parent);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).queryCanAdded(this.designer, e);
            }
            rtv = e.isAllowAdded();
        }
        return rtv;
    }

    public Dimension fireRequestTypeDefaultSize(int createType, Object data) {
        Dimension rtv = null;
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            RequestTypeDefaultSizeEventArgs e = new RequestTypeDefaultSizeEventArgs(createType, data);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).requestTypeDefaultSize(this.designer, e);
            }
            rtv = e.getSize();
        }
        return rtv;
    }

    public void fireQueryCreateData() {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).queryCreateData(this.designer);
            }
        }
    }

    public String fireGetComponentBindinfo(Component component) {
        String rtv = "";
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                rtv = ((IDesignerListener)listeners[i + 1]).getComponentBindinfo(component);
            }
        }
        return rtv;
    }

    public void firecomponentTextChanged(Component sender) {
        if (!this.lockEvent) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IDesignerListener.class) continue;
                ((IDesignerListener)listeners[i + 1]).componentTextChanged(sender);
            }
        }
    }

    public boolean isLockEvent() {
        return this.lockEvent;
    }

    public void setLockEvent(boolean lockEvent) {
        this.lockEvent = lockEvent;
    }
}

