/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.widget;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.base.form.client.layout.Table.SizeAdjustor;
import com.kingdee.eas.base.form.client.layout.Table.TableLayout;
import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.widget.WidgetItemBase;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class WidgetContainerBase
extends WidgetItemBase {
    private int curRow = 0;
    private int curCol = 0;
    private int curColWidth = 0;
    private int nextColWidth = 0;
    private int curRowHeight = 0;
    private int nextRowHeight = 0;

    public WidgetContainerBase(OverlayWindow wnd, Container com) {
        super(wnd);
        this.control = com;
    }

    @Override
    public void draw(Graphics gis) {
        if (this.control.isVisible() && this.control.getParent() != null && this.overWnd.isItemParentVisible(this.control.getParent())) {
            super.draw(gis);
            Container container = this.getContainerControl();
            if (container.getLayout() instanceof TableLayout) {
                this.drawGrid((TableLayout)container.getLayout(), gis);
            }
        }
    }

    @Override
    public void drawDragHandleRect(Graphics g, HitResult hr, Point offset) {
        if (hr == HitResult.GridVLine) {
            Container container = this.getContainerControl();
            if (container.getLayout() instanceof TableLayout) {
                TableLayout tb = (TableLayout)container.getLayout();
                if (this.curColWidth + offset.x > 10 && this.nextColWidth - offset.x > 10) {
                    tb.getColStyle(this.curCol).setWidth(this.curColWidth + offset.x);
                    tb.getColStyle(this.curCol + 1).setWidth(this.nextColWidth - offset.x);
                    container.doLayout();
                }
            }
        } else if (hr == HitResult.GridHLine) {
            Container container = this.getContainerControl();
            if (container.getLayout() instanceof TableLayout) {
                TableLayout tb = (TableLayout)container.getLayout();
                if (this.curRowHeight + offset.y > 10 && this.nextRowHeight - offset.y > 10) {
                    tb.getRowStyle(this.curRow).setHeight(this.curRowHeight + offset.y);
                    tb.getRowStyle(this.curRow + 1).setHeight(this.nextRowHeight - offset.y);
                    container.doLayout();
                }
            }
        } else {
            super.drawDragHandleRect(g, hr, offset);
        }
    }

    private void drawGrid(TableLayout tb, Graphics gis) {
        Graphics2D g2 = (Graphics2D)gis;
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(stroke);
        Rectangle rc = this.getContainerClientRect();
        int max = rc.x + rc.width;
        SizeAdjustor adjustorX = tb.getAdjustorX();
        for (int i = 0; i < tb.getColCount() && rc.x <= max; ++i) {
            g2.drawLine(rc.x, rc.y, rc.x, rc.y + rc.height);
            rc.x += adjustorX.getOutAt(i);
        }
        if (rc.x <= max) {
            g2.drawLine(rc.x, rc.y, rc.x, rc.y + rc.height);
        }
        rc = this.getContainerClientRect();
        max = rc.y + rc.height;
        SizeAdjustor adjustorY = tb.getAdjustorY();
        for (int i = 0; i < tb.getRowCount() && rc.y <= max; ++i) {
            g2.drawLine(rc.x, rc.y, rc.x + rc.width, rc.y);
            rc.y += adjustorY.getOutAt(i);
        }
        if (rc.y <= max) {
            g2.drawLine(rc.x, rc.y, rc.x + rc.width, rc.y);
        }
        g2.setStroke(oldStroke);
    }

    @Override
    public Cursor getCursor(HitResult hr) {
        switch (hr.getValue()) {
            case 14: {
                return Cursor.getPredefinedCursor(10);
            }
            case 15: {
                return Cursor.getPredefinedCursor(9);
            }
        }
        return super.getCursor(hr);
    }

    @Override
    public void drawSelect(Graphics gis) {
        super.drawSelect(gis);
        if (!this.overWnd.isLocked() && !(this.control.getParent() instanceof KDTabbedPane)) {
            Point pt = this.getDragMoveRect().getLocation();
            BufferedImage img = null;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/kingdee/eas/base/form/designer/res/DragHandle.JPG");
            try {
                if (is != null && (img = ImageIO.read(is)) != null) {
                    gis.drawImage(img, pt.x, pt.y, (ImageObserver)((Object)this.overWnd));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public HitResult hitTest(Point pt) {
        Rectangle rect;
        if (this.isSelected() && !(this.control.getParent() instanceof KDTabbedPane) && (rect = this.getDragMoveRect()).contains(pt)) {
            return HitResult.InDragMoveHandle;
        }
        HitResult hr = super.hitTest(pt);
        if (hr == HitResult.InDragMoveHandle) {
            Container container = this.getContainerControl();
            if (container.getLayout() instanceof TableLayout && this.isSelected()) {
                hr = this.hitTestGridLine((TableLayout)container.getLayout(), pt);
            }
            if (hr == HitResult.None || hr == HitResult.InDragMoveHandle) {
                hr = HitResult.InObject;
            }
        }
        return hr;
    }

    @Override
    public Component endDragCopy(HitResult hr, Point offset) {
        Container con = (Container)super.endDragCopy(hr, offset);
        this.copyChild(this, con);
        return con;
    }

    protected void copyChild(WidgetContainerBase conItem, Container con) {
        List coms = conItem.getChildrenControls();
        for (int i = 0; i < coms.size(); ++i) {
            Component comp = (Component)coms.get(i);
            WidgetContainerBase parentItem = (WidgetContainerBase)this.overWnd.getItemFromControl(con);
            Component newComp = this.overWnd.getEventsProxy().firePrepareCopyControl(comp.getBounds(), comp, parentItem.getContainerControl());
            WidgetItemBase item = this.overWnd.getItemFromControl(comp);
            if (!(item instanceof WidgetContainerBase)) continue;
            this.copyChild((WidgetContainerBase)item, (Container)newComp);
        }
    }

    private Rectangle getDragMoveRect() {
        Point pt = this.getClientRect().getLocation();
        pt.x += 5;
        pt.y -= 5;
        int width = 30;
        int height = 30;
        return new Rectangle(pt.x, pt.y, width, height);
    }

    @Override
    public Container getContainerControl() {
        return (Container)this.control;
    }

    @Override
    public void addControl(Container parent) {
        this.overWnd.getGroupList().add((Container)this.control);
        super.addControl(parent);
    }

    @Override
    public void removeControl(Container parent) {
        super.removeControl(parent);
        this.overWnd.getGroupList().remove(this.control);
    }

    @Override
    public List getChildrenControls() {
        ArrayList<Component> list = new ArrayList<Component>();
        Component[] coms = this.getContainerControl().getComponents();
        for (int i = 0; i < coms.length; ++i) {
            if (coms[i].getName() == null) continue;
            list.add(coms[i]);
        }
        return list;
    }

    public Rectangle getContainerClientRect() {
        return super.getClientRect();
    }

    @Override
    public void setClientRect(Rectangle value) {
        super.setClientRect(value);
        this.doLayout();
    }

    public void doLayout() {
        Container container = this.getContainerControl();
        container.doLayout();
        if (container.getLayout() instanceof TableLayout) {
            TableLayout tb = (TableLayout)container.getLayout();
            this.updateGridStyle(tb);
        }
    }

    private HitResult hitTestGridLine(TableLayout tb, Point pt) {
        Rectangle rc = this.getContainerClientRect();
        SizeAdjustor adjustorX = tb.getAdjustorX();
        for (int i = 1; i < tb.getColCount(); ++i) {
            rc.x += adjustorX.getOutAt(i - 1);
            Rectangle rcLine = new Rectangle(rc.x - 1, rc.y, 2, rc.height);
            if (!rcLine.contains(pt)) continue;
            this.curCol = i - 1;
            this.curColWidth = adjustorX.getOutAt(i - 1);
            this.nextColWidth = adjustorX.getOutAt(i);
            return HitResult.GridVLine;
        }
        rc = this.getContainerClientRect();
        SizeAdjustor adjustorY = tb.getAdjustorY();
        for (int i = 1; i < tb.getRowCount(); ++i) {
            rc.y += adjustorY.getOutAt(i - 1);
            Rectangle rcLine = new Rectangle(rc.x, rc.y, rc.width, 2);
            if (!rcLine.contains(pt)) continue;
            this.curRow = i - 1;
            this.curRowHeight = adjustorY.getOutAt(i - 1);
            this.nextRowHeight = adjustorY.getOutAt(i);
            return HitResult.GridHLine;
        }
        return HitResult.None;
    }

    @Override
    public void endDrag(HitResult hr, Point offset) {
        Container container = this.getContainerControl();
        if (container.getLayout() instanceof TableLayout) {
            Rectangle oldrc = this.getClientRect();
            Rectangle rect = this.getDragHandleRect(hr, offset);
            TableLayout tb = (TableLayout)container.getLayout();
            int widthOffset = rect.width - oldrc.width;
            int width = tb.getColStyle(tb.getColCount() - 1).getWidth() + widthOffset;
            if (width > 3) {
                tb.getColStyle(tb.getColCount() - 1).setWidth(width);
            }
            int heightOffset = rect.height - oldrc.height;
            int height = tb.getRowStyle(tb.getRowCount() - 1).getHeight() + heightOffset;
            if (height > 3) {
                tb.getRowStyle(tb.getRowCount() - 1).setHeight(height);
            }
        }
        super.endDrag(hr, offset);
        if (container.getLayout() instanceof TableLayout) {
            this.overWnd.getEventsProxy().fireTableLayoutChanged(container);
        }
    }

    private void updateGridStyle(TableLayout tb) {
        SizeAdjustor adjustorX = tb.getAdjustorX();
        for (int i = 0; i < tb.getColCount(); ++i) {
            tb.colStyle(i).setWidth(adjustorX.getOutAt(i));
        }
        SizeAdjustor adjustorY = tb.getAdjustorY();
        for (int i = 0; i < tb.getRowCount(); ++i) {
            tb.rowStyle(i).setHeight(adjustorY.getOutAt(i));
        }
    }
}

