/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.widget;

import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.PropertyType;
import com.kingdee.eas.base.form.designer.widget.WidgetItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class WidgetLabelContainer
extends WidgetItem {
    public WidgetLabelContainer(OverlayWindow wnd, KDLabelContainer com) {
        super(wnd, (Component)com);
        this.typeName = "\u6807\u7b7e\u5bb9\u5668";
        com.putClientProperty((Object)"Text", (Object)com.getBoundLabelText());
        this.autoHeight = Boolean.valueOf(com.getClientProperty((Object)"autoHeight").toString());
    }

    @Override
    public Component getControl() {
        return (KDLabelContainer)this.control;
    }

    @Override
    public List getChildrenControls() {
        return new ArrayList();
    }

    @Override
    public void drawHandles(Graphics gis, Color brushColor, Color penColor) {
        if (!this.overWnd.isLocked()) {
            super.drawHandles(gis, brushColor, penColor);
            if (this != this.overWnd.getSelection().getPrimaryItem()) {
                penColor = Color.GREEN;
            }
            Rectangle rect = this.getLabelWidthHandle();
            Color brh = Color.YELLOW;
            this.drawHandle(gis, brh, penColor, rect);
        } else {
            super.drawHandles(gis, brushColor, penColor);
        }
    }

    @Override
    public HitResult hitTest(Point pt) {
        HitResult hr = HitResult.None;
        Rectangle ClientRect = this.getClientRect();
        if (this.overWnd.getSelection().isItemSelected(this)) {
            Rectangle rect = this.getLabelWidthHandle();
            if (rect.contains(pt)) {
                hr = HitResult.LabelWidth;
            } else if (this.autoHeight) {
                rect = new Rectangle(ClientRect.x - 5 - 1, ClientRect.y + ClientRect.height / 2 - 2, 5, 5);
                if (rect.contains(pt)) {
                    hr = HitResult.LeftHandle;
                } else {
                    rect.x = ClientRect.x + ClientRect.width + 1;
                    if (rect.contains(pt)) {
                        hr = HitResult.RightHandle;
                    } else if (ClientRect.contains(pt)) {
                        hr = HitResult.InDragMoveHandle;
                    }
                }
            } else {
                hr = super.hitTest(pt);
            }
        } else {
            hr = super.hitTest(pt);
        }
        return hr;
    }

    @Override
    public void mouseDoubleClick(MouseEvent e) {
        if (!this.overWnd.isLocked()) {
            KDLabelContainer comp = (KDLabelContainer)this.getControl();
            Rectangle bounds = this.getClientRect();
            bounds.y += this.overWnd.getBounds().y;
            bounds.width = comp.getBoundLabelLength();
            if (bounds.width < 50) {
                bounds.width = 50;
            }
            KDTextField txtEdit = this.overWnd.getInplaceEdit();
            txtEdit.setBounds(bounds);
            txtEdit.putClientProperty((Object)"KDLayoutConstraints", (Object)new KDLayout.Constraints(0, bounds));
            txtEdit.setText(comp.getBoundLabelText());
            comp.setBoundLabelText("");
            txtEdit.setVisible(true);
            txtEdit.requestFocus();
            txtEdit.putClientProperty((Object)"EdtitItem", (Object)this);
        }
    }

    private Rectangle getLabelWidthHandle() {
        KDLabelContainer comp = (KDLabelContainer)this.control;
        int textWidth = comp.getBoundLabelLength();
        int height = this.control.getBounds().height;
        Rectangle rect = this.getClientRect();
        int x = rect.x + textWidth - 2;
        int y = rect.y - 5;
        return new Rectangle(x, y, 5, 5);
    }

    @Override
    public void drawDragHandleRect(Graphics g, HitResult hr, Point offset) {
        if (hr == HitResult.LabelWidth) {
            KDLabelContainer comp = (KDLabelContainer)this.control;
            Rectangle rect = this.getClientRect();
            int width = comp.getBoundLabelLength() + offset.x;
            Rectangle rc = new Rectangle(rect.x, rect.y, width, rect.height);
            g.setColor(Color.GRAY);
            g.drawRect(rc.x, rc.y, rc.width, rc.height - 1);
            g.drawLine(rc.x + rc.width, rc.y - 100, rc.x + rc.width, rc.y + rc.height + 100);
        } else {
            super.drawDragHandleRect(g, hr, offset);
        }
    }

    @Override
    public void endDrag(HitResult hr, Point offset) {
        if (hr == HitResult.LabelWidth) {
            KDLabelContainer comp = (KDLabelContainer)this.control;
            int width = comp.getBoundLabelLength() + offset.x;
            this.setLabelWidth(width);
        } else {
            super.endDrag(hr, offset);
        }
    }

    @Override
    public Cursor getCursor(HitResult hr) {
        Cursor cur = hr == HitResult.LabelWidth || hr == HitResult.Control2Width ? Cursor.getPredefinedCursor(11) : super.getCursor(hr);
        return cur;
    }

    public int getLabelWidth() {
        KDLabelContainer comp = (KDLabelContainer)this.control;
        return comp.getBoundLabelLength();
    }

    public void setLabelWidth(int value) {
        if (this.getLabelWidth() == value) {
            return;
        }
        if (this.overWnd.isAddToUndo()) {
            this.onPropertyChanged(PropertyType.LabelWidth, new Integer(this.getLabelWidth()), new Integer(value));
        } else {
            int oldWidth = this.getLabelWidth();
            KDLabelContainer comp = (KDLabelContainer)this.control;
            comp.setBoundLabelLength(value);
            this.overWnd.getEventsProxy().fireItemContainerLabelWidthChanged(comp, oldWidth);
        }
    }

    @Override
    public void setProperty(PropertyType pt, Object value) {
        if (pt == PropertyType.LabelWidth) {
            this.setLabelWidth(Integer.parseInt(value.toString()));
        } else {
            super.setProperty(pt, value);
        }
    }

    @Override
    public void setClientRect(Rectangle value) {
        super.setClientRect(value);
        KDLabelContainer comp = (KDLabelContainer)this.control;
        comp.setBoundLabelLength(comp.getBoundLabelLength() + 1);
        comp.setBoundLabelLength(comp.getBoundLabelLength() - 1);
    }

    @Override
    public void addControl(Container parent) {
        super.addControl(parent);
        KDLabelContainer comp = (KDLabelContainer)this.control;
        comp.setBoundLabelLength(comp.getBoundLabelLength() + 1);
        comp.setBoundLabelLength(comp.getBoundLabelLength() - 1);
    }

    @Override
    public void setText(String value) {
        super.setText(value);
        KDLabelContainer comp = (KDLabelContainer)this.control;
        comp.setBoundLabelText(value);
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        if (this.getBindDataInfo().length() > 0) {
            KDLabelContainer comp = (KDLabelContainer)this.control;
            Rectangle rect = this.getClientRect();
            int width = comp.getBoundLabelLength();
            if (rect.width - width - 2 <= 0) {
                return;
            }
            g.setFont(comp.getFont());
            Rectangle rc = new Rectangle(rect.x + width + 2, rect.y, rect.width - width - 2, rect.height);
            String str = "";
            g.setColor(Color.GRAY);
            int height = g.getFontMetrics().getHeight();
            rc.y = rc.y + (rect.height + height) / 2 - 2;
            g.drawString(str, rc.x, rc.y);
        }
    }
}

