/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.common;

import com.kingdee.messageCenter.IAdapter;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.IMessagePool;
import com.kingdee.messageCenter.IMessageQueue;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;

public class MessageServer
implements IMessage {
    private boolean isStarted = false;

    private IMessagePool getMessagePool() {
        return ObjectFactory.getInstance().getMessagePool();
    }

    private IMessageQueue getMessageQueue() {
        return ObjectFactory.getInstance().getQueue();
    }

    private IAdapter getMessageAdapter() {
        return ObjectFactory.getInstance().getAdapter();
    }

    @Override
    public void start() throws MessageException {
        this.getMessageAdapter().start(this);
        if (!this.isStarted) {
            this.getMessageQueue().setup();
            this.isStarted = true;
        }
    }

    @Override
    public void pushMessage(Message message) throws MessageException {
        this.saveMessage(message);
        this.getMessageAdapter().pushMessage(message);
    }

    private void saveMessage(Message message) throws MessageException {
        if (message.getStatus() == 0) {
            message.setDirector(10);
            this.getMessagePool().saveMessage(message);
        }
    }

    @Override
    public Message getMessage(Message message) throws MessageException {
        this.saveMessage(message);
        return this.getMessageAdapter().getMessage(message);
    }
}

