/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.pushletClient;

import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.IMessageQueue;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import com.kingdee.messageCenter.utils.SecretKeyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Protocol;
import nl.justobjects.pushlet.pushletclient.PushletClient;
import nl.justobjects.pushlet.pushletclient.PushletClientListener;
import nl.justobjects.pushlet.util.PushletException;
import org.apache.log4j.Logger;

public class MessageClient
implements PushletClientListener,
Protocol {
    public static final Logger logger = Logger.getLogger(MessageClient.class);
    public static final String STATUS_LOGIN = "LOGIN";
    public static final String STATUS_RUNNING = "RUNNING";
    public static final String STATUS_STOP = "STOP";
    private static MessageClient instance;
    private static ReentrantLock lock;
    private String status = "STOP";
    private String errMessage = "";
    private PushletClient pushletClient = null;
    private MessageListener messagelistener = null;
    private boolean hostIsLive = true;
    private boolean isDebug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageClient getInstance() {
        if (instance == null) {
            try {
                lock.lock();
                if (instance == null) {
                    instance = new MessageClient();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    private MessageClient() {
    }

    private void runing() throws PushletException {
        this.p("\u542f\u52a8\u76d1\u542c\u3002");
        try {
            this.getMessageServer().start();
            this.pushletClient.listen(MessageClient.getInstance(), "pull");
            this.status = STATUS_RUNNING;
        }
        catch (PushletException pe) {
            this.p("Error in setting up pushlet session pe=" + pe);
            this.errMessage = pe.getMessage();
            this.status = STATUS_STOP;
            if (this.isDebug) {
                pe.printStackTrace();
            }
            throw pe;
        }
        this.p("\u76d1\u542c\u5df2\u542f\u52a8\u3002");
    }

    @Override
    public void onAbort(Event theEvent) {
        this.p("\u670d\u52a1\u5668\u4e2d\u6b62.");
        this.status = STATUS_STOP;
        this.reStart();
    }

    @Override
    public void onData(Event theEvent) {
        this.p("\u63a5\u6536\u6570\u636e.");
        try {
            this.getMessageQueue().receive(Message.fromEvent(theEvent));
        }
        catch (MessageException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void onHeartbeat(Event theEvent) {
        this.p("\u5fc3\u8df3.");
    }

    @Override
    public void onError(String message, Throwable t) {
        this.errMessage = message;
        this.p("onError," + message);
        if (t instanceof ThreadDeath) {
            this.p("ThreadDeath");
        } else {
            this.reStart();
        }
    }

    public void p(String s) {
        if (this.isDebug) {
            System.out.println(s);
        } else {
            logger.error((Object)s);
        }
    }

    public void loginServer() throws MessageException {
        this.p("\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff0c\u5f53\u524d\u72b6\u6001" + this.status);
        if (this.status.equals(STATUS_STOP)) {
            this.p("login.");
            String serverUrl = this.getClientManager().getServerUrl();
            String enterpriseID = this.getClientManager().getClientId();
            String secretKey = this.getClientManager().getSecretKey(enterpriseID);
            if (serverUrl == null || enterpriseID == null || secretKey == null) {
                return;
            }
            long t = System.currentTimeMillis();
            String r = SecretKeyUtil.encrypt(enterpriseID, secretKey, t);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("ENTERPRISEID", enterpriseID);
            attrs.put("r", r);
            attrs.put("t", String.valueOf(t));
            this.pushletClient = new PushletClient(serverUrl);
            if (this.getClientManager().isProxy()) {
                this.pushletClient.setProxyOptions(this.getClientManager().getProxyHost(), this.getClientManager().getProxyPort(), null, null, null, null);
            }
            this.pushletClient.setDebug(this.isDebug);
            try {
                this.pushletClient.join(attrs);
            }
            catch (PushletException e) {
                throw new MessageException(e.getErrorCode(), e.getMessage());
            }
        }
        this.p("\u767b\u5f55\u6210\u529f\uff0c\u5f53\u524d\u72b6\u6001" + this.status);
    }

    private synchronized void reStart() {
        if (this.hostIsLive) {
            this.p("\u5c1d\u8bd5\u91cd\u542f.....");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e1) {
                logger.error((Object)"thread.sleep error.", (Throwable)e1);
                Thread.currentThread().interrupt();
                logger.error((Object)"Thread.sleep  Thread.currentThread().interrupt()");
            }
            this.startClient(true);
        }
    }

    public void startClient(boolean needLogin) {
        this.p("\u5c1d\u8bd5\u91cd\u542f\u5ba2\u6237\u7aef.");
        this.stopClient();
        this.hostIsLive = true;
        this.messagelistener = new MessageListener(needLogin);
        this.messagelistener.start();
        this.p("\u5b8c\u6210\u91cd\u542f\u5ba2\u6237\u7aef");
    }

    public void stopClient() {
        if (this.pushletClient != null) {
            this.p("\u505c\u6b62\u5ba2\u6237\u7aef");
            try {
                this.hostIsLive = false;
                this.status = STATUS_STOP;
                this.pushletClient.stopListen();
            }
            catch (PushletException e) {
                logger.error((Object)"\u505c\u6b62\u5ba2\u6237\u7aef\u5931\u8d25", (Throwable)e);
            }
            this.p("\u5ba2\u6237\u7aef\u5df2\u505c\u6b62");
        }
        if (this.messagelistener != null) {
            this.messagelistener.interrupt();
            this.messagelistener = null;
        }
    }

    public void pushMessage(Message message) throws MessageException {
        try {
            Map<String, String> data = message.getBody();
            message.setEnterpriseId(this.getClientManager().getClientId());
            data.put("MESSAGEID", message.getId());
            data.put("ENTERPRISEID", message.getEnterpriseId());
            this.pushletClient.publish(message.getSubject(), data);
        }
        catch (PushletException e) {
            throw new MessageException(e.getErrorCode(), e.getMessage());
        }
    }

    public void subscribe(String subject) throws MessageException {
        try {
            this.pushletClient.subscribe(subject);
        }
        catch (PushletException e) {
            throw new MessageException(e);
        }
    }

    public Message getMessage(Message message) throws MessageException {
        Message retData = null;
        try {
            Map<String, String> data = message.getBody();
            message.setEnterpriseId(this.getClientManager().getClientId());
            data.put("MESSAGEID", message.getId());
            data.put("ENTERPRISEID", message.getEnterpriseId());
            retData = Message.fromEvent(this.pushletClient.getData(message.getSubject(), data));
        }
        catch (PushletException e) {
            throw new MessageException(e.getErrorCode(), e.getMessage());
        }
        return retData;
    }

    public String getStatus() {
        return this.status;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    private IMessage getMessageServer() {
        return ObjectFactory.getInstance().getMessageServer();
    }

    private IClientManager getClientManager() {
        return ObjectFactory.getInstance().getClientManager();
    }

    private IMessageQueue getMessageQueue() {
        return ObjectFactory.getInstance().getQueue();
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    static {
        lock = new ReentrantLock();
    }

    private class MessageListener
    extends Thread {
        private boolean needLogin = true;

        public MessageListener(boolean needLogin) {
            this.needLogin = needLogin;
        }

        @Override
        public void run() {
            MessageClient client = MessageClient.getInstance();
            try {
                if (this.needLogin) {
                    client.loginServer();
                }
                client.runing();
            }
            catch (Exception e) {
                if (MessageClient.this.isDebug) {
                    e.printStackTrace();
                }
                logger.error((Object)"\u6d88\u606f\u76d1\u542c\u542f\u52a8\u5931\u8d25", (Throwable)e);
                client.reStart();
            }
        }
    }
}

