/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final String HEX_CHARS = "0123456789abcdef";

    private MD5Util() {
    }

    static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(byte[] data) {
        return MD5Util.getDigest().digest(data);
    }

    public static byte[] md5(String data) {
        return MD5Util.md5(data.getBytes());
    }

    public static String md5Hex(byte[] data) {
        return MD5Util.toHexString(MD5Util.md5(data));
    }

    public static String md5Hex(String data) {
        return MD5Util.toHexString(MD5Util.md5(data));
    }

    public static String getMD5Str(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
            System.exit(-1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return md5StrBuff.toString();
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_CHARS.charAt(b[i] >>> 4 & 0xF));
            sb.append(HEX_CHARS.charAt(b[i] & 0xF));
        }
        return sb.toString();
    }
}

