/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.common.ObjectFactory;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.EventSource;
import nl.justobjects.pushlet.util.Log;

public abstract class EventPullSource
implements EventSource,
Runnable {
    private volatile boolean alive = false;
    private volatile boolean active = false;
    private static int threadNum = 0;
    private Thread thread;
    IMessage messageServer = null;

    protected abstract long getSleepTime();

    protected abstract Event pullEvent();

    public IMessage getMessageServer() {
        if (this.messageServer == null) {
            this.messageServer = ObjectFactory.getInstance().getMessageServer();
        }
        return this.messageServer;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "EventPullSource-" + ++threadNum);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void stop() {
        this.alive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public synchronized void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (!this.alive) {
            this.start();
            return;
        }
        Log.debug(this.getClass().getName() + ": notifying...");
        this.notifyAll();
    }

    @Override
    public void passivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.debug(this.getClass().getName() + ": starting...");
        this.alive = true;
        while (this.alive) {
            try {
                Thread.sleep(this.getSleepTime());
                if (!this.alive) break;
                EventPullSource eventPullSource = this;
                synchronized (eventPullSource) {
                    while (!this.active) {
                        Log.debug(this.getClass().getName() + ": waiting...");
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                Event event = this.pullEvent();
                this.getMessageServer().pushMessage(Message.fromEvent(event));
            }
            catch (Throwable t) {
                Log.warn("EventPullSource exception while multicasting ", t);
                t.printStackTrace();
            }
        }
        Log.debug(this.getClass().getName() + ": stopped");
    }
}

