/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.test;

import java.util.HashMap;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Protocol;
import nl.justobjects.pushlet.pushletclient.PushletClient;
import nl.justobjects.pushlet.pushletclient.PushletClientListener;
import nl.justobjects.pushlet.util.PushletException;

public class PushletPingApplication
extends Thread
implements PushletClientListener,
Protocol {
    private PushletClient pushletClient;
    private String host;
    private int port;
    private static final String SUBJECT = "/test/ping";
    private static final long PUBLISH_INTERVAL_MILLIS = 3000L;

    public PushletPingApplication(String aHost, int aPort) {
        this.host = aHost;
        this.port = aPort;
    }

    @Override
    public void run() {
        try {
            this.pushletClient = new PushletClient(this.host, this.port);
            this.pushletClient.setDebug(true);
            this.pushletClient.join(null);
            this.pushletClient.listen(this, "stream");
            String subscriptionId = this.pushletClient.subscribe(SUBJECT);
            this.pushletClient.unsubscribe(subscriptionId);
            this.pushletClient.subscribe(SUBJECT);
            this.p("pushletClient started");
        }
        catch (PushletException pe) {
            this.p("Error in setting up pushlet session pe=" + pe);
            return;
        }
        HashMap<String, String> eventData = new HashMap<String, String>(2);
        int seqNr = 1;
        while (true) {
            try {
                while (true) {
                    eventData.put("seqNr", "" + seqNr++);
                    eventData.put("time", "" + System.currentTimeMillis());
                    this.pushletClient.publish(SUBJECT, eventData);
                    this.p("published ping # " + (seqNr - 1) + " - sleeping...");
                    Thread.sleep(3000L);
                }
            }
            catch (Exception e) {
                this.p("Postlet exception: " + e);
                System.exit(-1);
                continue;
            }
            break;
        }
    }

    @Override
    public void onError(String message, Throwable t) {
        this.p(message);
    }

    @Override
    public void onAbort(Event theEvent) {
        this.p("onAbort received: " + theEvent);
    }

    @Override
    public void onData(Event theEvent) {
        long then = Long.parseLong(theEvent.getField("time"));
        long delay = System.currentTimeMillis() - then;
        this.p("onData: ping #" + theEvent.getField("seqNr") + " in " + delay + " ms");
    }

    @Override
    public void onHeartbeat(Event theEvent) {
        this.p("onHeartbeat received: " + theEvent);
    }

    public void p(String s) {
        System.out.println("[PushletPing] " + s);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1; ++i) {
            if (args.length == 0) {
                new PushletPingApplication("localhost", 8080).start();
                continue;
            }
            new PushletPingApplication(args[0], Integer.parseInt(args[1])).start();
        }
    }
}

