/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.test;

import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Protocol;
import nl.justobjects.pushlet.pushletclient.PushletClient;
import nl.justobjects.pushlet.pushletclient.PushletClientListener;
import nl.justobjects.pushlet.util.PushletException;

public class SimpleListener
implements PushletClientListener,
Protocol {
    private static String SUBJECT = "/temperature";
    private static final String MODE = "stream";

    public SimpleListener(String aHost, int aPort) {
        try {
            PushletClient pushletClient = new PushletClient(aHost, aPort);
            pushletClient.setDebug(false);
            pushletClient.join(null);
            pushletClient.listen(this, MODE, SUBJECT);
            this.p("pushletClient started");
        }
        catch (PushletException pe) {
            this.p("Error in setting up pushlet session pe=" + pe);
        }
    }

    @Override
    public void onError(String message, Throwable t) {
        this.p(message);
    }

    @Override
    public void onAbort(Event theEvent) {
        this.p("onAbort received: " + theEvent);
    }

    @Override
    public void onData(Event theEvent) {
        System.out.println(theEvent.toXML());
    }

    @Override
    public void onHeartbeat(Event theEvent) {
        this.p("onHeartbeat received: " + theEvent);
    }

    public void p(String s) {
        System.out.println("[SimpleListener] " + s);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new SimpleListener("localhost", 8080);
        } else if (args.length == 1) {
            SUBJECT = args[0];
            new SimpleListener("localhost", 8080);
        } else {
            SUBJECT = args[0];
            new SimpleListener(args[1], Integer.parseInt(args[2]));
        }
    }
}

