/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.report.client.ReportQueryDlg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.common.client.PrecisionConfig4IMRptUI;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class CommonQueryDialogAdapter
extends ReportQueryDlg {
    public static final String UICONTEXT_KEY_INITPARAMS = "UICONTEXT_KEY_INITPARAMS";
    public static final String CUSTOMERPARAM = "customerParam";
    protected CommonQueryDialog queryDialog = null;
    private SCMBillFilterUI[] userPanels = null;
    private IMetaDataPK pk = new MetaDataPK("com.kingdee.eas.framework.report.app", "CommRptEmptyQuery");
    private String parentUIName;
    private PrecisionConfig4IMRptUI pc = null;

    public CommonQueryDialogAdapter(CoreUI owner) {
        super(owner);
    }

    public void setCustomerQueryPanel(SCMBillFilterUI[] userPanels) {
        this.userPanels = userPanels;
        if (userPanels != null && userPanels.length > 0) {
            this.parentUIName = userPanels[0].getClass().getName();
        }
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanels != null) {
            int i;
            boolean isImRpt = false;
            int n = this.userPanels.length;
            for (i = 0; i < n; ++i) {
                this.userPanels[i].loadFields();
            }
            for (i = 0; i < n; ++i) {
                this.userPanels[i].initLayout();
                if (this.userPanels[i].toString().indexOf("com.kingdee.eas.scm.im.rpt.client.MaterialStayRptFilterUI") > -1 || this.userPanels[i].toString().indexOf("com.kingdee.eas.scm.im.rpt.client.NewOutStorageGatherFilterUI") > -1) {
                    isImRpt = true;
                }
                this.queryDialog.addUserPanel((KDPanel)this.userPanels[i]);
            }
            if (isImRpt) {
                if (this.pc == null) {
                    this.pc = new PrecisionConfig4IMRptUI();
                    this.pc.setPanelName(this.pc.getUITitle());
                }
                this.queryDialog.addUserPanel((KDPanel)this.pc);
            }
            Dimension dd = this.getQueryDialogSize((CustomerQueryPanel[])this.userPanels);
            this.queryDialog.setWidth(dd.width);
            this.queryDialog.setShowFieldCompare(false);
            this.queryDialog.setHeight(dd.height);
            if (this.getOwner() != null) {
                this.queryDialog.setOwner((Component)this.getOwner().getUIContext().get("Owner"));
            }
            this.queryDialog.setQueryObjectPK(this.pk);
            this.queryDialog.setDisShowRowCount(true);
            this.queryDialog.setTitle(this.getTitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.queryDialog.setShowFilter(this.isShowFilter());
            this.queryDialog.setShowSorter(this.isShowSorter());
            this.queryDialog.setParentUIClassName(this.parentUIName);
            this.initUserPanels(n);
        }
    }

    private void initUserPanels(int n) throws Exception, IllegalAccessException, InvocationTargetException {
        CustomerParams cp = null;
        if (this.getFilter() != null) {
            cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.getFilter());
        }
        for (int i = 0; i < n; ++i) {
            this.userPanels[i].initLayout();
            this.userPanels[i].onInit(this.getFilter());
            this.userPanels[i].setCustomerParams(cp);
            this.userPanels[i].getUIContext().clear();
            this.userPanels[i].getUIContext().putAll(this.getOwner().getUIContext());
        }
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        Dimension size = new Dimension(100, 100);
        int n = userPanels.length;
        for (int i = 0; i < n; ++i) {
            Dimension d = userPanels[i].getSize();
            if (d.height > size.height) {
                size.height = d.height;
            }
            if (d.width <= size.width) continue;
            size.width = d.width;
        }
        size.height += 35;
        size.width += 228;
        size.height += 105;
        if (size.width <= 290 && size.height <= 280) {
            size.width = 290;
            size.height = 280;
        } else if (size.width <= 580 && size.height <= 435) {
            size.width = 580;
            size.height = 435;
        } else if (size.width <= 680 && size.height <= 510) {
            size.width = 680;
            size.height = 510;
        } else if (size.width <= 792 && size.height <= 566) {
            size.width = 792;
            size.height = 566;
        }
        size.width -= 228;
        size.height -= 105;
        return size;
    }

    public boolean showQueryDialog(boolean useDefaultSolution) throws Exception {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            this.initQueryDialog();
        }
        int n = this.userPanels.length;
        if (useDefaultSolution) {
            int count = n;
            if (this.pc != null) {
                ++count;
            }
            this.loadDefaultSolution(count);
        }
        boolean ok = false;
        if ((this.getFilter() == null || !useDefaultSolution) && this.queryDialog.show()) {
            if (this.getFilter() == null) {
                this.setFilter(new RptParams());
            } else {
                this.getFilter().clear();
            }
            for (int i = 0; i < n; ++i) {
                RptParams param = this.userPanels[i].getFilterManager().getRptParams();
                if (param == null) continue;
                this.getFilter().putAll(param.toMap());
            }
            if (this.pc != null && this.getFilter() != null) {
                this.getFilter().putAll(this.pc.getCustomCondition().toMap());
            }
            ok = true;
        }
        if (this.getFilter() != null && (ok || useDefaultSolution)) {
            CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.getFilter());
            for (int i = 0; i < n; ++i) {
                this.userPanels[i].setCustomerParams(cp);
                this.userPanels[i].getFilterManager().setCustomerParams(cp, true);
                RptParams param = this.userPanels[i].getFilterManager().getRptParams();
                if (this.getFilter().size() != 0 || param == null) continue;
                this.getFilter().putAll(param.toMap());
            }
            return true;
        }
        return false;
    }

    private void loadDefaultSolution(int n) throws BOSException, EASBizException {
        block18: {
            String queryName;
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            if (iQuery.hasDefaultSolution(this.parentUIName, queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.pk).getFullName())) {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.parentUIName, queryName);
                QueryPanelInfo[] qpi = new QueryPanelInfo[n];
                for (int i = 0; i < n; ++i) {
                    qpi[i] = solution.getQueryPanelInfo().get(i);
                }
                if (qpi[0] != null) {
                    try {
                        byte[] bs = qpi[0].getParam();
                        if (bs != null) {
                            this.setFilter((RptParams)CommonUtil.getObject((byte[])bs));
                        }
                        if (this.getFilter() != null) {
                            CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.getFilter());
                            for (int i = 0; i < n; ++i) {
                                this.userPanels[i].setCustomerParams(cp);
                            }
                            break block18;
                        }
                        CustomerParams[] cp = new CustomerParams[n];
                        Object obj = null;
                        for (int i = 0; i < n; ++i) {
                            cp[i] = CustomerParams.getCustomerParams2((String)qpi[i].getCustomerParams());
                            if (cp[i] == null) continue;
                            try {
                                obj = RptParamsUtil.getFromCustomerParams((CustomerParams)cp[i]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (obj instanceof RptParams) {
                                this.setFilter((RptParams)obj);
                                continue;
                            }
                            if (this.getFilter() == null) {
                                this.setFilter(new RptParams());
                            }
                            if (this.pc != null) {
                                RptParams param = null;
                                if (PrecisionConfig4IMRptUI.class.getName().equals(qpi[i].getPanelClassName().toString())) {
                                    RptParams rptParams = new RptParams();
                                    HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
                                    tempMap.put("spinQtyPrecission", cp[i].getInt("qtySpin"));
                                    tempMap.put("spinAssQtyPrecission", cp[i].getInt("assQtySpin"));
                                    tempMap.put("spinPricePrecission", cp[i].getInt("priceSpin"));
                                    tempMap.put("spinAmountPrecission", cp[i].getInt("amountSpin"));
                                    rptParams.putAll(tempMap);
                                    this.pc.setCustomCondition(rptParams);
                                    param = this.pc.getCustomCondition();
                                } else {
                                    for (int k = 0; k < this.userPanels.length; ++k) {
                                        if (!this.userPanels[k].getClass().toString().endsWith(qpi[i].getPanelClassName().toString())) continue;
                                        this.userPanels[k].setCustomerParams(cp[i]);
                                        this.userPanels[k].getFilterManager().setCustomerParams(cp[i], true);
                                        param = this.userPanels[k].getFilterManager().getRptParams();
                                    }
                                }
                                if (param == null) continue;
                                this.getFilter().putAll(param.toMap());
                                continue;
                            }
                            for (int j = 0; j < n; ++j) {
                                if (null == qpi[i].getPanelClassName() || !this.userPanels[j].getClass().toString().endsWith(qpi[i].getPanelClassName().toString())) continue;
                                this.userPanels[j].setCustomerParams(cp[i]);
                                this.userPanels[j].getFilterManager().setCustomerParams(cp[i], true);
                                RptParams param = this.userPanels[j].getFilterManager().getRptParams();
                                if (param == null) continue;
                                this.getFilter().putAll(param.toMap());
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean showFilterDialog(String filterUIName, boolean useDefaultSolution) throws Exception {
        if (this.queryDialog == null) {
            String[] uiName = filterUIName.split(",");
            SCMBillFilterUI[] filterUIs = new SCMBillFilterUI[uiName.length];
            for (int i = 0; i < uiName.length; ++i) {
                SCMBillFilterUI filterUI;
                filterUIs[i] = filterUI = (SCMBillFilterUI)Class.forName(uiName[i]).newInstance();
            }
            this.setCustomerQueryPanel(filterUIs);
            this.setShowFilter(false);
            this.setShowSorter(false);
        }
        return this.showQueryDialog(useDefaultSolution);
    }
}

