/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.report.client.AbstractReportFilterUI;
import com.kingdee.eas.base.report.client.BizPromptFilterElement;
import com.kingdee.eas.base.report.client.SpinnerFilterElement;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import java.awt.Component;
import java.awt.Container;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class ReportFilterUI
extends AbstractReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
    private String companyOrgID = this.companyOrg.getId().toString();
    public int attribute1;

    public CompanyOrgUnitInfo getCompanyOrg() {
        return this.companyOrg;
    }

    public String getCompanyOrgID() {
        return this.companyOrgID;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComp();
        this.setUIParam();
    }

    public abstract void initComp() throws Exception;

    public void setDefaultValue() {
        this.getFilterManager().clearAll();
    }

    public void setUIParam() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Set allLeafComponents = UIUtil.getAllComponents((Container)((Object)this));
        for (Component comp : allLeafComponents) {
            if (!(comp instanceof IKDTextComponent)) continue;
            if (comp instanceof KDTextField) {
                elements.add((FilterElement)new SingleFilterElement(comp.getName(), comp));
                IKDTextComponent txtComp = (IKDTextComponent)comp;
                if (txtComp.isRequired()) {
                    ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)((KDTextField)comp));
                }
            } else if (comp instanceof KDBizPromptBox) {
                BizPromptFilterElement filterElement = new BizPromptFilterElement(comp.getName(), (KDBizPromptBox)comp);
                IKDTextComponent txtComp = (IKDTextComponent)comp;
                if (txtComp.isRequired()) {
                    ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)((KDBizPromptBox)comp));
                }
                elements.add((FilterElement)filterElement);
            } else if (comp instanceof KDSpinner) {
                elements.add((FilterElement)new SpinnerFilterElement(comp.getName(), comp));
            } else if (comp instanceof KDLabelContainer) {
                KDLabelContainer lbl = (KDLabelContainer)comp;
                lbl.setBoundLabelUnderline(true);
            } else {
                elements.add((FilterElement)new SingleFilterElement(comp.getName(), comp));
            }
            this.getFilterManager().setElement((FilterElement)elements);
        }
    }
}

