/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ctrl.print.io;

import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.kingdee.eas.el.rec.ctrl.print.io.RecFontCache;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Font;

public class RecKDFontMapper
extends KDFontMapper {
    public BaseFont awtToPdf(Font font) {
        try {
            int style;
            KDFontMapper.BaseFontParameters p = RecFontCache.getBaseFontParameters(font.getFontName());
            if (p == null && (style = font.getStyle()) != 0) {
                String styledName = font.getFontName();
                if ((style & 1) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Bold");
                }
                if ((style & 2) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Italic");
                }
                p = RecFontCache.getBaseFontParameters(styledName);
            }
            BaseFont basefont = null;
            if (p == null) {
                if (RecFontCache.defaultFont != null) {
                    basefont = RecFontCache.defaultFont;
                    return basefont;
                }
                throw new ExceptionConverter(new Exception("Can't find any font named [" + font.getFontName() + " ] installed in your system, default font is not Available too."));
            }
            String key = p.fontName + "\n" + p.encoding + "\n" + p.embedded;
            basefont = RecFontCache.getFontCache().get(key);
            if (null == basefont) {
                basefont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
                RecFontCache.getFontCache().putIfAbsent(key, basefont);
            }
            return RecFontCache.getFontCache().get(key);
        }
        catch (Exception e) {
            if (RecFontCache.defaultFont != null) {
                return RecFontCache.defaultFont;
            }
            throw new ExceptionConverter(e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        String finalName = name3x;
        if (name3x == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }
}

