/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ctrl.print.io;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.io.AbstractExport;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.eas.el.rec.thread.FontMapperThreadLocal;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RecPdfExport
extends AbstractExport {
    OutputStream os;
    Document document;
    PdfContentByte pdfContentByte;
    private static FontMapperThreadLocal DEFAULT_FONTMAPPER = new FontMapperThreadLocal();

    public RecPdfExport() {
    }

    public RecPdfExport(OutputStream os) {
        this.os = os;
    }

    public void begin(String fileNamePre, KDPrinter printer) {
        if (this.os == null) {
            String des = fileNamePre;
            if (!des.endsWith(".pdf")) {
                des = des + ".pdf";
            }
            File destFile = new File(des);
            try {
                this.os = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException e1) {
                throw new RuntimeException(destFile + " FileNotFoundException error:" + e1.getMessage(), e1);
            }
        }
        try {
            ControlPrint cPrint = printer.getControlPrint();
            Paper paper = cPrint.getPaper(0);
            float width = paper.getWidth();
            float height = paper.getHeight();
            Rectangle rc = new Rectangle((float)StyleUtil.pixelToPt((long)((long)width)), (float)StyleUtil.pixelToPt((long)((long)height)));
            float topM = paper.getPainterInfo().getAttributeManager().getBodyTopMargin(1000);
            float bottomM = paper.getPainterInfo().getAttributeManager().getBodyBottomMargin(1000);
            float leftM = paper.getPainterInfo().getAttributeManager().getLeftMargin(1000);
            float rightM = paper.getPainterInfo().getAttributeManager().getRightMargin(1000);
            float topPt = (float)StyleUtil.lomToPt((double)(topM * 10.0f));
            float bottomPt = (float)StyleUtil.lomToPt((double)(bottomM * 10.0f));
            float leftPt = (float)StyleUtil.lomToPt((double)(leftM * 10.0f));
            float rightPt = (float)StyleUtil.lomToPt((double)(rightM * 10.0f));
            this.document = new Document(rc, leftPt, rightPt, topPt, bottomPt);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error:" + e.getMessage(), e);
        }
    }

    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        long width = (long)paper.getWidth();
        long height = (long)paper.getHeight();
        PdfTemplate pdftemplate = this.pdfContentByte.createTemplate((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height));
        Graphics2D graphics2d = pdftemplate.createGraphics((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height), (FontMapper)DEFAULT_FONTMAPPER.get());
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        paper.painting((Graphics)graphics2d, paper.getPainterInfo());
        graphics2d.dispose();
        pdftemplate.setWidth((float)StyleUtil.pixelToPt((long)width));
        pdftemplate.setHeight((float)StyleUtil.pixelToPt((long)height));
        this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
        this.document.newPage();
    }

    public void end() {
        try {
            this.document.close();
            this.os.flush();
            this.os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void export(String fileNamePre, KDPrinter printer) {
        printer.getPrintJob().getPageCount();
        super.export(fileNamePre, printer);
    }
}

