/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.instance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArchSchemeFactory;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryInfo;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecUpgradeFacadeFactory;
import com.kingdee.eas.el.rec.RecordBaseCollectImplType;
import com.kingdee.eas.el.rec.RecordBaseCollection;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.RptDetailType;
import com.kingdee.eas.el.rec.filing.instance.AbstractMergeFilingReport;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FilingQmsReport
extends AbstractMergeFilingReport {
    private static Logger logger = Logger.getLogger(FilingQmsReport.class);
    protected Map<String, TemplateInfo> templateCacheMap = new HashMap<String, TemplateInfo>();

    @Override
    protected List<OrgStructureInfo> getOrgStructureList(Context ctx, ArchSchemeInfo asInfo, PeriodInfo periodInfo) throws RecException {
        PeriodCollection periods = this.getPeriodsForReport(ctx, asInfo, null, null);
        List<Object> orgStructureList = new ArrayList<OrgStructureInfo>();
        try {
            List<TemplateInfo> templateList = new ArrayList();
            ReportCycleType reportCycleType = asInfo.getReportCycleType();
            RptPeriodTypeEnum rptPeriodTypeEnum = FilingUtils.convertToRptEnum(reportCycleType);
            if (periods == null || periods.size() <= 0) {
                logger.error((Object)"\u7ba1\u7406\u5408\u5e76\u62a5\u8868\u83b7\u53d6\u671f\u95f4\u4e3a\u7a7a\u6216\u8005size\u4e3a0");
                return orgStructureList;
            }
            Class<?> cla = Class.forName("com.kingdee.eas.fi.newrpt.util.MergeReportHandlerImp");
            Method method = cla.getMethod("getOrgStructureInfoAndTemplate", Context.class, String.class, PeriodInfo.class, RptPeriodTypeEnum.class);
            Map otMap = (Map)method.invoke(cla.newInstance(), ctx, asInfo.getMergeScheme().getId() + "", periods.get(0), rptPeriodTypeEnum);
            orgStructureList = (List)otMap.get("orgs");
            templateList = (List)otMap.get("templates");
            if (orgStructureList == null || orgStructureList.size() == 0) {
                logger.error((Object)("asInfo:[" + asInfo.getId() + "];orgStructureList is null or size=0"));
                return orgStructureList;
            }
            if (templateList == null || templateList.size() == 0) {
                logger.error((Object)("asInfo:[" + asInfo.getId() + "];templateList is null or size=0"));
                return orgStructureList;
            }
            this.generateContentEntryColl(ctx, asInfo, templateList);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u5408\u5e76\u5355\u5143\u5f02\u5e38"});
        }
        try {
            RecUpgradeFacadeFactory.getLocalInstance(ctx).upgradeOutputXMLTemplate(null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return orgStructureList;
    }

    @Override
    protected StringBuilder getArcRecordNum(ArchSchemeInfo asInfo, OrgStructureInfo orgStructureInfo, CurrencyInfo currencyInfo, PeriodInfo periodInfo, RecordBaseInfo archContent) {
        StringBuilder arcRecordNum = new StringBuilder();
        arcRecordNum.append(archContent.getNumber());
        arcRecordNum.append("_").append(this.getOrgNumberByLongNumber(orgStructureInfo.getLongNumber()));
        arcRecordNum.append("-").append(archContent.getReportCycleType().getValue());
        arcRecordNum.append("_").append(periodInfo.getNumber());
        arcRecordNum.append("_").append(asInfo.getMergeScheme().getNumber());
        arcRecordNum.append("_").append(currencyInfo.getIsoCode());
        return arcRecordNum;
    }

    private String getOrgNumberByLongNumber(String longNumber) {
        String[] split = longNumber.split("!");
        int index = split.length - 1;
        return split[index];
    }

    private ArcheSchemeContentEntryCollection generateContentEntryColl(Context ctx, ArchSchemeInfo asInfo, List<TemplateInfo> templateList) throws BOSException, EASBizException {
        for (TemplateInfo templateInfo : templateList) {
            this.templateCacheMap.put(templateInfo.getId() + "", templateInfo);
        }
        ArcheSchemeContentEntryCollection entryColls = asInfo.getArchemeContent();
        if (entryColls != null && entryColls.size() > 0) {
            return entryColls;
        }
        entryColls = new ArcheSchemeContentEntryCollection();
        for (TemplateInfo templateInfo : templateList) {
            RecordBaseInfo recordBaseInfo = this.genRecordBase(ctx, templateInfo);
            ArcheSchemeContentEntryInfo entryInfo = new ArcheSchemeContentEntryInfo();
            entryInfo.setArchScheme(asInfo);
            entryInfo.setArchContent(recordBaseInfo);
            entryColls.add(entryInfo);
        }
        asInfo.getArchemeContent().addCollection(entryColls);
        ArchSchemeInfo archSchemeInfo = ArchSchemeFactory.getLocalInstance(ctx).getArchSchemeInfo(H.PK(asInfo.getId().toString()));
        archSchemeInfo.getArchemeContent().addCollection(entryColls);
        ArchSchemeFactory.getLocalInstance(ctx).save((CoreBaseInfo)archSchemeInfo);
        return entryColls;
    }

    private RecordBaseInfo genRecordBase(Context ctx, TemplateInfo templateInfo) throws BOSException, EASBizException {
        RecordBaseInfo recordBaseInfo = this.getRecordBase(ctx, templateInfo);
        if (recordBaseInfo != null) {
            return recordBaseInfo;
        }
        recordBaseInfo = new RecordBaseInfo();
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setName(templateInfo.getName() + "_" + templateInfo.getTemplateType().getAlias());
        billTypeInfo.setNumber(templateInfo.getNumber() + "_" + templateInfo.getTemplateType().getValue());
        billTypeInfo.setPeriodSys("8");
        billTypeInfo.setBill(false);
        billTypeInfo.setId(BOSUuid.create((String)"873D88CE"));
        BillTypeFactory.getLocalInstance(ctx).save((CoreBaseInfo)billTypeInfo);
        recordBaseInfo.setBillType(billTypeInfo);
        recordBaseInfo.setNumber(templateInfo.getNumber() + "_" + templateInfo.getTemplateType().getValue());
        recordBaseInfo.setName(templateInfo.getName() + "_" + templateInfo.getTemplateType().getAlias());
        recordBaseInfo.setExportFileType(".xls");
        recordBaseInfo.setCollectImpl("com.kingdee.eas.el.rec.tool.engine.CslReportParsingEngineUtil");
        recordBaseInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        recordBaseInfo.setRecordType(ArcContentTypeEnum.QmsReport);
        recordBaseInfo.setIsRefBill(false);
        recordBaseInfo.setPrintTemplateName(templateInfo.getName());
        recordBaseInfo.setPrintTemplate(templateInfo.getId().toString());
        recordBaseInfo.setCollectImplType(RecordBaseCollectImplType.BASEREPORT);
        recordBaseInfo.setReportCycleType(FilingUtils.convertToRecEnum(templateInfo.getPeriodType()));
        recordBaseInfo.setXmlDocType(FilingUtils.getXMLDocType(recordBaseInfo.getReportCycleType()));
        recordBaseInfo.setRptDetailType(RptDetailType.HBBB);
        recordBaseInfo.setId(BOSUuid.create((String)"CB408C6F"));
        String outputXmlTemplate = this.genOutputXMLTemplate(ctx, billTypeInfo, recordBaseInfo);
        recordBaseInfo.setOutPutXMLTemplate(outputXmlTemplate);
        RecordBaseFactory.getLocalInstance(ctx).save((CoreBaseInfo)recordBaseInfo);
        return recordBaseInfo;
    }

    private String genOutputXMLTemplate(Context ctx, BillTypeInfo billTypeInfo, RecordBaseInfo recordBaseInfo) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("field-mapping");
        Element billtype = root.addElement("billtype");
        billtype.addText(recordBaseInfo.getName());
        Element doctype = root.addElement("doctype");
        doctype.addText(FilingUtils.getXMLDocType(recordBaseInfo.getReportCycleType()));
        Element desc = root.addElement("desc");
        desc.addText(recordBaseInfo.getName());
        Element rule_list = root.addElement("rule-list");
        Element rule1 = rule_list.addElement("rule");
        Element srcfield1 = rule1.addElement("srcfield");
        Element destfield1 = rule1.addElement("destfield");
        srcfield1.addText("orgBound.number");
        destfield1.addText("voucherorgnumber");
        Element rule2 = rule_list.addElement("rule");
        Element srcfield2 = rule2.addElement("srcfield");
        Element destfield2 = rule2.addElement("destfield");
        srcfield2.addText("orgBound.name");
        destfield2.addText("voucherorgname");
        Element rule3 = rule_list.addElement("rule");
        Element srcfield3 = rule3.addElement("srcfield");
        Element destfield3 = rule3.addElement("destfield");
        srcfield3.addText("orgBound.name");
        destfield3.addText("voucherorgname");
        Element rule4 = rule_list.addElement("rule");
        Element srcfield4 = rule4.addElement("srcfield");
        Element destfield4 = rule4.addElement("destfield");
        srcfield4.addText("currency.number");
        destfield4.addText("currency");
        Element rule5 = rule_list.addElement("rule");
        Element srcfield5 = rule5.addElement("srcfield");
        Element destfield5 = rule5.addElement("destfield");
        srcfield5.addText("template.name");
        destfield5.addText("reporttype");
        Element rule7 = rule_list.addElement("rule");
        Element srcfield7 = rule7.addElement("srcfield");
        Element destfield7 = rule7.addElement("destfield");
        srcfield7.addText("template.number");
        destfield7.addText("templatenumber");
        Element rule8 = rule_list.addElement("rule");
        Element srcfield8 = rule8.addElement("srcfield");
        Element destfield8 = rule8.addElement("destfield");
        srcfield8.addText("number");
        destfield8.addText("reportnumber");
        Element rule9 = rule_list.addElement("rule");
        Element srcfield9 = rule9.addElement("srcfield");
        Element destfield9 = rule9.addElement("destfield");
        srcfield9.addText("name");
        destfield9.addText("reportname");
        Element rule10 = rule_list.addElement("rule");
        Element srcfield10 = rule10.addElement("srcfield");
        Element destfield10 = rule10.addElement("destfield");
        srcfield10.addText("year");
        destfield10.addText("year");
        Element rule11 = rule_list.addElement("rule");
        Element srcfield11 = rule11.addElement("srcfield");
        Element destfield11 = rule11.addElement("destfield");
        srcfield11.addText("period");
        destfield11.addText("periodnum");
        Element rule6 = rule_list.addElement("rule");
        Element srcfield6 = rule6.addElement("srcfield");
        Element format6 = rule6.addElement("format");
        Element destfield6 = rule6.addElement("destfield");
        srcfield6.addText("year,period");
        format6.addText("{\"expr\":\"formatStr(append(#0,{-},#1),{nnnn-nn})\"}");
        destfield6.addText("period");
        String xmlDoc = doc.asXML();
        logger.error((Object)xmlDoc);
        return xmlDoc;
    }

    private RecordBaseInfo getRecordBase(Context ctx, TemplateInfo templateInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(templateInfo.getNumber() + "_" + templateInfo.getTemplateType().getValue())));
        viewInfo.setFilter(filter);
        RecordBaseCollection coll = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }
}

