/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryCollection;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.TaskLogFactory;
import com.kingdee.eas.el.rec.TaskLogInfo;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.app.util.RECCacheManager;
import com.kingdee.eas.el.rec.tool.BillHandlerProxy;
import com.kingdee.eas.el.rec.tool.DefaultBillHandler;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.PermissionOrgUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FilingUtils {
    private static Logger logger = Logger.getLogger(FilingUtils.class);

    public static RptPeriodTypeEnum convertToRptEnum(ReportCycleType reportCycleType) {
        RptPeriodTypeEnum ret = null;
        if (ReportCycleType.MONTH.equals((Object)reportCycleType)) {
            ret = RptPeriodTypeEnum.MONTHLY;
        } else if (ReportCycleType.QUARTER.equals((Object)reportCycleType)) {
            ret = RptPeriodTypeEnum.QUARTERLY;
        } else if (ReportCycleType.SEMIANNUAL.equals((Object)reportCycleType)) {
            ret = RptPeriodTypeEnum.SEMIYEARLY;
        } else if (ReportCycleType.ANNUAL.equals((Object)reportCycleType)) {
            ret = RptPeriodTypeEnum.YEARLY;
        }
        return ret;
    }

    public static Map<String, RecordBaseInfo> getContents(Context ctx, ArcheSchemeContentEntryCollection contents, RecordBaseInfo content, CompanyOrgUnitInfo org) {
        HashMap<String, RecordBaseInfo> contentMap = new HashMap<String, RecordBaseInfo>();
        for (int i = 0; i < contents.size(); ++i) {
            RecordBaseInfo realContent;
            RecordBaseInfo recordBaseInfo = contents.get(i).getArchContent();
            if (!recordBaseInfo.isIsRefBill() || !recordBaseInfo.getRefMainBill().getId().equals((Object)content.getId()) || null == (realContent = FilingUtils.getContent(ctx, recordBaseInfo, org))) continue;
            realContent.setRefMainBill(content);
            contentMap.put(recordBaseInfo.getId().toString(), realContent);
        }
        return contentMap;
    }

    public static CompanyOrgUnitCollection getCompanyOrgs(Context ctx, ArchSchemeScopeOrgEntryCollection orgs, boolean onlyBizUnit, String EASUserId, String permissionNumber) throws BOSException, EASBizException {
        Set<String> set = PermissionOrgUtil.getHasPermissionOrg(ctx, EASUserId, permissionNumber);
        CompanyOrgUnitCollection corgs = new CompanyOrgUnitCollection();
        int size = orgs.size();
        for (int j = 0; j < size; ++j) {
            CompanyOrgUnitCollection collection;
            if (orgs.get(j).isContainSub() && (collection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("select *, baseCurrency.* where longNumber like '" + orgs.get(j).getOrg().getLongNumber() + "!%'")) != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    CompanyOrgUnitInfo ouInfo = collection.get(i);
                    if (set == null || set.size() == 0 || !set.contains(ouInfo.getId() + "") || onlyBizUnit && (!onlyBizUnit || !ouInfo.isIsBizUnit())) continue;
                    corgs.add(ouInfo);
                }
            }
            if (onlyBizUnit && (!onlyBizUnit || !orgs.get(j).getOrg().isIsBizUnit())) continue;
            corgs.add(orgs.get(j).getOrg());
        }
        return corgs;
    }

    public static ReportCycleType convertToRecEnum(RptPeriodTypeEnum periodType) {
        if (periodType.getValue() == 3) {
            return ReportCycleType.MONTH;
        }
        if (periodType.getValue() == 4) {
            return ReportCycleType.QUARTER;
        }
        if (periodType.getValue() == 5) {
            return ReportCycleType.SEMIANNUAL;
        }
        if (periodType.getValue() == 6) {
            return ReportCycleType.ANNUAL;
        }
        return ReportCycleType.MONTH;
    }

    public static String getXMLDocType(ReportCycleType reportCycleType) {
        if ("MONTH".equalsIgnoreCase(reportCycleType.getValue())) {
            return "monthReport";
        }
        if ("QUARTER".equalsIgnoreCase(reportCycleType.getValue())) {
            return "quarterReport";
        }
        if ("SEMIANNUAL".equalsIgnoreCase(reportCycleType.getValue())) {
            return "bannianReport";
        }
        if ("ANNUAL".equalsIgnoreCase(reportCycleType.getValue())) {
            return "annualReport";
        }
        return "monthReport";
    }

    public static String getReportArcRecordNum(Context ctx, RecordBaseInfo rbInfo, String companyNumber, String periodNum, String currencyISONumber) {
        StringBuffer buffer = FilingUtils.getArcRecordNum(ctx, rbInfo, companyNumber, periodNum);
        buffer.append("_").append(currencyISONumber);
        return buffer.toString();
    }

    public static StringBuffer getArcRecordNum(Context ctx, RecordBaseInfo rbInfo, String companyNumber, String periodNum) {
        StringBuffer buffer = new StringBuffer(500);
        buffer.append(rbInfo.getBillType().getNumber());
        buffer.append("_").append(companyNumber);
        buffer.append("_").append(periodNum);
        return buffer;
    }

    public static String getReportArcRecordNum(Context ctx, RecordBaseInfo rbInfo, String companyNumber, String periodNum, String currencyISONumber, String reportCycleType) {
        StringBuffer buffer = new StringBuffer(500);
        buffer.append(rbInfo.getBillType().getNumber());
        buffer.append("_").append(companyNumber);
        if (!StringUtils.isEmpty((String)reportCycleType)) {
            buffer.append("_").append(reportCycleType);
        }
        buffer.append("_").append(periodNum);
        buffer.append("_").append(currencyISONumber);
        return buffer.toString();
    }

    public static RecordBaseInfo getContent(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org) {
        String sql = "SELECT FID FROM T_ORG_COMPANY where FID = ? and charindex(FLONGNUMBER,?) > 0 ";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{content.getOrg().getId().toString(), org.getLongNumber()});
            if (executeQuery.next()) {
                if (content.getRecordType().equals((Object)ArcContentTypeEnum.BILL)) {
                    return FilingUtils.getCustomeContent(ctx, content, content.getOrg().getLongNumber(), org.getLongNumber());
                }
                return content;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u5224\u65ad\u5f52\u6863\u7ec4\u7ec7\u53ca\u5b83\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u6709\u6ca1\u6709\u521b\u5efa\u6b21\u5f52\u6863\u5185\u5bb9\u51fa\u9519", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u5224\u65ad\u5f52\u6863\u7ec4\u7ec7\u53ca\u5b83\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u6709\u6ca1\u6709\u521b\u5efa\u6b21\u5f52\u6863\u5185\u5bb9\u51fa\u9519", (Throwable)e);
        }
        return content;
    }

    private static RecordBaseInfo getCustomeContent(Context ctx, RecordBaseInfo recordBaseInfo, String creatorLongNumber, String archLongNumber) {
        HashSet<String> set = new HashSet<String>();
        set.add(archLongNumber);
        while (archLongNumber.indexOf(creatorLongNumber) > -1 && !creatorLongNumber.equals(archLongNumber) && archLongNumber.lastIndexOf("!") > -1) {
            archLongNumber = archLongNumber.substring(0, archLongNumber.lastIndexOf("!"));
            set.add(archLongNumber);
        }
        set.add(creatorLongNumber);
        String sql = "SELECT T1.FPrintTemplate, T1.FPrintTemplateName, T2.FLONGNUMBER, T2.FLEVEL, T1.FID, T1.FORGID FROM T_REC_RECORDBASEEXTEND  T1 inner join T_ORG_COMPANY T2 on T1.FRecordBaseId = ? and T2.FID = T1.FORGID and T2.FLONGNUMBER IN " + FormatUtils.list2Sql(set) + " and T1.FPrintTemplate is not null order by T2.FLEVEL desc";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{recordBaseInfo.getId().toString()});
            if (executeQuery.next()) {
                RecordBaseInfo recordBaseInfoCutom = (RecordBaseInfo)recordBaseInfo.clone();
                recordBaseInfoCutom.setPrintTemplate(executeQuery.getString(1));
                recordBaseInfoCutom.setPrintTemplateName(executeQuery.getString(2));
                return recordBaseInfoCutom;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u7684\u5957\u6253\u76ee\u6807\u51fa\u9519", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u7684\u5957\u6253\u76ee\u6807\u51fa\u9519", (Throwable)e);
        }
        return recordBaseInfo;
    }

    public static CompanyOrgUnitCollection getAllParentCompanyOrgs(Context ctx, String orgId, boolean onlyBizUnit) throws BOSException, EASBizException {
        CompanyOrgUnitCollection corgs = new CompanyOrgUnitCollection();
        CompanyOrgUnitInfo companyOrgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        corgs.add(companyOrgInfo);
        int i = 0;
        do {
            if ((companyOrgInfo = FilingUtils.getParentCompanyOrgInfo(ctx, companyOrgInfo.getId().toString())) == null) continue;
            if (onlyBizUnit) {
                if (!companyOrgInfo.isIsBizUnit()) continue;
                corgs.add(companyOrgInfo);
                continue;
            }
            corgs.add(companyOrgInfo);
        } while (companyOrgInfo != null && companyOrgInfo.getParent() != null && ++i < 15);
        return corgs;
    }

    private static CompanyOrgUnitInfo getParentCompanyOrgInfo(Context ctx, String orgId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select parent.* where id = '" + orgId + "'");
        return companyOrgUnitInfo.getParent();
    }

    public static IBillHandler getBillHandler(Context ctx, RecordBaseInfo content) throws EASDBException, EASBizException, BOSException {
        BillTypeInfo billType = content.getBillType();
        if (content.isIsRefBill()) {
            RecordBaseInfo mainContent = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo("select billType.* where id = '" + content.getRefMainBill().getId() + "'");
            billType = mainContent.getBillType();
            content.setRefMainBill(mainContent);
        }
        String bosType = billType.getBosType();
        String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, IBillHandler.class);
        IBillHandler billHandler = new DefaultBillHandler();
        if (null == checkers || checkers.length == 0) {
            logger.error((Object)(billType.getNumber() + "\u5355\u636e\u7684\u671f\u95f4\u67e5\u8be2\u4e3b\u5355\u636eids\u65f6,\u53d1\u73b0\u5355\u636e\u6ca1\u6709\u5b9e\u73b0com.kingdee.eas.el.rec.tool.IBillHandler\uff01"));
        } else {
            try {
                Class<?> cla = Class.forName(checkers[0]);
                billHandler = (IBillHandler)cla.newInstance();
            }
            catch (Exception e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6 IBillHandler[" + checkers[0] + "]\u5f02\u5e38"});
            }
        }
        BillHandlerProxy billHandlerProxy = new BillHandlerProxy(ctx, billHandler);
        return billHandlerProxy;
    }

    public static Object deeplyCopy(Serializable obj) throws RecException {
        try {
            return FilingUtils.bytes2object(FilingUtils.object2bytes(obj));
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage()});
        }
    }

    private static byte[] object2bytes(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object bytes2object(byte[] bytes) throws IOException, ClassNotFoundException {
        Object var3;
        try (ObjectInputStream ois = null;){
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            var3 = ois.readObject();
        }
        return var3;
    }

    public static void updateFailNum(Context ctx, RecordBaseInfo recordBaseInfo, String recordId, int num) {
        StringBuilder sb = new StringBuilder("update T_REC_ARCRECORD set FLastUpdateTime = now(),");
        if (recordBaseInfo.isIsRefBill()) {
            sb.append("FAttachFailNum = FAttachFailNum +?");
        } else {
            sb.append("FailNum = FailNum +?");
        }
        sb.append(" where FID = ?");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{num, recordId});
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateProgress(Context ctx, String recordId, int num) throws BOSException {
        String sql = "update t_rec_ArcRecord set FTotalNum = FTotalNum-" + num + " where fid = '" + recordId + "' and FTotalNum >= " + num;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static void updateRecordPartial(Context ctx, ArcRecordInfo recordInfo, String ... property) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        String lastUpdateTimePro = "lastUpdateTime";
        for (int i = 0; i < property.length; ++i) {
            if (lastUpdateTimePro.equals(property[i])) continue;
            selectorItemCollection.add(property[i]);
        }
        recordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        selectorItemCollection.add(lastUpdateTimePro);
        ArcRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selectorItemCollection);
    }

    public static void deleteTempFile(File[] files) {
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            files[i].getAbsoluteFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createTempFile(Context ctx, InputStream is, String fileName) throws Exception {
        File tempFile = File.createTempFile("tempFile", fileName.substring(fileName.lastIndexOf(".")));
        tempFile.deleteOnExit();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(tempFile);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            ((OutputStream)os).write(buffer);
        }
        catch (Throwable throwable) {
            FilingUtils.safeClose(os);
            throw throwable;
        }
        FilingUtils.safeClose(os);
        ctx.put((Object)"tempFile", (Object)tempFile.getAbsolutePath());
        return new FileInputStream(tempFile);
    }

    public static void deleteTempFile(Context ctx) {
        File file;
        String tempFile = (String)ctx.get((Object)"tempFile");
        if (!"nulll".equals(tempFile) && !StringUtils.isEmpty((String)tempFile) && (file = new File(tempFile)).exists()) {
            file.getAbsoluteFile().delete();
        }
        ctx.remove((Object)"tempFile");
    }

    public static void safeClose(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static void safeClose(OutputStream os) {
        if (null != os) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static void dumpRecords(Context ctx, String periodNumber, ArcRecordCollection arcRecordCollection) throws BOSException, EASBizException {
        String dumpAttchArclogSql = FilingUtils.getDumpAttchArclogSql();
        String dumpDetailArclogSql = FilingUtils.getDumpDetailArclogSql();
        String dumpAttchSql = FilingUtils.getDumpAttchSql();
        String dumpDetailSql = FilingUtils.getDumpDetailSql();
        String dlAttchArclogSql = "delete from t_rec_arclog T1 where exists (select 1 from T_REC_ATTACHBILLACHDETAIL T2 where exists (select 1 from T_REC_AchRecordDetail T3 where T3.FID = T2.FAchRecordDetailID and T3.FArcRecordID=?) and T1.FBillRefId = T2.FID)";
        String dlDetailArclogSql = "delete from t_rec_arclog T1 where exists (select 1 from T_REC_AchRecordDetail T3 where T3.FArcRecordID= ? and T1.FBillRefId = T3.FID)";
        String dlAttchSql = "delete from T_REC_AttachBillAchDetail T1 where exists( SELECT FID FROM T_REC_ACHRECORDDETAIL T2 where T2.FARCRECORDID =? and T1.FACHRECORDDETAILID = T2.FID)";
        String dlDetailSql = "delete from T_REC_ACHRECORDDETAIL where FARCRECORDID = ?";
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        for (int i = 0; i < arcRecordCollection.size(); ++i) {
            ArcRecordInfo arcRecordInfo = arcRecordCollection.get(i);
            if (!ArcStateEnum.ARC_SUCCESS.equals((Object)arcRecordInfo.getState()) && !ArcStateEnum.ARC_FAIL.equals((Object)arcRecordInfo.getState())) continue;
            String arcRecordInfoId = arcRecordInfo.getId().toString();
            Long t1 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)dumpAttchArclogSql, (Object[])new Object[]{arcRecordInfoId});
            Long t2 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)dumpDetailArclogSql, (Object[])new Object[]{arcRecordInfoId});
            Long t3 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)dumpAttchSql, (Object[])new Object[]{arcRecordInfoId});
            Long t4 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)dumpDetailSql, (Object[])new Object[]{arcRecordInfoId});
            Long t5 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)dlAttchArclogSql, (Object[])new Object[]{arcRecordInfoId});
            DbUtil.execute((Context)ctx, (String)dlDetailArclogSql, (Object[])new Object[]{arcRecordInfoId});
            Long t6 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)dlAttchSql, (Object[])new Object[]{arcRecordInfoId});
            DbUtil.execute((Context)ctx, (String)dlDetailSql, (Object[])new Object[]{arcRecordInfoId});
            Long t7 = System.currentTimeMillis();
            TaskLogInfo takloginfo = new TaskLogInfo();
            takloginfo.setRecord(arcRecordInfoId);
            takloginfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            takloginfo.setServerNum(easInstanceHome.substring(easInstanceHome.lastIndexOf("/") + 1));
            takloginfo.setTime1(t2 - t1);
            takloginfo.setTime2(t3 - t2);
            takloginfo.setTime3(t4 - t3);
            takloginfo.setTime4(t5 - t4);
            takloginfo.setTime5(t6 - t5);
            takloginfo.setTime6(t7 - t6);
            TaskLogFactory.getLocalInstance(ctx).addnew(takloginfo);
        }
        DbUtil.execute((Context)ctx, (String)"update T_REC_ArchConfigValue set FValue = ? where FKey = ?", (Object[])new Object[]{periodNumber, ArchConstant.ARCH_DATADUMP_PERIOD});
        DbUtil.execute((Context)ctx, (String)"update T_REC_ArchConfigKey set FDefaultValue = ? where FKey = ?", (Object[])new Object[]{RECCacheManager.getDateFormatStr(), "arch.config.lastupdatetime"});
    }

    private static String getDumpAttchArclogSql() {
        String colums = "FChangeTime,FResult,FOperatorIDID,FMessage,FStack,FBillId,FBillNumber,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FBillRefid,FID";
        StringBuilder sqlBuilder = new StringBuilder("insert into t_rec_arclogHis (").append(colums).append(") ");
        sqlBuilder.append("select ").append(colums).append(" from t_rec_arclog T1 where exists (select 1 from T_REC_ATTACHBILLACHDETAIL T2 where exists (select 1 from T_REC_AchRecordDetail T3 where T3.FID = T2.FAchRecordDetailID and T3.FArcRecordID = ?) and T1.FBillRefId = T2.FID)");
        return sqlBuilder.toString();
    }

    private static String getDumpDetailArclogSql() {
        String colums = "FChangeTime,FResult,FOperatorIDID,FMessage,FStack,FBillId,FBillNumber,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FBillRefid,FID";
        StringBuilder sqlBuilder = new StringBuilder("insert into t_rec_arclogHis (").append(colums).append(") ");
        sqlBuilder.append("select ").append(colums).append(" from t_rec_arclog T1 where exists (select 1 from T_REC_AchRecordDetail T3 where T3.FArcRecordID = ? and T1.FBillRefId = T3.FID)");
        return sqlBuilder.toString();
    }

    private static String getDumpAttchSql() {
        String colums = "FBillId,FAchRecordDetailID,FBillNumber,FState,FOriginsBillId,FArcContentID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID";
        StringBuilder sqlBuilder = new StringBuilder("insert into T_REC_AttachBillAchDetailHis (").append(colums).append(")");
        sqlBuilder.append("select ").append(colums).append(" from T_REC_AttachBillAchDetail T1 where exists( SELECT FID FROM T_REC_ACHRECORDDETAIL T2 where T2.FARCRECORDID = ? and T1.FACHRECORDDETAILID = T2.FID)");
        return sqlBuilder.toString();
    }

    private static String getDumpDetailSql() {
        String colums = "FBillId,FBillNumber,FState,FRecordBaseInstID,FArcRecordID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID,FOriginBillState";
        StringBuilder sqlBuilder = new StringBuilder("insert into T_REC_ACHRECORDDETAILHis (").append(colums).append(")");
        sqlBuilder.append("select ").append(colums).append(" from T_REC_ACHRECORDDETAIL where FARCRECORDID =?");
        return sqlBuilder.toString();
    }
}

