/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.AchRecordDetailCollection;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailInfo;
import com.kingdee.eas.el.rec.OperationEnum;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.IDUtils;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArchInfos {
    private Context ctx;
    private ArchSchemeInfo asInfo;
    private RecordBaseInfo content;
    private CompanyOrgUnitInfo org;
    private PeriodInfo periodInfo;
    private int period;
    private List<XmlBase> mainBills = new ArrayList<XmlBase>();
    private ArcContentTypeEnum arcContentType;
    private Map<String, List<XmlBase>> refBills;
    private Map<String, RecordBaseInfo> contents;
    private String arcRecordId;
    private static Logger logger = Logger.getLogger((String)ArchInfos.class.getName());

    public int size() {
        if (null == this.mainBills) {
            return 0;
        }
        int size = this.mainBills.size();
        for (String key : this.refBills.keySet()) {
            size += this.refBills.get(key).size();
        }
        return size;
    }

    public int arcSize() {
        if (null == this.mainBills) {
            return 0;
        }
        int size = this.getArcSize(this.mainBills);
        for (String key : this.refBills.keySet()) {
            size += this.getArcSize(this.refBills.get(key));
        }
        return size;
    }

    public int voucherSize() {
        if (null == this.mainBills) {
            return 0;
        }
        return this.mainBills.size();
    }

    public int originVcSize() {
        int size = 0;
        for (String key : this.refBills.keySet()) {
            size += this.refBills.get(key).size();
        }
        return size;
    }

    public int afreshVoucherSize() {
        if (null == this.mainBills) {
            return 0;
        }
        return this.getSize(this.mainBills);
    }

    private int getSize(List<XmlBase> list) {
        int size = 0;
        for (XmlBase base : list) {
            ArchInfo info = (ArchInfo)base;
            if (null == info.getReArchFlag() || !ArchFlagEnum.ADDNEW.equals((Object)info.getReArchFlag())) continue;
            ++size;
        }
        return size;
    }

    private int getArcSize(List<XmlBase> list) {
        int size = 0;
        for (XmlBase base : list) {
            ArchInfo info = (ArchInfo)base;
            if (null == info.getReArchFlag()) continue;
            ++size;
        }
        return size;
    }

    public int afreshOriginVcSize() {
        int size = 0;
        for (String key : this.refBills.keySet()) {
            size += this.getSize(this.refBills.get(key));
        }
        return size;
    }

    public ArchInfos(Context ctx) {
        this.ctx = ctx;
    }

    public void increaseNumber(Context ctx, ArcRecordInfo recordInfo) {
        recordInfo.setVoucherNum(recordInfo.getVoucherNum() + this.afreshVoucherSize());
        recordInfo.setOriginVcNum(recordInfo.getOriginVcNum() + this.afreshOriginVcSize());
        recordInfo.setFailNum(0);
        recordInfo.setAttachFailNum(0);
        recordInfo.setTotalNum(this.arcSize());
    }

    public ArchInfos(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org, PeriodInfo periodInfo, Map<String, RecordBaseInfo> recordMap) {
        this.ctx = ctx;
        this.asInfo = asInfo;
        this.content = content;
        this.org = org;
        this.arcContentType = ArcContentTypeEnum.BILL;
        this.periodInfo = periodInfo;
        this.period = periodInfo.getNumber();
        this.refBills = new HashMap<String, List<XmlBase>>();
        this.contents = recordMap;
        for (String rbInfoId : this.contents.keySet()) {
            this.refBills.put(rbInfoId, new ArrayList());
        }
    }

    public void currentPeriodInit(Context ctx, RecordBaseInfo content, Map<String, IObjectValue> mainBillInfos, PeriodInfo period, OperationEnum operation) throws BOSException {
        if (null == mainBillInfos) {
            return;
        }
        ArrayList<XmlBase> mainArchInfos = new ArrayList<XmlBase>();
        Iterator<String> it = mainBillInfos.keySet().iterator();
        try {
            while (it.hasNext()) {
                String billID = it.next();
                ArchInfo info = ArchUtils.getCurrentPeriodArchInfo(ctx, billID, null, this);
                if (null == info) continue;
                info.setDocType(content.getXmlDocType());
                info.setBillNumber(mainBillInfos.get(billID).getString("number"));
                mainArchInfos.add(info);
            }
            if (this.contents.size() != 0) {
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)this.arcRecordId));
                arcRecordInfo.setContent(content);
                ArchUtils.mutilSetRefArchInfos(ctx, arcRecordInfo, mainArchInfos, this.contents, operation);
                for (int i = mainArchInfos.size() - 1; i >= 0; --i) {
                    ArchInfo mainArchInfo = (ArchInfo)mainArchInfos.get(i);
                    for (ArchInfo refInfo : mainArchInfo.getRefInfo()) {
                        if (null != refInfo.getReArchFlag()) {
                            this.setRefBill(refInfo.getRecordBaseId(), refInfo);
                        }
                        if (refInfo.getArchInfos() != null) continue;
                        refInfo.setArchInfos(this);
                    }
                    if (null != mainArchInfo.getReArchFlag()) continue;
                    mainArchInfos.remove(i);
                }
            }
            if (operation == OperationEnum.FIRST_ARC) {
                ArchUtils.saveAchRecordDetail(ctx, mainArchInfos, this.arcRecordId);
            }
            this.mainBills = mainArchInfos;
            if (operation != OperationEnum.FIRST_ARC) {
                ArchUtils.saveAchRecordDetail(ctx, mainArchInfos, this.arcRecordId);
            }
            ArchUtils.currentPeriodInitArchNumCache(ctx, this.arcRecordId, this, operation);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    public void init(Context ctx, RecordBaseInfo content, Map<String, IObjectValue> mainBillInfos, PeriodInfo period, OperationEnum operation) throws BOSException {
        if (null == mainBillInfos) {
            return;
        }
        ArrayList<XmlBase> mainArchInfos = new ArrayList<XmlBase>();
        Iterator<String> it = mainBillInfos.keySet().iterator();
        try {
            while (it.hasNext()) {
                String billID = it.next();
                ArchInfo info = ArchUtils.getArchInfo(ctx, billID, null, operation, this);
                if (null == info) continue;
                info.setDocType(content.getXmlDocType());
                info.setBillNumber(mainBillInfos.get(billID).getString("number"));
                mainArchInfos.add(info);
            }
            if (this.contents.size() != 0) {
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)this.arcRecordId));
                arcRecordInfo.setContent(content);
                ArchUtils.mutilSetRefArchInfos(ctx, arcRecordInfo, mainArchInfos, this.contents, operation);
                for (int i = mainArchInfos.size() - 1; i >= 0; --i) {
                    ArchInfo mainArchInfo = (ArchInfo)mainArchInfos.get(i);
                    for (ArchInfo refInfo : mainArchInfo.getRefInfo()) {
                        if (null != refInfo.getReArchFlag()) {
                            this.setRefBill(refInfo.getRecordBaseId(), refInfo);
                        }
                        if (refInfo.getArchInfos() != null) continue;
                        refInfo.setArchInfos(this);
                    }
                    if (null != mainArchInfo.getReArchFlag()) continue;
                    mainArchInfos.remove(i);
                }
            }
            if (this.mainBills == null) {
                this.mainBills = new ArrayList<XmlBase>();
            }
            this.mainBills.addAll(mainArchInfos);
            logger.error((Object)("this.mainBills:" + this.mainBills.size()));
            ArchUtils.saveAchRecordDetail(ctx, this.mainBills, this.arcRecordId);
            if (operation == OperationEnum.AFRESH_ARC) {
                ArchUtils.handDelteArchInfo(ctx, this, this.contents, content);
            }
            ArchUtils.initArchNumCache(ctx, this.arcRecordId, this, operation);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            if (this.mainBills == null) {
                this.mainBills = new ArrayList<XmlBase>();
            }
            this.mainBills.addAll(mainArchInfos);
            ArchRecordUtils.writeLogs(ctx, this.mainBills, this.arcRecordId, new Exception("\u83b7\u53d6\u9644\u5c5e\u5355\u636e\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), e));
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(this.arcRecordId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
            throw new BOSException((Throwable)e);
        }
    }

    public void upload() throws EASBizException, BOSException {
        logger.error((Object)("\u5355\u636e\u6570\u76ee:" + this.content.getNumber() + ":" + this.mainBills.size()));
        String taskFlag = IDUtils.getId();
        ThreadUtil.addLock(taskFlag);
        ArchUtils.uploadArchInfos(this.ctx, this.content, this.periodInfo, this.org, this.mainBills, taskFlag, "main", this.arcRecordId);
        if (this.contents.size() != 0) {
            int i = 0;
            for (String refBosType : this.refBills.keySet()) {
                if (0 == this.refBills.get(refBosType).size()) continue;
                RecordBaseInfo refContent = this.contents.get(refBosType);
                List<Object> refArchInfos = new ArrayList();
                refArchInfos = this.refBills.get(refBosType);
                logger.error((Object)("\u5355\u636e\u6570\u76ee:" + refContent.getNumber() + ":" + refArchInfos.size()));
                ArchUtils.uploadArchInfos(this.ctx, refContent, this.periodInfo, this.org, refArchInfos, taskFlag, i + "-sub", this.arcRecordId);
                ++i;
            }
        }
    }

    public void arcFailed(Context ctx, String recordId) throws BOSException {
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("arcRecord", (Object)recordId));
            entityViewInfo.setFilter(filter);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("*");
            selectorItemCollection.add("attachBillAchDetails.state");
            selectorItemCollection.add("attachBillAchDetails.billNumber");
            AchRecordDetailCollection achRecordDetails = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(entityViewInfo);
            logger.error((Object)("achRecordDetails:" + achRecordDetails.size()));
            this.mainBills = new ArrayList<XmlBase>();
            int allMainBillNum = achRecordDetails.size();
            int allSubBillNum = 0;
            for (int i = 0; i < achRecordDetails.size(); ++i) {
                AchRecordDetailInfo info = achRecordDetails.get(i);
                ArchInfo archInfo = new ArchInfo(ctx, info.getId().toString(), info.getBillId(), true, ArchFlagEnum.UPDATE, this);
                archInfo.setDataCenter(ctx.getAIS());
                archInfo.setDocType(this.content.getXmlDocType());
                archInfo.setBillNumber(info.getBillNumber());
                boolean existsBill = true;
                if (info.getState().equals((Object)ArcStateEnum.ARC_FAIL)) {
                    ObjectUuidPK billUuidPK = new ObjectUuidPK(info.getBillId());
                    existsBill = DynamicObjectFactory.getLocalInstance((Context)ctx).exists(billUuidPK.getObjectType(), (IObjectPK)billUuidPK);
                    if (!existsBill) {
                        archInfo.setReArchFlag(ArchFlagEnum.DELETE);
                    }
                    this.mainBills.add(archInfo);
                } else if (info.getState().equals((Object)ArcStateEnum.ARC_2BE_DELETED)) {
                    archInfo.setReArchFlag(ArchFlagEnum.DELETE);
                    this.mainBills.add(archInfo);
                }
                AttachBillAchDetailCollection attachBillAchDetails = info.getAttachBillAchDetails();
                allSubBillNum += attachBillAchDetails.size();
                for (int j = 0; j < attachBillAchDetails.size(); ++j) {
                    AttachBillAchDetailInfo aInfo = attachBillAchDetails.get(j);
                    ArchInfo refInfo = new ArchInfo(ctx, aInfo.getId().toString(), aInfo.getBillId(), false, ArchFlagEnum.UPDATE, this);
                    archInfo.addRefBill(refInfo);
                    archInfo.setDataCenter(ctx.getAIS());
                    refInfo.setRecordBaseId(aInfo.getArcContent().getId().toString());
                    refInfo.setDocType(this.contents.get(aInfo.getArcContent().getId().toString()).getXmlDocType());
                    refInfo.setBillNumber(aInfo.getBillNumber());
                    refInfo.setMainBillID(archInfo.getBillId());
                    refInfo.setMainBillNumber(archInfo.getBillNumber());
                    if (!existsBill || aInfo.getState().equals((Object)ArcStateEnum.ARC_2BE_DELETED)) {
                        refInfo.setReArchFlag(ArchFlagEnum.DELETE);
                    }
                    if (existsBill && !aInfo.getState().equals((Object)ArcStateEnum.ARC_2BE_DELETED) && !aInfo.getState().equals((Object)ArcStateEnum.ARC_FAIL)) continue;
                    refInfo.addRefBill(archInfo);
                    this.setRefBill(aInfo.getArcContent().getId().toString(), refInfo);
                }
            }
            int allActualBillNum = allMainBillNum + allSubBillNum;
            ArcRecordInfo recordInfo = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(this.arcRecordId));
            int allRecordBillNum = recordInfo.getVoucherNum() + recordInfo.getOriginVcNum();
            if (0 == allActualBillNum) {
                Map<String, IObjectValue> billInfos = ArchUtils.getMainBills(ctx, this.content, this.periodInfo, this.org);
                this.init(ctx, this.content, billInfos, this.periodInfo, OperationEnum.FIRST_ARC);
            } else if (allActualBillNum > 0 && allRecordBillNum > allActualBillNum) {
                this.clearArchInfos();
                if (allActualBillNum == recordInfo.getVoucherNum() && recordInfo.getTotalNum() == allRecordBillNum) {
                    Map<String, IObjectValue> billInfos = ArchUtils.getMainBills(ctx, this.content, this.periodInfo, this.org);
                    this.reArcWaitRecord(ctx, this.content, billInfos, this.periodInfo);
                } else {
                    Map<String, IObjectValue> billInfos = ArchUtils.getMainBills(ctx, this.content, this.periodInfo, this.org);
                    this.init(ctx, this.content, billInfos, this.periodInfo, OperationEnum.FAIL_ARC);
                }
            } else if (allRecordBillNum == allActualBillNum) {
                ArchUtils.initArchNumCache(ctx, this.arcRecordId, this.size(), recordInfo);
                ArchUtils.saveAchRecordDetail(ctx, this.mainBills, this.arcRecordId);
            } else {
                logger.error((Object)("arcFailed\u6ca1\u6709\u6ee1\u8db3\u7684\u60c5\u51b5: allBIllNum" + allActualBillNum + ";info.getVoucherNum():" + recordInfo.getVoucherNum() + ";info.getOriginVcNum():" + recordInfo.getOriginVcNum()));
            }
            this.upload();
        }
        catch (Exception e) {
            ArchRecordUtils.writeLogs(ctx, this.mainBills, this.arcRecordId, new Exception("\u83b7\u53d6\u9644\u5c5e\u5355\u636e\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), e));
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(this.arcRecordId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
        }
    }

    public void clearArchInfos() {
        ArrayList<XmlBase> deleteMainBills = new ArrayList<XmlBase>();
        for (int i = 0; i < this.mainBills.size(); ++i) {
            ArchInfo archInfo = (ArchInfo)this.mainBills.get(i);
            if (!ArchFlagEnum.DELETE.equals((Object)archInfo.getReArchFlag())) continue;
            deleteMainBills.add(archInfo);
        }
        for (String bosType : this.contents.keySet()) {
            List<XmlBase> refBillList = this.refBills.get(bosType);
            ArrayList<ArchInfo> deleteRefBillList = new ArrayList<ArchInfo>();
            for (int i = 0; i < refBillList.size(); ++i) {
                ArchInfo archInfo = (ArchInfo)refBillList.get(i);
                if (!ArchFlagEnum.DELETE.equals((Object)archInfo.getReArchFlag())) continue;
                deleteRefBillList.add(archInfo);
            }
            this.refBills.put(bosType, deleteRefBillList);
        }
        this.mainBills.clear();
        this.mainBills = deleteMainBills;
    }

    private void reArcWaitRecord(Context ctx, RecordBaseInfo content, Map<String, IObjectValue> mainBillInfos, PeriodInfo period) throws BOSException {
        if (null == mainBillInfos) {
            return;
        }
        ArrayList<XmlBase> mainArchInfos = new ArrayList<XmlBase>();
        Iterator<String> it = mainBillInfos.keySet().iterator();
        try {
            while (it.hasNext()) {
                String billID = it.next();
                ArchInfo info = ArchUtils.getArchInfoOld(ctx, billID, null, OperationEnum.FAIL_ARC, this);
                if (null == info) continue;
                info.setDocType(content.getXmlDocType());
                info.setBillNumber(mainBillInfos.get(billID).getString("number"));
                mainArchInfos.add(info);
            }
            if (this.contents.size() != 0) {
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)this.arcRecordId));
                arcRecordInfo.setContent(content);
                ArchUtils.mutilSetRefArchInfos(ctx, arcRecordInfo, mainArchInfos, this.contents, OperationEnum.FIRST_ARC);
                for (int i = mainArchInfos.size() - 1; i >= 0; --i) {
                    ArchInfo mainArchInfo = (ArchInfo)mainArchInfos.get(i);
                    for (ArchInfo refInfo : mainArchInfo.getRefInfo()) {
                        if (null != refInfo.getReArchFlag()) {
                            this.setRefBill(refInfo.getRecordBaseId(), refInfo);
                        }
                        if (refInfo.getArchInfos() != null) continue;
                        refInfo.setArchInfos(this);
                    }
                    if (null != mainArchInfo.getReArchFlag()) continue;
                    mainArchInfos.remove(i);
                }
            }
            if (this.mainBills == null) {
                this.mainBills = new ArrayList<XmlBase>();
            }
            this.mainBills.addAll(mainArchInfos);
            ArchUtils.saveAchRecordDetail(ctx, this.mainBills, this.arcRecordId);
            ArchUtils.initArchNumCache(ctx, this.arcRecordId, this, OperationEnum.FAIL_ARC);
        }
        catch (Exception e) {
            if (this.mainBills == null) {
                this.mainBills = new ArrayList<XmlBase>();
            }
            this.mainBills.addAll(mainArchInfos);
            ArchRecordUtils.writeLogs(ctx, this.mainBills, this.arcRecordId, new Exception("\u83b7\u53d6\u9644\u5c5e\u5355\u636e\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), e));
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(this.arcRecordId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
            throw new BOSException((Throwable)e);
        }
    }

    public void clearRefArchInfos(String bosType) {
        this.refBills.put(bosType, new ArrayList());
    }

    public Map<String, RecordBaseInfo> getContents() {
        return this.contents;
    }

    public void setContents(Map<String, RecordBaseInfo> contents) {
        this.contents = contents;
    }

    public void setRefBill(String recordBaseInd, ArchInfo archInfo) {
        this.refBills.get(recordBaseInd).add(archInfo);
    }

    public void setRefBills(String bosType, List<XmlBase> archInfos) {
        this.refBills.put(bosType, archInfos);
    }

    public ArchSchemeInfo getAsInfo() {
        return this.asInfo;
    }

    public void setAsInfo(ArchSchemeInfo asInfo) {
        this.asInfo = asInfo;
    }

    public RecordBaseInfo getContent() {
        return this.content;
    }

    public void setContent(RecordBaseInfo content) {
        this.content = content;
    }

    public CompanyOrgUnitInfo getOrg() {
        return this.org;
    }

    public void setOrg(CompanyOrgUnitInfo org) {
        this.org = org;
    }

    public List<XmlBase> getMainBills() {
        return this.mainBills;
    }

    public Map<String, List<XmlBase>> getRefBills() {
        return this.refBills;
    }

    public RecordBaseInfo getContent(String bosType) {
        return this.contents.get(bosType);
    }

    public int getPeriod() {
        return this.period;
    }

    public void setArcContentType(ArcContentTypeEnum arcContentType) {
        this.arcContentType = arcContentType;
    }

    public ArcContentTypeEnum getArcContentType() {
        return this.arcContentType;
    }

    public PeriodInfo getPeriodInfo() {
        return this.periodInfo;
    }

    public void setPeriodInfo(PeriodInfo periodInfo) {
        this.periodInfo = periodInfo;
    }

    public void setMainBills(List<XmlBase> mainBills) {
        this.mainBills = mainBills;
    }

    public void setMainBill(XmlBase base) {
        this.mainBills.add(base);
    }

    public String getArcRecordId() {
        return this.arcRecordId;
    }

    public void setArcRecordId(String arcRecordId) {
        this.arcRecordId = arcRecordId;
    }
}

