/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ofd.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.ofd.handler.BizInvoiceTypeAdapter;
import com.kingdee.eas.el.rec.ofd.handler.InvoiceInfoHandler;
import com.kingdee.eas.el.rec.ofd.vo.Invoice;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class BizInvoiceInfoHandler
extends BizInvoiceTypeAdapter
implements InvoiceInfoHandler<Invoice> {
    @Override
    public List<Invoice> getInvoiceByBillId(Context ctx, String ... id) throws BOSException, SQLException, RecException {
        StringBuilder builder = new StringBuilder();
        builder.append(" select bte.FTicketNumber,bte.FTicketCode,bte.FSerialNo,bit.fnumber");
        builder.append(" from ");
        builder.append(this.getBizTicketTableName(ctx));
        builder.append(" bte inner join T_BC_InvoiceType bit on bte.FTicketTypeId = bit.fid ");
        builder.append(" where bte.FBillID = ?");
        if (id.length > 1) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u6682\u4e0d\u652f\u6301\u6570\u7ec4"});
        }
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{id[0]});
        ArrayList<Invoice> list = new ArrayList<Invoice>(iRowSet.size());
        while (iRowSet.next()) {
            String serialCodeNum;
            String queryMode;
            String fTicketCode = iRowSet.getString("FTicketCode");
            String fTicketNumber = iRowSet.getString("FTicketNumber");
            String FSerialNo = iRowSet.getString("FSerialNo");
            String invoiceType = this.getInvoCloudInvoiceType(ctx, iRowSet.getString("fnumber"));
            if (StringUtils.isEmpty((String)FSerialNo)) {
                queryMode = "0";
                serialCodeNum = fTicketCode + "_" + fTicketNumber;
            } else {
                queryMode = "1";
                serialCodeNum = FSerialNo;
            }
            Invoice invoiceInfo = new Invoice(fTicketCode, fTicketNumber, FSerialNo, serialCodeNum, queryMode, invoiceType);
            list.add(invoiceInfo);
        }
        return list;
    }

    protected abstract String getBizTicketTableName(Context var1);
}

