/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ofd.xbrlJSON;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.ofd.util.AS;
import com.kingdee.eas.el.rec.ofd.vo.Invoice;
import com.kingdee.eas.el.rec.ofd.vo.XBRLParam;
import com.kingdee.eas.el.rec.ofd.xbrlJSON.InvoiceJSON;
import com.kingdee.eas.el.rec.ofd.xbrlJSON.SpclInvoiceJSON;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class RaiInvoiceJSON
implements InvoiceJSON<Invoice> {
    private static Logger logger = Logger.getLogger((String)SpclInvoiceJSON.class.getName());
    private static String ElectronicInvoiceRailwayETicketNumber = "ElectronicInvoiceRailwayETicketNumber";
    private static String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
    private static String WhetherInvoiceHasBeenDeducted = "WhetherInvoiceHasBeenDeducted";
    private static String TaxPeriodOfInvoiceDeduction = "TaxPeriodOfInvoiceDeduction";
    private static String DateOfIssue = "DateOfIssue";
    private static String TotalAmountExcludingTax = "TotalAmountExcludingTax";
    private static String TaxRate = "TaxRate";
    private static String TaxAmount = "TaxAmount";

    @Override
    public JSONObject initXBRLJson(Context ctx, Invoice invoice, XBRLParam xbrlParam, String voucherId) {
        Map voucherInfo = (Map)xbrlParam.getVoucherMap().get(voucherId);
        JSONObject invoiceMap = (JSONObject)((Map)xbrlParam.getInvoiceMap().get(voucherId)).get(invoice.getUniqueCodeOfInvoice());
        logger.error((Object)("RaiInvoiceJSON--invoiceMap:" + JSONObject.toJSONString((Object)invoiceMap)));
        logger.error((Object)("RaiInvoiceJSON--invoice:" + JSONObject.toJSONString((Object)invoice)));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("NameOfAccountingEntity", (Object)AS.valueOf(xbrlParam.getCompanyMap().get("NameOfAccountingEntity")));
        jsonObject.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)AS.valueOf(xbrlParam.getCompanyMap().get("UnifiedSocialCreditCodeOfAccountingEntity")));
        jsonObject.put("WhetherInvoiceHasBeenChecked", (Object)("2".equals(AS.valueOf(invoiceMap.get("checkStatus"))) || "1".equals(AS.valueOf(invoiceMap.get("checkStatus"))) ? "true" : "false"));
        jsonObject.put(ElectronicInvoiceRailwayETicketNumber, (Object)AS.valueOf(invoiceMap.get("invoiceNo")));
        BigDecimal totalAmount = AS.valueBigDecimal(invoiceMap.get("totalAmount"));
        jsonObject.put("WhetherInvoiceIsRedInvoice", (Object)(totalAmount != null && BigDecimal.ZERO.compareTo(totalAmount) > 0 ? 1 : 0));
        jsonObject.put(WhetherInvoiceHasBeenBooked, (Object)"true");
        jsonObject.put(WhetherInvoiceHasBeenDeducted, (Object)"true");
        jsonObject.put(TaxPeriodOfInvoiceDeduction, (Object)"");
        jsonObject.put("InformationOfAccountingDocumentsTuple", (Object)voucherInfo);
        jsonObject.put(DateOfIssue, (Object)AS.valueOf(invoiceMap.get("issueDate")));
        jsonObject.put(TotalAmountExcludingTax, (Object)AS.valueOf(invoiceMap.get("invoiceAmount")));
        jsonObject.put(TaxRate, (Object)AS.valueOf(invoiceMap.get("taxRate")));
        jsonObject.put(TaxAmount, (Object)AS.valueOf(invoiceMap.get("totalTaxAmount")));
        return jsonObject;
    }

    @Override
    public String getCinfigId() {
        return "rai_receiver";
    }
}

