/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.outputmodule.archsys.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.HttpClientPoolInstance;
import com.kingdee.eas.el.rec.tool.MD5;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class InvoUtil {
    private static Logger logger = Logger.getLogger((String)InvoUtil.class.getName());
    private static String DOMAIN_NAME = "https://api.piaozone.com";
    private static String DATASOURCE = "eas";

    public static String postInterface(String url, String params) throws Exception {
        CloseableHttpClient httpclient = HttpClientPoolInstance.getInstance().getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(params, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                String jsonString;
                HttpEntity responseEntity = response.getEntity();
                String string = jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                return string;
            }
            try {
                throw new Exception("error:" + state);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            httpPost.abort();
        }
    }

    public static JSONObject getSuccessData(String url, String params) throws Exception {
        JSONObject obj = JSONObject.fromObject((Object)InvoUtil.postInterface(url, params));
        if (!"0000".equals(obj.get("errcode"))) {
            logger.error((Object)("accessToken error:" + params + "--" + url + "--" + obj.toString()));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u53d1\u7968\u4e91\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + obj.getString("errcode") + ":" + obj.getString("description")));
        }
        return obj;
    }

    private static com.alibaba.fastjson.JSONObject getSuccessJSON(String url, String params) throws Exception {
        com.alibaba.fastjson.JSONObject obj = JSON.parseObject((String)InvoUtil.postInterface(url, params));
        if (!"0000".equals(obj.get((Object)"errcode"))) {
            logger.error((Object)("accessToken error:" + params + "--" + url + "--" + obj.toString()));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u53d1\u7968\u4e91\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + obj.getString("errcode") + ":" + obj.getString("description")));
        }
        return obj;
    }

    public static String uploadFile(Context ctx, String ip, InputStream is, String paramString, String accessToken) throws Exception {
        int chunkSize = Integer.parseInt(ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_UPLOAD_LENGTH));
        com.alibaba.fastjson.JSONObject jsonParm = JSON.parseObject((String)paramString);
        byte[] data = new byte[is.available()];
        is.read(data);
        is.close();
        BASE64Encoder base64Encoder = new BASE64Encoder();
        String filebase64 = base64Encoder.encodeBuffer(data);
        if ((long)(filebase64.getBytes().length + 24000) < 0x100000L * (long)chunkSize) {
            jsonParm.put("filebase64", (Object)filebase64);
            String upload_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_UPLOAD);
            String url = ip + upload_arch_sys + accessToken;
            return InvoUtil.postInterface(url, JSONUtils.convertObjectToJson((Context)ctx, (Object)jsonParm));
        }
        String fileMd5 = MD5.getMD5(ByteBuffer.wrap(data));
        jsonParm.put("fileMd5", (Object)fileMd5);
        com.alibaba.fastjson.JSONObject result1 = InvoUtil.getuploadId(ctx, jsonParm, ip, accessToken);
        if (null != result1) {
            InvoUtil.toUploadChunk(ctx, result1, new ByteArrayInputStream(data), fileMd5, ip, accessToken);
            return InvoUtil.toMergeFile(ctx, fileMd5, ip, accessToken);
        }
        throw new EASBizException(new NumericExceptionSubItem("00", "\u53d1\u7968\u4e91\u8fd4\u56deuploadId\u4e3a\u7a7a"));
    }

    private static com.alibaba.fastjson.JSONObject getuploadId(Context ctx, com.alibaba.fastjson.JSONObject jsonObject, String url, String accessToken) throws Exception {
        com.alibaba.fastjson.JSONObject result = null;
        String upload_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_UPLOAD_ID);
        String getuploadIdUrl = url + upload_arch_sys + accessToken;
        String params = jsonObject.toJSONString();
        com.alibaba.fastjson.JSONObject resultJosn = InvoUtil.getSuccessJSON(getuploadIdUrl, params);
        result = resultJosn.getJSONObject("data");
        return result;
    }

    private static void toUploadChunk(Context ctx, com.alibaba.fastjson.JSONObject jsonObject, InputStream is, String fileMD5, String url, String accessToken) throws Exception {
        String upload_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_UPLOAD_BLOCK);
        String toUploadChunkUrl = url + upload_arch_sys + accessToken;
        Integer chunkSize = Integer.parseInt(ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_UPLOAD_BLOCK_LENGTH));
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            long startTime = System.currentTimeMillis();
            Integer chunkSizeByte = chunkSize * 1024 * 1024;
            long length = is.available();
            double aa = (double)length / (double)chunkSizeByte.intValue();
            int chunkTotal = (int)Math.ceil(aa);
            params.put("total", chunkTotal);
            params.put("uploadId", jsonObject.getString("uploadId"));
            params.put("chunkSize", chunkSizeByte);
            params.put("fileMd5", fileMD5);
            byte[] byt = new byte[chunkSizeByte.intValue()];
            for (int i = 1; i <= chunkTotal; ++i) {
                if (i == chunkTotal) {
                    byt = new byte[(int)(length - (long)(chunkSizeByte * (chunkTotal - 1)))];
                    params.put("chunkSize", (int)(length - (long)(chunkSizeByte * (chunkTotal - 1))));
                }
                is.read(byt);
                params.put("current", i);
                params.put("bytes", byt);
                ByteBuffer wrap = ByteBuffer.wrap(byt);
                params.put("chunkMd5", MD5.getMD5(wrap));
                com.alibaba.fastjson.JSONObject jSONObject = InvoUtil.getSuccessJSON(toUploadChunkUrl, JSON.toJSONString(params));
            }
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0a\u4f20\u5206\u7247\u6587\u4ef6\u5f02\u5e38\uff0c\u5206\u5757\u53c2\u6570\uff1a" + SafeFilterUtils.vaildLog((String)((Object)params).toString())), (Throwable)e);
            throw e;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"\u6d41\u5173\u95ed\u5f02\u5e38");
                }
            }
        }
    }

    private static String toMergeFile(Context ctx, String fileMd5, String url, String accessToken) throws Exception {
        String upload_arch_sys = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_WSDL_TAIL_INVO_UPLOAD_MERGE);
        String toUploadChunkUrl = url + upload_arch_sys + accessToken;
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        jsonObject.put("fileMd5", (Object)fileMd5);
        return InvoUtil.postInterface(toUploadChunkUrl, JSONUtils.convertObjectToJson((Context)ctx, (Object)jsonObject));
    }
}

