/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.outputmodule.invosys.helper;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.app.util.InvoConstant;
import com.kingdee.eas.el.rec.ofd.vo.Invoice;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.InvoUtil;
import com.kingdee.eas.el.rec.outputmodule.invosys.helper.NoticeInvoSysHelper;
import com.kingdee.eas.el.rec.outputmodule.invosys.pojo.InvoInfo;
import com.kingdee.eas.el.rec.outputmodule.util.PostUtils;
import com.kingdee.eas.el.rec.tool.AES128;
import com.kingdee.eas.el.rec.tool.MD5;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class NoticeInvoSysHelper_INVO
extends NoticeInvoSysHelper {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.outputmodule.helper.NoticeInvoSysHelper_INVO");
    private static TokenInfo tokenInfo;
    private static String ip;
    private static final String invoKey = "!!king?DeE|12345";

    @Override
    public String getInvoUpLoadURl(Context ctx, InvoInfo invoInfo) throws Exception {
        String invoiceData = "";
        String billNumber = "";
        if (invoInfo != null) {
            billNumber = invoInfo.getBillNumber();
        }
        String access_token = this.getAccessToken(ctx);
        try {
            billNumber = AES128.encrypt(billNumber, invoKey);
        }
        catch (Exception e1) {
            this.logger.error((Object)"\u52a0\u5bc6\u5931\u8d25", (Throwable)e1);
        }
        String ivoiceIp = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)InvoConstant.ARCH_INVOICE_CLOUD_SYS);
        if (!StringUtils.isEmpty((String)ivoiceIp)) {
            ip = ivoiceIp;
        }
        String url = ip + "/m6/bill/expense/invoices/query?access_token=" + access_token;
        com.kingdee.bos.json.JSONObject param = new com.kingdee.bos.json.JSONObject();
        try {
            param.put("billNumber", (Object)billNumber);
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        HashMap invoUpLoadURlMap = new HashMap();
        try {
            invoiceData = AES128.decrypt(PostUtils.postInterface(url, param.toString()), invoKey);
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u53d1\u7968\u4e91\u4e0b\u8f7d\u5730\u5740\u5931\u8d25" + e.getMessage(), e);
        }
        return invoiceData;
    }

    @Override
    public Map<String, com.alibaba.fastjson.JSONObject> getInvoiceInfos(Context ctx, List<Invoice> numCodes) throws Exception {
        if (numCodes == null || numCodes.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        String accessToken = this.getAccessToken(ctx);
        ip = this.getUrl(ctx, "");
        String url = ip + "/m6/bill/invoice/serialnos/query?access_token=" + accessToken;
        HashMap<String, com.alibaba.fastjson.JSONObject> result = new HashMap<String, com.alibaba.fastjson.JSONObject>(numCodes.size());
        for (int i = 0; i < numCodes.size(); ++i) {
            com.kingdee.bos.json.JSONObject param = new com.kingdee.bos.json.JSONObject();
            param.put("invoiceCode", (Object)numCodes.get(i).getCode());
            param.put("invoiceNo", (Object)numCodes.get(i).getNumber());
            param.put("serialNos", (Object)numCodes.get(i).getSerialNum());
            this.logger.error((Object)param.toString());
            com.alibaba.fastjson.JSONObject successData = PostUtils.getSuccessJSON(url, AES128.encrypt(param.toString(), invoKey));
            JSONArray data = (JSONArray)successData.get((Object)"data");
            if (CollectionUtils.isEmpty((Collection)data)) {
                this.logger.error((Object)(param.toString() + "\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a \uff0c\uff0c \u7ee7\u7eed\u83b7\u53d6\u5176\u4ed6\u53d1\u7968\u4fe1\u606f\uff01"));
                result.put(numCodes.get(i).getUniqueCodeOfInvoice(), new com.alibaba.fastjson.JSONObject());
                continue;
            }
            result.put(numCodes.get(i).getUniqueCodeOfInvoice(), (com.alibaba.fastjson.JSONObject)data.get(0));
        }
        return result;
    }

    protected String getAccessToken(Context ctx) throws Exception {
        String token;
        if (null != tokenInfo && !StringUtils.isEmpty((String)(token = tokenInfo.getToken()))) {
            return token;
        }
        String accessToken = "";
        String clientId = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_INVOICE_FPY_APPACCOUNT);
        String sign = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_INVOICE_FPY_APPSECRET);
        String timestamp = System.currentTimeMillis() + "";
        sign = clientId + sign + timestamp;
        try {
            sign = MD5.md5crypt(sign);
        }
        catch (Exception e1) {
            this.logger.error((Object)("\u52a0\u7b7e\u5931\u8d25" + e1.getMessage()));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u52a0\u7b7e\u5931\u8d25\uff01"), (Throwable)e1);
        }
        String ip = this.getUrl(ctx, "");
        JSONObject param = new JSONObject();
        param.put((Object)"client_id", (Object)clientId);
        param.put((Object)"sign", (Object)sign);
        param.put((Object)"timestamp", (Object)timestamp);
        String access_token = "/base/oauth/token";
        String url = ip + access_token;
        int expireTime = 0;
        try {
            JSONObject successData = InvoUtil.getSuccessData(url, param.toString());
            accessToken = (String)successData.get("access_token");
            Integer expireTimeS = (Integer)successData.get("expires_in");
            if (null != expireTimeS) {
                expireTime = expireTimeS;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("accessToken error:" + param.toString() + "--" + url));
            throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage() + ",\u53d1\u7968\u7cfb\u7edf\u8ba4\u8bc1\u7801\u5931\u8d25:param:" + param + "url:" + url});
        }
        tokenInfo = new TokenInfo(accessToken, expireTime);
        return accessToken;
    }

    public String getUrl(Context ctx, String defUrl) throws RecException {
        String httpsEnable = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_SYS_HTTPSENABLE);
        String ip = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_INVOICE_IP);
        String port = ArchConfigUtil.getPropertiesValue((Context)ctx, (String)ArchConstant.ARCH_INVOICE_PORT);
        if (StringUtils.isEmpty((String)ip)) {
            if (StringUtils.isEmpty((String)defUrl)) {
                throw new RecException(RecException.UNKNOWN, new Object[]{"\u6ca1\u6709\u914d\u7f6e\u53d1\u7968\u7cfb\u7edf\u7cfb\u7edf\u5730\u5740"});
            }
            return defUrl;
        }
        if (!ip.startsWith("http")) {
            ip = "1".equals(httpsEnable) ? "https://" + ip : "http://" + ip;
        }
        if (!StringUtils.isEmpty((String)port)) {
            ip = ip + ":" + port;
        }
        return ip;
    }

    static {
        ip = "https://api.piaozone.com";
    }

    private class TokenInfo {
        private String token = "";
        private Date expiresTime;

        public TokenInfo() {
        }

        public TokenInfo(String token, int expiresT) {
            this.token = token;
            expiresT = 0 == expiresT ? 5400 : expiresT;
            this.expiresTime = new Date(new Date().getTime() + (long)((expiresT - 60) * 1000));
        }

        public String getToken() {
            if (StringUtils.isEmpty((String)this.token)) {
                return "";
            }
            Date now = new Date();
            if (now.after(this.expiresTime)) {
                return "";
            }
            return this.token;
        }
    }
}

