/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.thread;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.RejectedExecutionHandlerEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.OperationEnum;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.thread.GetRefBillsThread;
import com.kingdee.eas.el.rec.thread.SetArchInfoProperThread;
import com.kingdee.eas.el.rec.thread.UploadBillArchInfosThread;
import com.kingdee.eas.el.rec.thread.UploadReportArchInfosThread;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import com.kingdee.eas.el.rec.tool.ThreadPoolInitFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UploadArchInfosThreadPool {
    public static final String THREAD_KEEPALIVETIME = "thread.keepalivetime";
    public static final String UPLOADFILETHREAD_COREPOOLSIZE = "thread.corepoolsize";
    public static final String UPLOADFILETHREAD_MAXPOOLSIZE = "thread.maxpoolsize";
    public static final String GETREFBILLTHREAD_COREPOOLSIZE = "thread.refbill.corepoolsize";
    public static final String GETREFBILLTHREAD_MAXPOOLSIZE = "thread.refbill.maxpoolsize";
    public static final String UPLOADFILE_THREADPOOLNAME = "\u4e0a\u4f20\u9644\u4ef6\u7ebf\u7a0b\u6c60";
    public static final String GETREFBILL_THREADPOOLNAME = "\u83b7\u53d6\u5173\u8054\u5355\u636e\u7ebf\u7a0b\u6c60";
    private static ThreadPoolExecutor executor = null;
    private static ThreadPoolExecutor getrefBillexecutor = null;

    public static synchronized void initThreadPool(Context ctx, boolean isRefreash) {
        DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
        DynamicThreadPoolProperties poolProperties = manager.getDynamicThreadPoolProperties();
        if (executor == null) {
            ThreadPoolProperties upLoadFileProperties = new ThreadPoolBuilder().ctx(ctx).applicationName("EL_REC").threadPoolName(UPLOADFILE_THREADPOOLNAME).corePoolSize(ThreadPoolInitFactory.getThreadPoolParam(ctx, UPLOADFILETHREAD_COREPOOLSIZE, Runtime.getRuntime().availableProcessors() * 2)).maximumPoolSize(ThreadPoolInitFactory.getThreadPoolParam(ctx, UPLOADFILETHREAD_MAXPOOLSIZE, Runtime.getRuntime().availableProcessors() * 2)).keepAliveTime(Long.valueOf(ThreadPoolInitFactory.getThreadPoolParam(ctx, THREAD_KEEPALIVETIME, 30000))).timeUnit(TimeUnit.MILLISECONDS).queueCapacity(200).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).rejectedExecutionType(RejectedExecutionHandlerEnum.CALLER_RUNS_POLICY).getProperties();
            if (!poolProperties.exists(upLoadFileProperties)) {
                poolProperties.getExecutors().add(upLoadFileProperties);
            }
            manager.createThreadPoolExecutor(poolProperties);
            executor = manager.getThreadPoolExecutor("EL_REC", UPLOADFILE_THREADPOOLNAME);
        }
        if (getrefBillexecutor == null) {
            ThreadPoolProperties getRefBillProperties = new ThreadPoolBuilder().ctx(ctx).applicationName("EL_REC").threadPoolName(GETREFBILL_THREADPOOLNAME).corePoolSize(ThreadPoolInitFactory.getThreadPoolParam(ctx, GETREFBILLTHREAD_COREPOOLSIZE, Runtime.getRuntime().availableProcessors() * 2)).maximumPoolSize(ThreadPoolInitFactory.getThreadPoolParam(ctx, GETREFBILLTHREAD_MAXPOOLSIZE, Runtime.getRuntime().availableProcessors() * 2)).keepAliveTime(Long.valueOf(ThreadPoolInitFactory.getThreadPoolParam(ctx, THREAD_KEEPALIVETIME, 30000))).timeUnit(TimeUnit.MILLISECONDS).queueCapacity(2000).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).rejectedExecutionType(RejectedExecutionHandlerEnum.CALLER_RUNS_POLICY).getProperties();
            if (!poolProperties.exists(getRefBillProperties)) {
                poolProperties.getExecutors().add(getRefBillProperties);
            }
            manager.createThreadPoolExecutor(poolProperties);
            getrefBillexecutor = manager.getThreadPoolExecutor("EL_REC", GETREFBILL_THREADPOOLNAME);
        }
        KDNoteWebServerHelper.allPdfTime = 0L;
        KDNoteWebServerHelper.allPdfSize = 0L;
        KDNoteWebServerHelper.map.clear();
    }

    public static void execute(Context ctx, Runnable runnable) {
        UploadArchInfosThreadPool.initThreadPool(ctx, false);
        executor.execute(runnable);
    }

    @Deprecated
    public static void execute(Context ctx, CompanyOrgUnitInfo orgUnitInfo, PeriodInfo periodInfo, List<ArchFormatInfo> archFormatInfos, String taskFlag) {
        UploadArchInfosThreadPool.initThreadPool(ctx, false);
        executor.execute(new UploadReportArchInfosThread(ctx, orgUnitInfo, periodInfo, archFormatInfos, taskFlag));
    }

    @Deprecated
    public static void execute(UploadBillArchInfosThread uploadBillArchInfosThread) {
        UploadArchInfosThreadPool.initThreadPool(uploadBillArchInfosThread.getCtx(), false);
        executor.execute(uploadBillArchInfosThread);
    }

    public static Future<XmlBase> submit(Context ctx, XmlBase xmlBase, Map<String, RecordBaseInfo> contents, ArcRecordInfo recordInfo, OperationEnum operation) {
        UploadArchInfosThreadPool.initThreadPool(ctx, false);
        return getrefBillexecutor.submit(new GetRefBillsThread(ctx, xmlBase, contents, recordInfo, operation));
    }

    public static Future<XmlBase> submit(Context ctx, ArchInfo info, String bosType, Boolean invoice, int num) {
        UploadArchInfosThreadPool.initThreadPool(ctx, false);
        return executor.submit(new SetArchInfoProperThread(ctx, info, bosType, invoice, num));
    }

    public static String getPoolMsg() {
        StringBuffer sb = new StringBuffer();
        sb.append("executor:{PoolSize:").append(executor.getPoolSize()).append(",CorePoolSize:").append(executor.getCorePoolSize()).append(",MaximumPoolSize:").append(executor.getMaximumPoolSize()).append(",KeepAliveTime:").append(executor.getKeepAliveTime(TimeUnit.MILLISECONDS)).append(",LargestPoolSize:").append(executor.getLargestPoolSize()).append(",CompletedTaskCount:").append(executor.getCompletedTaskCount()).append(",ActiveCount:").append(executor.getActiveCount()).append(",TaskCount:").append(executor.getTaskCount()).append("}");
        sb.append("getrefBillexecutor:{PoolSize:").append(getrefBillexecutor.getPoolSize()).append(",CorePoolSize:").append(getrefBillexecutor.getCorePoolSize()).append(",MaximumPoolSize:").append(getrefBillexecutor.getMaximumPoolSize()).append(",KeepAliveTime:").append(getrefBillexecutor.getKeepAliveTime(TimeUnit.MILLISECONDS)).append(",LargestPoolSize:").append(getrefBillexecutor.getLargestPoolSize()).append(",CompletedTaskCount:").append(getrefBillexecutor.getCompletedTaskCount()).append(",ActiveCount:").append(getrefBillexecutor.getActiveCount()).append(",TaskCount:").append(getrefBillexecutor.getTaskCount()).append("}\n");
        sb.append("KDNoteWebServerHelper.allTime:" + KDNoteWebServerHelper.allPdfTime).append(",KDNoteWebServerHelper.allPdfSize:" + KDNoteWebServerHelper.allPdfSize).append(",KDNoteWebServerHelper.signleTime:" + (float)KDNoteWebServerHelper.allPdfTime / (float)KDNoteWebServerHelper.allPdfSize).append(",KDNoteWebServerHelper.lastUpdateTime:" + KDNoteWebServerHelper.lastUpdateTime + ",\t" + new SimpleDateFormat("yyy-MM-dd HH:mm:ss").format(new Date(KDNoteWebServerHelper.lastUpdateTime)));
        if (KDNoteWebServerHelper.map != null) {
            for (String key : KDNoteWebServerHelper.map.keySet()) {
                if (key.endsWith(".count")) continue;
                sb.append("\n" + key + ":" + KDNoteWebServerHelper.map.get(key)).append("\n" + key + ".count:" + KDNoteWebServerHelper.map.get(key + ".count")).append(",signleTime:" + (float)KDNoteWebServerHelper.map.get(key).longValue() / (float)KDNoteWebServerHelper.map.get(key + ".count").longValue());
            }
        }
        return sb.toString();
    }

    public static ThreadPoolExecutor getExecutor() {
        return executor;
    }

    public static int getFileUploadThreadPoolSize() {
        return executor != null ? executor.getMaximumPoolSize() : 20;
    }
}

