/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.DateUtil;
import com.kingdee.eas.el.rec.tool.engine.BillParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public class UploadBillArchInfosThread
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.thread.UploadBillArchInfosThread");
    private Context ctx;
    private CompanyOrgUnitInfo orgUnitInfo;
    private PeriodInfo periodInfo;
    private String taskFlag;
    private RecordBaseInfo content;
    private List<XmlBase> bills;
    private String subName;
    private String arcRecordId;

    public UploadBillArchInfosThread(Context ctx, CompanyOrgUnitInfo orgUnitInfo, PeriodInfo periodInfo, String taskFlag, RecordBaseInfo content, List<XmlBase> bills, String subName) {
        this.ctx = ctx;
        this.orgUnitInfo = orgUnitInfo;
        this.periodInfo = periodInfo;
        this.taskFlag = taskFlag;
        this.content = content;
        this.bills = bills;
        this.subName = subName;
    }

    @Override
    public void run() {
        try {
            WebContextUtil.initRpcConfig((Context)this.ctx);
            if (this.content.isIsRefBill()) {
                ArcRecordInfo recordInfo = new ArcRecordInfo();
                recordInfo.setId(BOSUuid.read((String)this.arcRecordId));
                recordInfo.setContent(this.content);
                this.content.setRefMainBill(recordInfo.getContent());
                ArchUtils.saveAttachBillAchDetail(this.ctx, this.content, this.bills, recordInfo);
            }
            ((BillParsingEngineUtil)ParsingEngineUtil.getInstance(this.ctx, this.content)).fillXmlBaseData(BOSObjectType.create((String)this.content.getBillType().getBosType()), this.bills, this.content, this.periodInfo);
            StringBuilder xmlName = new StringBuilder(this.content.getBillType().getNumber());
            xmlName.append("_").append(this.orgUnitInfo.getNumber()).append("_").append(this.periodInfo.getNumber()).append("_").append(this.subName).append("_").append(DateUtil.format(new Date(), "YYYYMMddHHmmss")).append(".xml");
            logger.error((Object)("UploadBillArchInfosThread," + Thread.currentThread().getName() + ":" + xmlName.toString()));
            ArchUtils.setArchProperties(this.ctx, this.arcRecordId, this.bills, this.content.getBillType().getBosType(), this.content.isInvoice());
            Document document = ParsingEngineUtil.getInstance(this.ctx, this.content).getXMLFromInfoByConfig(this.bills, this.content);
            ArrayList<ArchFormatInfo> list = new ArrayList<ArchFormatInfo>();
            ArchFormatInfo formatInfo = new ArchFormatInfo();
            formatInfo.setTaskFlag(this.taskFlag);
            formatInfo.setXmlName(xmlName.toString());
            formatInfo.setXml(new ByteArrayInputStream(document.asXML().getBytes()));
            formatInfo.setXmlBases(new ArrayList<XmlBase>(this.bills));
            formatInfo.setContent(this.content);
            ArcRecordInfo info = ArcRecordFactory.getLocalInstance(this.ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(this.arcRecordId));
            formatInfo.setRecordInfo(info);
            list.add(formatInfo);
            String arch_type = ArchConfigUtil.getPropertiesValue((Context)this.ctx, (String)ArchConstant.ARCH_SYS_TYPE);
            NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(this.ctx, arch_type);
            noticeArchSysHelper.uploadArchInfos(this.ctx, this.orgUnitInfo, this.periodInfo, list);
        }
        catch (Exception e) {
            logger.error((Object)(this.arcRecordId + ":UploadBillArchInfosThread\u91cc\u9762\u7684\u5f02\u5e38!"), (Throwable)e);
            ArchRecordUtils.writeLogs(this.ctx, this.bills, this.arcRecordId, e);
        }
    }

    public String getArcRecordId() {
        return this.arcRecordId;
    }

    public void setArcRecordId(String arcRecordId) {
        this.arcRecordId = arcRecordId;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

