/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.GenerateRechRecordFacadeFactory;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArchRecordUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.tool.ArchRecordUtils");
    private static Map<String, RecordLock> LOCK = new HashMap<String, RecordLock>();

    public static void updateRecordData(Context ctx, String recordId, List Ids, Map param) throws Exception {
        try {
            ArcRecordInfo info;
            Set resultSet = GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateBillAndReportRecordDetail(recordId, Ids, param);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)recordId)) {
                recordId = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(" where id = '" + ((Map)Ids.get(0)).get("id") + "' ").get(0).getArcRecord().getId().toString();
            }
            if (ArchUtils.isValidate(ctx, info = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(recordId)), Ids.size())) {
                HashSet<String> tmpSet = new HashSet<String>();
                tmpSet.add(recordId);
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateBillArcRecord(tmpSet, param);
                if (param != null && Boolean.valueOf(param.get("notic").toString()).booleanValue()) {
                    String batchNumber = param.get("batchNumber").toString();
                    ThreadUtil.removeLock(batchNumber);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("notic error:" + e.getMessage()), (Throwable)e);
            try {
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateRcordState(recordId, ArcStateEnum.ARC_FAIL);
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordId, ArcStateEnum.ARC_FAIL, "INVO notic error!", e.getStackTrace().toString());
            }
            catch (Exception e2) {
                logger.error((Object)e2);
            }
        }
    }

    public static void writeLog(Context ctx, XmlBase xmlBase, String recordId, Exception e) {
        try {
            String stack;
            ArrayList list = new ArrayList();
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            if (xmlBase instanceof ArchInfo) {
                tmpMap.put("id", ((ArchInfo)xmlBase).getId());
            } else if (xmlBase instanceof ReportArchInfo) {
                tmpMap.put("id", ((ReportArchInfo)xmlBase).getRecordId());
            }
            tmpMap.put("return", "0");
            String message = e.getMessage();
            if (!StringUtils.isEmpty((String)message)) {
                if (message.length() > 1000) {
                    message = message.substring(0, 1000);
                }
                tmpMap.put("desc", message);
            }
            if (!StringUtils.isEmpty((String)(stack = RECStringUtil.exception2String(e)))) {
                if (stack.length() > 4000) {
                    stack = stack.substring(0, 4000);
                }
                tmpMap.put("stack", stack);
            }
            list.add(tmpMap);
            Set set = GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateBillAndReportRecordDetail(recordId, list, null);
        }
        catch (Exception ee) {
            logger.error((Object)"\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38", (Throwable)ee);
        }
    }

    public static void writeLogs(Context ctx, List<XmlBase> archInfos, String recordId, Exception e) {
        try {
            ArrayList list = new ArrayList();
            HashMap<String, String> exceptionMap = new HashMap<String, String>();
            exceptionMap.put("desc", e.getMessage());
            exceptionMap.put("stack", RECStringUtil.exception2String(e));
            for (int i = 0; i < archInfos.size(); ++i) {
                String stack;
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", archInfos.get(i).getId());
                tmpMap.put("return", "0");
                String message = e.getMessage();
                if (!StringUtils.isEmpty((String)message)) {
                    if (message.length() > 1000) {
                        message = message.substring(0, 1000);
                    }
                    tmpMap.put("desc", message);
                }
                if (!StringUtils.isEmpty((String)(stack = (String)exceptionMap.get("stack")))) {
                    if (stack.length() > 4000) {
                        stack = stack.substring(0, 4000);
                    }
                    tmpMap.put("stack", stack);
                }
                list.add(tmpMap);
            }
            Set resultSet = GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateBillAndReportRecordDetail(recordId, list, null);
            ArcRecordInfo info = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
            if (ArcContentTypeEnum.BILL.equals((Object)info.getContentType()) && list.size() > 0) {
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateRecordFailNum(recordId, list.size(), ((ArchInfo)archInfos.get(0)).getIsMainBill());
            }
            if (ArchUtils.isValidate(ctx, info, archInfos.size())) {
                HashSet<String> tmpSet = new HashSet<String>();
                tmpSet.add(recordId);
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateBillArcRecord(tmpSet, exceptionMap);
            }
        }
        catch (Exception ee) {
            logger.error((Object)"\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38", (Throwable)ee);
        }
    }

    public static void writeReportLog(Context ctx, String recordId) {
        try {
            GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateRcordState(recordId, ArcStateEnum.ARC_FAIL);
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u62a5\u8868\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
    }

    static class RecordLock {
        private volatile int count = 0;

        RecordLock() {
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
        }

        public void decrement() {
            --this.count;
        }
    }
}

